/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.kaptcha.text.impl;

import com.google.code.kaptcha.text.WordRenderer;
import com.google.code.kaptcha.util.Configurable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.util.Random;

public class DefaultWordRenderer
extends Configurable
implements WordRenderer {
    @Override
    public BufferedImage renderWord(String word, int width, int height) {
        int fontSize = this.getConfig().getTextProducerFontSize();
        Font[] fonts = this.getConfig().getTextProducerFonts(fontSize);
        Color color = this.getConfig().getTextProducerFontColor();
        int charSpace = this.getConfig().getTextProducerCharSpace();
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2D = image.createGraphics();
        g2D.setColor(color);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g2D.setRenderingHints(hints);
        FontRenderContext frc = g2D.getFontRenderContext();
        Random random = new Random();
        int startPosY = (height - fontSize) / 5 + fontSize;
        char[] wordChars = word.toCharArray();
        Font[] chosenFonts = new Font[wordChars.length];
        int[] charWidths = new int[wordChars.length];
        int widthNeeded = 0;
        for (int i2 = 0; i2 < wordChars.length; ++i2) {
            chosenFonts[i2] = fonts[random.nextInt(fonts.length)];
            char[] charToDraw = new char[]{wordChars[i2]};
            GlyphVector gv = chosenFonts[i2].createGlyphVector(frc, charToDraw);
            charWidths[i2] = (int)gv.getVisualBounds().getWidth();
            if (i2 > 0) {
                widthNeeded += 2;
            }
            widthNeeded += charWidths[i2];
        }
        int startPosX = (width - widthNeeded) / 2;
        for (int i3 = 0; i3 < wordChars.length; ++i3) {
            g2D.setFont(chosenFonts[i3]);
            char[] charToDraw = new char[]{wordChars[i3]};
            g2D.drawChars(charToDraw, 0, charToDraw.length, startPosX, startPosY);
            startPosX = startPosX + charWidths[i3] + charSpace;
        }
        return image;
    }
}

