/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.dao;

import com.roma.romaapi.utils.CommonUtil;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class ApiDao {
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Autowired
    private CommonUtil commonUtil;

    public Map<String, Object> adminInfoQueryForMap(String adminName) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("admin_name", adminName);
            Map<String, Object> resMap2 = this.namedParameterJdbcTemplate.queryForMap("SELECT * FROM `admin_user` where admin_name = :admin_name AND is_enable=1", paramMap);
            return resMap2;
        }
        catch (EmptyResultDataAccessException e) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("sysErrorCode", "500");
            return resultMap;
        }
    }

    public Map<String, Object> userInfoByIdQueryForMap(String userID) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("admin_id", userID);
            Map<String, Object> resMap2 = this.namedParameterJdbcTemplate.queryForMap("SELECT * FROM `admin_user` where id = :admin_id AND is_enable=1", paramMap);
            return resMap2;
        }
        catch (EmptyResultDataAccessException e) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("sysErrorCode", "500");
            return resultMap;
        }
    }

    public Map<String, Object> enableAndNoEnableUserInfoByIdQueryForMap(String userID) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("admin_id", userID);
            Map<String, Object> resMap2 = this.namedParameterJdbcTemplate.queryForMap("SELECT * FROM `admin_user` where id = :admin_id ", paramMap);
            return resMap2;
        }
        catch (EmptyResultDataAccessException e) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("sysErrorCode", "500");
            return resultMap;
        }
    }

    public void addPermissions(Map bindValue) {
        String sql = "INSERT INTO `roma_permissions` (`parent_id`,`page_id`,`sort`,`value`,`display_name`,`description`,`type`,`created_at`,`icon`,`is_enable`) value(:parent_id,:page_id,:sort,:value,:display_name,:description,:type,:created_at,:icon,:is_enable) ";
        Integer row = this.namedParameterJdbcTemplate.update(sql, bindValue);
    }

    public Map getDetailsInfoByIdAndType(String tableName, String id) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("id", id);
            Map<String, Object> resMap2 = this.namedParameterJdbcTemplate.queryForMap("SELECT * FROM `" + tableName + "` where id = :id", paramMap);
            return resMap2;
        }
        catch (EmptyResultDataAccessException e) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("sysErrorCode", "500");
            return resultMap;
        }
    }

    public List<Map<String, Object>> getAllPermissionByRoleId(String id) {
        String sql = " SELECT * FROM `roma_permission_role` WHERE role_id=:id ";
        HashMap<String, String> bindValue = new HashMap<String, String>();
        bindValue.put("id", id);
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(sql, bindValue);
        return resMap2;
    }

    public List<Map<String, Object>> getAllRoleByUserId(String id) {
        String sql = " SELECT * FROM `roma_role_user` WHERE user_id=:id ";
        HashMap<String, String> bindValue = new HashMap<String, String>();
        bindValue.put("id", id);
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(sql, bindValue);
        return resMap2;
    }

    public Integer addRole(Map<String, Object> bindValue) {
        String insertSql = " INSERT INTO `roma_roles` (`role_name`,`role_description`,`is_enable`,`created_at`)  VALUES (:roleName,:roleDesc,:isEnable,:createdAt)  ";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        Integer row = this.namedParameterJdbcTemplate.update(insertSql, new MapSqlParameterSource(bindValue), keyHolder);
        int k = keyHolder.getKey().intValue();
        return k;
    }

    public Integer editRole(Map<String, Object> bindValue) {
        String editSql = " UPDATE `roma_roles` SET `role_name`=:roleName,`role_description`=:roleDesc,`is_enable`=:isEnable WHERE id=:id";
        Integer row = this.namedParameterJdbcTemplate.update(editSql, bindValue);
        return row;
    }

    public Integer editRolePermission(String info2, String id) {
        HashMap<String, String> delParams = new HashMap<String, String>();
        delParams.put("id", id);
        String delRolePermissionSql = " DELETE FROM `roma_permission_role` WHERE role_id=:id ";
        Integer row = this.namedParameterJdbcTemplate.update(delRolePermissionSql, delParams);
        HashMap addMap = new HashMap();
        String insertSql = " INSERT INTO `roma_permission_role` (`role_id`,`permission_id`) VALUES  " + info2;
        Integer rowAdd = this.namedParameterJdbcTemplate.update(insertSql, addMap);
        return rowAdd;
    }

    public Integer addRolePermission(String info2) {
        HashMap map = new HashMap();
        String insertSql = " INSERT INTO `roma_permission_role` (`role_id`,`permission_id`) VALUES  " + info2;
        Integer row = this.namedParameterJdbcTemplate.update(insertSql, map);
        return row;
    }

    public Integer addPageDetails(Map<String, Object> bindValue, String editId) {
        String sql = "";
        if (editId.length() == 0) {
            sql = " INSERT INTO `page_details` (`page_name`,`page_code`,`page_json`,`created_at`,`is_enable`,`front_path`,`page_description`)  VALUES (:pageName,:pageCode,:pageJson,:createdAt,:isEnable,:frontPath,:pageDesc)  ";
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            Integer row = this.namedParameterJdbcTemplate.update(sql, new MapSqlParameterSource(bindValue), keyHolder);
            int k = keyHolder.getKey().intValue();
            return k;
        }
        bindValue.put("id", editId);
        sql = " UPDATE `page_details` SET `page_name`=:pageName,`page_code`=:pageCode,`page_json`=:pageJson,`is_enable`=:isEnable,`front_path`=:frontPath,`page_description`=:pageDesc WHERE id=:id";
        Integer row = this.namedParameterJdbcTemplate.update(sql, bindValue);
        return row;
    }

    public Integer saveDatasource(Map<String, Object> bindValue, String editId) {
        String sql = "";
        if (editId.length() == 0) {
            sql = " INSERT INTO `datasource_config` (`datasource_url`,`datasource_code`,`datasource_username`,`datasource_password`,`created_at`)  VALUES (:datasourceUrl,:datasourceCode,:datasourceUsername,:datasourcePassword,:createdAt)  ";
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            Integer row = this.namedParameterJdbcTemplate.update(sql, new MapSqlParameterSource(bindValue), keyHolder);
            int k = keyHolder.getKey().intValue();
            return k;
        }
        bindValue.put("id", editId);
        sql = " UPDATE `datasource_config` SET `datasource_url`=:datasourceUrl,`datasource_code`=:datasourceCode,`datasource_username`=:datasourceUsername,`datasource_password`=:datasourcePassword  WHERE id=:id";
        Integer row = this.namedParameterJdbcTemplate.update(sql, bindValue);
        return row;
    }

    public Integer addSqlDetails(Map<String, Object> bindValue, String editId) {
        String sql = "";
        if (editId.length() == 0) {
            sql = " INSERT INTO `sql_details` (`sql_name`,`sql_code`,`sql_string`,`sql_type`,`is_list`,`is_enable`,`created_user`,`created_at`,`sql_description`, `datasource_code`)  VALUES (:sqlName,:sqlCode,:sqlString,:sqlType,:isList,:isEnable,:actionUser,:createdAt, :sqlDesc, :datasourceCode)  ";
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            Integer row = this.namedParameterJdbcTemplate.update(sql, new MapSqlParameterSource(bindValue), keyHolder);
            int k = keyHolder.getKey().intValue();
            return k;
        }
        bindValue.put("id", editId);
        sql = " UPDATE `sql_details` SET `sql_name`=:sqlName,`sql_code`=:sqlCode,`sql_string`=:sqlString,`sql_type`=:sqlType,`is_list`=:isList,`is_enable`=:isEnable,`sql_description`=:sqlDesc,`update_user`=:actionUser,`datasource_code`=:datasourceCode WHERE id=:id";
        Integer row = this.namedParameterJdbcTemplate.update(sql, bindValue);
        return row;
    }

    public Integer saveApiDetails(Map<String, Object> bindValue, String editId) {
        String sql = "";
        if (editId.length() == 0) {
            sql = " INSERT INTO `api_details` (`api_name`,`api_code`,`api_description`,`is_enable`,`created_at`) VALUES (:apiName,:apiCode,:apiDesc,:isEnable,:createdAt)  ";
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            Integer row = this.namedParameterJdbcTemplate.update(sql, new MapSqlParameterSource(bindValue), keyHolder);
            int k = keyHolder.getKey().intValue();
            return k;
        }
        bindValue.put("id", editId);
        sql = " UPDATE `api_details` SET `api_name`=:apiName,`api_code`=:apiCode,`api_description`=:apiDesc,`is_enable`=:isEnable WHERE id=:id";
        Integer row = this.namedParameterJdbcTemplate.update(sql, bindValue);
        return row;
    }

    public Integer saveItemDetails(Map<String, Object> bindValue, String editId) {
        String sql = "";
        if (editId.length() == 0) {
            sql = " INSERT INTO `item_details` (`item_name`,`item_code`,`item_description`,`is_enable`,`created_at`) VALUES (:itemName,:itemCode,:itemDesc,:isEnable,:createdAt)  ";
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            Integer row = this.namedParameterJdbcTemplate.update(sql, new MapSqlParameterSource(bindValue), keyHolder);
            int k = keyHolder.getKey().intValue();
            return k;
        }
        bindValue.put("id", editId);
        sql = " UPDATE `item_details` SET `item_name`=:itemName,`item_code`=:itemCode,`item_description`=:itemDesc,`is_enable`=:isEnable WHERE id=:id";
        Integer row = this.namedParameterJdbcTemplate.update(sql, bindValue);
        return row;
    }

    public Integer getAllRoleListHasPagingCount(Map bindValue) {
        String countInnerSql = " SELECT * FROM `roma_roles` WHERE 1=1 ";
        String countSql = "SELECT COUNT(*) AS `totalData` FROM ( " + countInnerSql + " ) AS ROMA";
        Integer count = this.namedParameterJdbcTemplate.queryForObject(countSql, bindValue, Integer.class);
        return count;
    }

    public List<Map<String, Object>> getAllRoleListHasPaging(Map bindValue, String page, String perPage, Integer count) {
        String limitAfter = this.commonUtil.calcPagingString(count, page, perPage);
        String listSql = "SELECT  *  FROM `roma_roles` WHERE 1=1 ORDER BY `id` DESC  LIMIT " + limitAfter;
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(listSql, bindValue);
        return resMap2;
    }

    public List<Map<String, Object>> getAllRoleForList() {
        HashMap paramMap = new HashMap();
        String sql = " SELECT  * FROM `roma_roles`";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(sql, paramMap);
        return resMap2;
    }

    /*
     * WARNING - void declaration
     */
    public Integer saveUser(Map bindValue, String userRole, String userId) {
        if (userId.length() > 0) {
            bindValue.put("id", userId);
            String updateUserInfoSql = " UPDATE `admin_user` SET `admin_name`=:adminName,`admin_avatar`=:apiUploadPic,`is_enable`=:isEnable,`admin_email`=:adminEmail,`admin_phone`=:adminPhone WHERE id=:id ";
            Integer row = this.namedParameterJdbcTemplate.update(updateUserInfoSql, bindValue);
            if (row > 0) {
                HashMap<String, String> delParams = new HashMap<String, String>();
                delParams.put("id", userId);
                String delRolePermissionSql = " DELETE FROM `roma_role_user` WHERE user_id=:id ";
                this.namedParameterJdbcTemplate.update(delRolePermissionSql, delParams);
                if (userRole.length() > 0) {
                    void var9_16;
                    LinkedHashSet<String> uniqueRole = new LinkedHashSet<String>();
                    for (String s : userRole.split(",")) {
                        uniqueRole.add(s);
                    }
                    String string = "";
                    for (String val2 : uniqueRole) {
                        String string2 = (String)var9_16 + " (" + userId + "," + val2 + "),";
                    }
                    HashMap addRoleUserMap = new HashMap();
                    String string3 = this.commonUtil.trimFirstAndLastChar((String)var9_16, ",");
                    String insertSql = " INSERT INTO `roma_role_user` (`user_id`, `role_id`) VALUES  " + string3;
                    Integer addRoleUserRow = this.namedParameterJdbcTemplate.update(insertSql, addRoleUserMap);
                    return addRoleUserRow;
                }
                return row;
            }
            return 0;
        }
        String sql = " INSERT INTO `admin_user` (`admin_name`,`admin_password`,`created_at`,`admin_avatar`,`is_enable`,`admin_email`,`admin_phone`) VALUES (:adminName,:adminPassword,:createdAt,:apiUploadPic,:isEnable,:adminEmail,:adminPhone)  ";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        Integer row = this.namedParameterJdbcTemplate.update(sql, new MapSqlParameterSource(bindValue), keyHolder);
        int k = keyHolder.getKey().intValue();
        if (userRole.length() > 0) {
            void var9_21;
            LinkedHashSet<String> uniqueRole = new LinkedHashSet<String>();
            for (String s : userRole.split(",")) {
                uniqueRole.add(s);
            }
            String string = "";
            for (String val3 : uniqueRole) {
                String string4 = (String)var9_21 + " (" + k + "," + val3 + "),";
            }
            HashMap addRoleUserMap = new HashMap();
            String string5 = this.commonUtil.trimFirstAndLastChar((String)var9_21, ",");
            String insertSql = " INSERT INTO `roma_role_user` (`user_id`, `role_id`) VALUES  " + string5;
            Integer addRoleUserRow = this.namedParameterJdbcTemplate.update(insertSql, addRoleUserMap);
            return addRoleUserRow;
        }
        return k;
    }

    public Integer savePermission(Map bindValue, String id) {
        try {
            if (id.length() > 0) {
                bindValue.put("id", id);
                String updateSql = " UPDATE `roma_permissions` SET `parent_id`=:parentId,`object_type`=:objectType,`object_id`=:objectId,`is_dir`=:isMenu,`permission_sort`=:permissionSort,`permissions_icon`=:permissionsIcon,`is_enable`=:isEnable,`created_at`=:createdAt,`menu_name`=:menuName,`is_visible`=:isVisible,`permission_describe`=:permissionDescribe  WHERE id=:id ";
                Integer updateRet = this.namedParameterJdbcTemplate.update(updateSql, bindValue);
                return updateRet;
            }
            String insertAql = " INSERT INTO `roma_permissions` (`parent_id`,`object_type`,`object_id`,`is_dir`,`permission_sort`,`permissions_icon`,`is_enable`,`created_at`,`menu_name`,`is_visible`,`permission_describe`) VALUES (:parentId,:objectType,:objectId,:isMenu,:permissionSort,:permissionsIcon,:isEnable,:createdAt,:menuName,:isVisible,:permissionDescribe)  ";
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            Integer row = this.namedParameterJdbcTemplate.update(insertAql, new MapSqlParameterSource(bindValue), keyHolder);
            int k = keyHolder.getKey().intValue();
            return k;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Boolean hasSonPermissionById(Map bindValue) {
        String hasSql = " SELECT * FROM `roma_permissions` WHERE `parent_id`=:id ";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(hasSql, bindValue);
        if (resMap2 == null || resMap2.size() < 1) {
            return true;
        }
        return false;
    }

    public Integer deletePermissionById(Map bindValue) {
        String sql = " DELETE FROM `roma_permissions` WHERE id=:id ";
        Integer updateRet = this.namedParameterJdbcTemplate.update(sql, bindValue);
        return updateRet;
    }

    public Boolean usedPermissionByObjectId(Map bindValue) {
        String hasUserSql = " SELECT * FROM `roma_permissions` WHERE `object_type`=:objectType AND `object_id`=:objectId ";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(hasUserSql, bindValue);
        if (resMap2 == null || resMap2.size() < 1) {
            return true;
        }
        return false;
    }

    public Integer deleteDetailsDataByTableNameAndId(Map bindValue, String tableName) {
        String sql = " DELETE FROM `" + tableName + "` WHERE id=:id ";
        Integer updateRet = this.namedParameterJdbcTemplate.update(sql, bindValue);
        return updateRet;
    }

    public Boolean usedDatasource(Map params) {
        HashMap sqlParams = new HashMap();
        sqlParams.put("datasourceCode", params.get("datasource_code"));
        String hasUserSql = " SELECT * FROM `sql_details` WHERE `datasource_code`=:datasourceCode";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(hasUserSql, sqlParams);
        if (resMap2 == null || resMap2.size() < 1) {
            return true;
        }
        return false;
    }

    public Integer deleteDatasourceById(Map bindValue) {
        String sql = " DELETE FROM `datasource_config` WHERE id=:id ";
        Integer updateRet = this.namedParameterJdbcTemplate.update(sql, bindValue);
        return updateRet;
    }
}

