/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.dao;

import com.roma.romaapi.utils.CommonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class PageDao {
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Autowired
    private CommonUtil commonUtil;

    public Map dbQueryForMap(String pageCode) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("page_code", pageCode);
            Map<String, Object> resMap2 = this.namedParameterJdbcTemplate.queryForMap("SELECT `page_json` FROM `page_details` where `page_code` = :page_code", paramMap);
            return resMap2;
        }
        catch (EmptyResultDataAccessException e) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("sysErrorCode", "500");
            resultMap.put("sysErrorMessage", "operation failed");
            return resultMap;
        }
    }

    public List<Map<String, Object>> getMenuForList() {
        HashMap paramMap = new HashMap();
        String sql = " SELECT  `rp`.`is_visible`,`rp`.`id`,`rp`.`parent_id`,`rp`.`permissions_icon` as `icon`,`rp`.`object_type`,`rp`.`object_id`,`pd`.`page_code` AS `path`,`pd`.`front_path` AS `url`,`rp`.`menu_name` AS `label` FROM `roma_permissions` AS `rp` LEFT JOIN `page_details` AS `pd` ON `pd`.`id`=`rp`.`object_id` WHERE `rp`.`is_enable`=1   and `rp`.`object_type`='page'    ORDER BY `rp`.`permission_sort` ASC ";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(sql, paramMap);
        return resMap2;
    }

    public List<Map<String, Object>> getAllMenuForList() {
        HashMap paramMap = new HashMap();
        String sql = " SELECT  `rp`.`is_enable`,`rp`.`id`,`rp`.`parent_id`,`rp`.`permissions_icon`,`rp`.`object_type`,`rp`.`object_id`,`rp`.`is_dir`,`rp`.`permission_sort`,`rp`.`menu_name` FROM `roma_permissions` AS `rp` WHERE  1=1  ORDER BY `rp`.`permission_sort` ASC";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(sql, paramMap);
        return resMap2;
    }

    public List<Map<String, Object>> getPageMenuForList() {
        HashMap paramMap = new HashMap();
        String sql = " SELECT  `pd`.`page_code`,`pd`.`page_name`,`rp`.`is_enable`,`rp`.`id`,`rp`.`parent_id`,`rp`.`permissions_icon`,`rp`.`object_type`,`rp`.`object_id`,`rp`.`is_dir`,`rp`.`permission_sort`,`rp`.`menu_name` FROM `roma_permissions` AS `rp`  LEFT JOIN `page_details` as `pd` ON `pd`.`id`=`rp`.`object_id` WHERE 1=1 ORDER BY `rp`.`permission_sort` ASC";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(sql, paramMap);
        return resMap2;
    }

    public List<Map<String, Object>> getAllPageList() {
        HashMap paramMap = new HashMap();
        String sql = " SELECT  *  FROM `page_details` WHERE 1=1 ORDER BY `id` DESC ";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(sql, paramMap);
        return resMap2;
    }

    public List<Map<String, Object>> getAllPageListHasPaging(Map bindValue, String page, String perPage, Integer count) {
        String limitAfter = this.commonUtil.calcPagingString(count, page, perPage);
        String listSql = "SELECT  *  FROM `page_details` WHERE 1=1 ORDER BY `id` DESC  LIMIT " + limitAfter;
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(listSql, bindValue);
        return resMap2;
    }

    public Integer getAllPageListHasPagingCount(Map bindValue) {
        String countInnerSql = " SELECT * FROM `page_details` WHERE 1=1 ";
        String countSql = "SELECT COUNT(*) AS `totalData` FROM ( " + countInnerSql + " ) AS ROMA";
        Integer count = this.namedParameterJdbcTemplate.queryForObject(countSql, bindValue, Integer.class);
        return count;
    }

    public Integer getAllSqlListHasPagingCount(Map bindValue) {
        String countInnerSql = " SELECT * FROM `sql_details` WHERE 1=1 ";
        String countSql = "SELECT COUNT(*) AS `totalData` FROM ( " + countInnerSql + " ) AS ROMA";
        Integer count = this.namedParameterJdbcTemplate.queryForObject(countSql, bindValue, Integer.class);
        return count;
    }

    public List<Map<String, Object>> getAllSqlListHasPaging(Map bindValue, String page, String perPage, Integer count) {
        String limitAfter = this.commonUtil.calcPagingString(count, page, perPage);
        String listSql = "SELECT  *  FROM `sql_details` WHERE 1=1 ORDER BY `id` DESC  LIMIT " + limitAfter;
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(listSql, bindValue);
        return resMap2;
    }

    public Integer getAllDatasourceListHasPagingCount(Map bindValue) {
        String countInnerSql = " SELECT * FROM `datasource_config` WHERE 1=1 ";
        String countSql = "SELECT COUNT(*) AS `totalData` FROM ( " + countInnerSql + " ) AS ROMA";
        Integer count = this.namedParameterJdbcTemplate.queryForObject(countSql, bindValue, Integer.class);
        return count;
    }

    public List<Map<String, Object>> getAllDatasourceListHasPaging(Map bindValue, String page, String perPage, Integer count) {
        String limitAfter = this.commonUtil.calcPagingString(count, page, perPage);
        String listSql = "SELECT  *  FROM `datasource_config` WHERE 1=1 ORDER BY `id` DESC  LIMIT " + limitAfter;
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(listSql, bindValue);
        return resMap2;
    }

    public Integer getAllApiListHasPagingCount(Map bindValue) {
        String countInnerSql = " SELECT * FROM `api_details` WHERE 1=1 ";
        String countSql = "SELECT COUNT(*) AS `totalData` FROM ( " + countInnerSql + " ) AS ROMA";
        Integer count = this.namedParameterJdbcTemplate.queryForObject(countSql, bindValue, Integer.class);
        return count;
    }

    public List<Map<String, Object>> getAllApiListHasPaging(Map bindValue, String page, String perPage, Integer count) {
        String limitAfter = this.commonUtil.calcPagingString(count, page, perPage);
        String listSql = "SELECT  *  FROM `api_details` WHERE 1=1 ORDER BY `id` DESC  LIMIT " + limitAfter;
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(listSql, bindValue);
        return resMap2;
    }

    public Integer getAllItemListHasPagingCount(Map bindValue) {
        String countInnerSql = " SELECT * FROM `item_details` WHERE 1=1 ";
        String countSql = "SELECT COUNT(*) AS `totalData` FROM ( " + countInnerSql + " ) AS ROMA";
        Integer count = this.namedParameterJdbcTemplate.queryForObject(countSql, bindValue, Integer.class);
        return count;
    }

    public List<Map<String, Object>> getAllItemListHasPaging(Map bindValue, String page, String perPage, Integer count) {
        String limitAfter = this.commonUtil.calcPagingString(count, page, perPage);
        String listSql = "SELECT  *  FROM `item_details` WHERE 1=1 ORDER BY `id` DESC  LIMIT " + limitAfter;
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(listSql, bindValue);
        return resMap2;
    }

    public List<Map<String, Object>> getAllSqlList() {
        HashMap paramMap = new HashMap();
        String sql = " SELECT  *  FROM `sql_details` WHERE 1=1 ORDER BY `id` DESC ";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(sql, paramMap);
        return resMap2;
    }

    public List<Map<String, Object>> getAllApiList() {
        HashMap paramMap = new HashMap();
        String sql = " SELECT  *  FROM `api_details` WHERE 1=1 ORDER BY `id` DESC ";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(sql, paramMap);
        return resMap2;
    }

    public List<Map<String, Object>> getAllItemList() {
        HashMap paramMap = new HashMap();
        String sql = " SELECT  *  FROM `item_details` WHERE 1=1 ORDER BY `id` DESC ";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(sql, paramMap);
        return resMap2;
    }

    public List<Map<String, Object>> getAllRoleList() {
        HashMap paramMap = new HashMap();
        String sql = " SELECT  *  FROM `roma_roles` WHERE `is_enable`=1 ORDER BY `id` DESC ";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(sql, paramMap);
        return resMap2;
    }

    public List<Map<String, Object>> getAllDatasource() {
        HashMap paramMap = new HashMap();
        String sql = " SELECT  *  FROM `datasource_config` ORDER BY `id` DESC ";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(sql, paramMap);
        return resMap2;
    }

    public Integer getAllUserListHasPagingCount(Map bindValue) {
        String countInnerSql = " SELECT * FROM `admin_user` WHERE 1=1 ";
        String countSql = "SELECT COUNT(*) AS `totalData` FROM ( " + countInnerSql + " ) AS ROMA";
        Integer count = this.namedParameterJdbcTemplate.queryForObject(countSql, bindValue, Integer.class);
        return count;
    }

    public List<Map<String, Object>> getAllUserListHasPaging(Map bindValue, String page, String perPage, Integer count) {
        String limitAfter = this.commonUtil.calcPagingString(count, page, perPage);
        String listSql = "SELECT  *  FROM `admin_user` WHERE 1=1 ORDER BY `id` DESC  LIMIT " + limitAfter;
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(listSql, bindValue);
        return resMap2;
    }
}

