/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class JWTUtil {
    private static final Logger log = LoggerFactory.getLogger(JWTUtil.class);
    public static final String SIGN = "JWT_SIGN_";
    private static final String SECRET = "rd!rew231sods4df?m2wsa";
    public static final long REDIS_USER_EXPIRE_TIME = 1800L;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    public String getToken(Map userMapInfo) {
        Calendar instance = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        instance.add(5, 7);
        JWTCreator.Builder builder = JWT.create();
        Object objectUserId = userMapInfo.get("id");
        String userId = objectUserId.toString();
        builder.withClaim("userId", userId).withClaim("userLoginTime", String.valueOf(userMapInfo.get("loginTime"))).withClaim("userName", String.valueOf(userMapInfo.get("name"))).withClaim("expTime", simpleDateFormat.format(new Date(instance.getTime().getTime())));
        String jwtToken = builder.withExpiresAt(instance.getTime()).sign(Algorithm.HMAC256(userId));
        String redisTokenKey = SIGN + jwtToken;
        this.stringRedisTemplate.opsForValue().set((CallSite)((Object)redisTokenKey), userId, 1800L, TimeUnit.SECONDS);
        return jwtToken;
    }

    public DecodedJWT verify(String token) throws Exception {
        String userId = (String)this.stringRedisTemplate.opsForValue().get(SIGN + token);
        JWTVerifier build = JWT.require(Algorithm.HMAC256(userId)).build();
        return build.verify(token);
    }
}

