/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.RegistrationListener;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.TomcatPrincipal;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.authenticator.jaspic.MessageInfoImpl;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.filters.CorsFilter;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.SessionIdGeneratorBase;
import org.apache.catalina.util.StandardSessionIdGenerator;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.res.StringManager;

public abstract class AuthenticatorBase
extends ValveBase
implements Authenticator,
RegistrationListener {
    private final Log log = LogFactory.getLog(AuthenticatorBase.class);
    private static final String DATE_ONE = FastHttpDateFormat.formatDate(1L);
    protected static final StringManager sm = StringManager.getManager(AuthenticatorBase.class);
    protected static final String AUTH_HEADER_NAME = "WWW-Authenticate";
    protected static final String REALM_NAME = "Authentication required";
    protected boolean alwaysUseSession = false;
    protected boolean cache = true;
    protected boolean changeSessionIdOnAuthentication = true;
    protected Context context = null;
    protected boolean disableProxyCaching = true;
    protected boolean securePagesWithPragma = false;
    protected String secureRandomClass = null;
    protected String secureRandomAlgorithm = SessionIdGeneratorBase.DEFAULT_SECURE_RANDOM_ALGORITHM;
    protected String secureRandomProvider = null;
    protected String jaspicCallbackHandlerClass = "org.apache.catalina.authenticator.jaspic.CallbackHandlerImpl";
    protected boolean sendAuthInfoResponseHeaders = false;
    protected SessionIdGeneratorBase sessionIdGenerator = null;
    protected SingleSignOn sso = null;
    private AllowCorsPreflight allowCorsPreflight = AllowCorsPreflight.NEVER;
    private volatile String jaspicAppContextID = null;
    private volatile Optional<AuthConfigProvider> jaspicProvider = null;
    private volatile CallbackHandler jaspicCallbackHandler = null;

    protected static String getRealmName(Context context) {
        if (context == null) {
            return REALM_NAME;
        }
        LoginConfig config = context.getLoginConfig();
        if (config == null) {
            return REALM_NAME;
        }
        String result = config.getRealmName();
        if (result == null) {
            return REALM_NAME;
        }
        return result;
    }

    public AuthenticatorBase() {
        super(true);
    }

    public String getAllowCorsPreflight() {
        return this.allowCorsPreflight.name().toLowerCase(Locale.ENGLISH);
    }

    public void setAllowCorsPreflight(String allowCorsPreflight) {
        this.allowCorsPreflight = AllowCorsPreflight.valueOf(allowCorsPreflight.trim().toUpperCase(Locale.ENGLISH));
    }

    public boolean getAlwaysUseSession() {
        return this.alwaysUseSession;
    }

    public void setAlwaysUseSession(boolean alwaysUseSession) {
        this.alwaysUseSession = alwaysUseSession;
    }

    public boolean getCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    @Override
    public Container getContainer() {
        return this.context;
    }

    @Override
    public void setContainer(Container container) {
        if (container != null && !(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("authenticator.notContext"));
        }
        super.setContainer(container);
        this.context = (Context)container;
    }

    public boolean getDisableProxyCaching() {
        return this.disableProxyCaching;
    }

    public void setDisableProxyCaching(boolean nocache) {
        this.disableProxyCaching = nocache;
    }

    public boolean getSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    public void setSecurePagesWithPragma(boolean securePagesWithPragma) {
        this.securePagesWithPragma = securePagesWithPragma;
    }

    public boolean getChangeSessionIdOnAuthentication() {
        return this.changeSessionIdOnAuthentication;
    }

    public void setChangeSessionIdOnAuthentication(boolean changeSessionIdOnAuthentication) {
        this.changeSessionIdOnAuthentication = changeSessionIdOnAuthentication;
    }

    public String getSecureRandomClass() {
        return this.secureRandomClass;
    }

    public void setSecureRandomClass(String secureRandomClass) {
        this.secureRandomClass = secureRandomClass;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public String getSecureRandomProvider() {
        return this.secureRandomProvider;
    }

    public void setSecureRandomProvider(String secureRandomProvider) {
        this.secureRandomProvider = secureRandomProvider;
    }

    public String getJaspicCallbackHandlerClass() {
        return this.jaspicCallbackHandlerClass;
    }

    public void setJaspicCallbackHandlerClass(String jaspicCallbackHandlerClass) {
        this.jaspicCallbackHandlerClass = jaspicCallbackHandlerClass;
    }

    public boolean isSendAuthInfoResponseHeaders() {
        return this.sendAuthInfoResponseHeaders;
    }

    public void setSendAuthInfoResponseHeaders(boolean sendAuthInfoResponseHeaders) {
        this.sendAuthInfoResponseHeaders = sendAuthInfoResponseHeaders;
    }

    @Override
    public void invoke(Request request2, Response response) throws IOException, ServletException {
        Session session;
        Principal principal;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Security checking request " + request2.getMethod() + " " + request2.getRequestURI());
        }
        if (this.cache && (principal = request2.getUserPrincipal()) == null && (session = request2.getSessionInternal(false)) != null && (principal = session.getPrincipal()) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("We have cached auth type " + session.getAuthType() + " for principal " + principal);
            }
            request2.setAuthType(session.getAuthType());
            request2.setUserPrincipal(principal);
        }
        boolean authRequired = this.isContinuationRequired(request2);
        Realm realm = this.context.getRealm();
        SecurityConstraint[] constraints = realm.findSecurityConstraints(request2, this.context);
        AuthConfigProvider jaspicProvider = this.getJaspicProvider();
        if (jaspicProvider != null) {
            authRequired = true;
        }
        if (constraints == null && !this.context.getPreemptiveAuthentication() && !authRequired) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Not subject to any constraint");
            }
            this.getNext().invoke(request2, response);
            return;
        }
        if (constraints != null && this.disableProxyCaching && !"POST".equalsIgnoreCase(request2.getMethod())) {
            if (this.securePagesWithPragma) {
                response.setHeader("Pragma", "No-cache");
                response.setHeader("Cache-Control", "no-cache");
                response.setHeader("Expires", DATE_ONE);
            } else {
                response.setHeader("Cache-Control", "private");
            }
        }
        if (constraints != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Calling hasUserDataPermission()");
            }
            if (!realm.hasUserDataPermission(request2, response, constraints)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed hasUserDataPermission() test");
                }
                return;
            }
        }
        boolean hasAuthConstraint = false;
        if (constraints != null) {
            hasAuthConstraint = true;
            for (int i2 = 0; i2 < constraints.length && hasAuthConstraint; ++i2) {
                String[] roles;
                if (!constraints[i2].getAuthConstraint()) {
                    hasAuthConstraint = false;
                    continue;
                }
                if (constraints[i2].getAllRoles() || constraints[i2].getAuthenticatedUsers() || (roles = constraints[i2].findAuthRoles()) != null && roles.length != 0) continue;
                hasAuthConstraint = false;
            }
        }
        if (!authRequired && hasAuthConstraint) {
            authRequired = true;
        }
        if (!authRequired && this.context.getPreemptiveAuthentication() && this.isPreemptiveAuthPossible(request2)) {
            authRequired = true;
        }
        JaspicState jaspicState = null;
        if ((authRequired || constraints != null) && this.allowCorsPreflightBypass(request2)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("CORS Preflight request bypassing authentication");
            }
            this.getNext().invoke(request2, response);
            return;
        }
        if (authRequired) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Calling authenticate()");
            }
            if (jaspicProvider != null && (jaspicState = this.getJaspicState(jaspicProvider, request2, response, hasAuthConstraint)) == null) {
                return;
            }
            if (jaspicProvider == null && !this.doAuthenticate(request2, response) || jaspicProvider != null && !this.authenticateJaspic(request2, response, jaspicState, false)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed authenticate() test");
                }
                return;
            }
        }
        if (constraints != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Calling accessControl()");
            }
            if (!realm.hasResourcePermission(request2, response, constraints, this.context)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed accessControl() test");
                }
                return;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Successfully passed all security constraints");
        }
        this.getNext().invoke(request2, response);
        if (jaspicProvider != null) {
            this.secureResponseJspic(request2, response, jaspicState);
        }
    }

    protected boolean allowCorsPreflightBypass(Request request2) {
        String accessControlRequestMethodHeader;
        String originHeader;
        boolean allowBypass = false;
        if (this.allowCorsPreflight != AllowCorsPreflight.NEVER && "OPTIONS".equals(request2.getMethod()) && (originHeader = request2.getHeader("Origin")) != null && !originHeader.isEmpty() && RequestUtil.isValidOrigin(originHeader) && !RequestUtil.isSameOrigin(request2, originHeader) && (accessControlRequestMethodHeader = request2.getHeader("Access-Control-Request-Method")) != null && !accessControlRequestMethodHeader.isEmpty()) {
            if (this.allowCorsPreflight == AllowCorsPreflight.ALWAYS) {
                allowBypass = true;
            } else if (this.allowCorsPreflight == AllowCorsPreflight.FILTER && DispatcherType.REQUEST == request2.getDispatcherType()) {
                block0: for (FilterDef filterDef : request2.getContext().findFilterDefs()) {
                    if (!CorsFilter.class.getName().equals(filterDef.getFilterClass())) continue;
                    for (FilterMap filterMap : this.context.findFilterMaps()) {
                        if (!filterMap.getFilterName().equals(filterDef.getFilterName())) continue;
                        if ((filterMap.getDispatcherMapping() & 8) <= 0) break block0;
                        for (String urlPattern : filterMap.getURLPatterns()) {
                            if (!"/*".equals(urlPattern)) continue;
                            allowBypass = true;
                            break block0;
                        }
                        break block0;
                    }
                    break;
                }
            }
        }
        return allowBypass;
    }

    @Override
    public boolean authenticate(Request request2, HttpServletResponse httpResponse) throws IOException {
        AuthConfigProvider jaspicProvider = this.getJaspicProvider();
        if (jaspicProvider == null) {
            return this.doAuthenticate(request2, httpResponse);
        }
        Response response = request2.getResponse();
        JaspicState jaspicState = this.getJaspicState(jaspicProvider, request2, response, true);
        if (jaspicState == null) {
            return false;
        }
        boolean result = this.authenticateJaspic(request2, response, jaspicState, true);
        this.secureResponseJspic(request2, response, jaspicState);
        return result;
    }

    private void secureResponseJspic(Request request2, Response response, JaspicState state) {
        try {
            state.serverAuthContext.secureResponse(state.messageInfo, null);
            request2.setRequest((HttpServletRequest)state.messageInfo.getRequestMessage());
            response.setResponse((HttpServletResponse)state.messageInfo.getResponseMessage());
        }
        catch (AuthException e) {
            this.log.warn(sm.getString("authenticator.jaspicSecureResponseFail"), e);
        }
    }

    private JaspicState getJaspicState(AuthConfigProvider jaspicProvider, Request request2, Response response, boolean authMandatory) throws IOException {
        JaspicState jaspicState = new JaspicState();
        jaspicState.messageInfo = new MessageInfoImpl(request2.getRequest(), response.getResponse(), authMandatory);
        try {
            CallbackHandler callbackHandler = this.getCallbackHandler();
            ServerAuthConfig serverAuthConfig = jaspicProvider.getServerAuthConfig("HttpServlet", this.jaspicAppContextID, callbackHandler);
            String authContextID = serverAuthConfig.getAuthContextID(jaspicState.messageInfo);
            jaspicState.serverAuthContext = serverAuthConfig.getAuthContext(authContextID, null, null);
        }
        catch (AuthException e) {
            this.log.warn(sm.getString("authenticator.jaspicServerAuthContextFail"), e);
            response.sendError(500);
            return null;
        }
        return jaspicState;
    }

    private CallbackHandler getCallbackHandler() {
        CallbackHandler handler = this.jaspicCallbackHandler;
        if (handler == null) {
            handler = this.createCallbackHandler();
        }
        return handler;
    }

    private CallbackHandler createCallbackHandler() {
        CallbackHandler callbackHandler = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this.jaspicCallbackHandlerClass, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (clazz == null) {
                clazz = Class.forName(this.jaspicCallbackHandlerClass);
            }
            callbackHandler = (CallbackHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new SecurityException(e);
        }
        if (callbackHandler instanceof Contained) {
            ((Contained)((Object)callbackHandler)).setContainer(this.getContainer());
        }
        this.jaspicCallbackHandler = callbackHandler;
        return callbackHandler;
    }

    protected abstract boolean doAuthenticate(Request var1, HttpServletResponse var2) throws IOException;

    protected boolean isContinuationRequired(Request request2) {
        return false;
    }

    protected void associate(String ssoId, Session session) {
        if (this.sso == null) {
            return;
        }
        this.sso.associate(ssoId, session);
    }

    private boolean authenticateJaspic(Request request2, Response response, JaspicState state, boolean requirePrincipal) {
        AuthStatus authStatus;
        boolean cachedAuth = this.checkForCachedAuthentication(request2, response, false);
        Subject client = new Subject();
        try {
            authStatus = state.serverAuthContext.validateRequest(state.messageInfo, client, null);
        }
        catch (AuthException e) {
            this.log.debug(sm.getString("authenticator.loginFail"), e);
            return false;
        }
        request2.setRequest((HttpServletRequest)state.messageInfo.getRequestMessage());
        response.setResponse((HttpServletResponse)state.messageInfo.getResponseMessage());
        if (authStatus == AuthStatus.SUCCESS) {
            GenericPrincipal principal = this.getPrincipal(client);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Authenticated user: " + principal);
            }
            if (principal == null) {
                request2.setUserPrincipal(null);
                request2.setAuthType(null);
                if (requirePrincipal) {
                    return false;
                }
            } else if (!cachedAuth || !principal.getUserPrincipal().equals(request2.getUserPrincipal())) {
                String authTypeValue;
                Boolean register = null;
                String authType = "JASPIC";
                Map<String, Object> map = state.messageInfo.getMap();
                String registerValue = (String)map.get("jakarta.servlet.http.registerSession");
                if (registerValue != null) {
                    register = Boolean.valueOf(registerValue);
                }
                if ((authTypeValue = (String)map.get("jakarta.servlet.http.authType")) != null) {
                    authType = authTypeValue;
                }
                if (register != null) {
                    this.register(request2, response, principal, authType, null, null, this.alwaysUseSession || register != false, register);
                } else {
                    this.register(request2, response, principal, authType, null, null);
                }
            }
            request2.setNote("org.apache.catalina.authenticator.jaspic.SUBJECT", client);
            return true;
        }
        return false;
    }

    private GenericPrincipal getPrincipal(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<GenericPrincipal> principals = subject.getPrivateCredentials(GenericPrincipal.class);
        if (principals.isEmpty()) {
            return null;
        }
        return principals.iterator().next();
    }

    protected boolean checkForCachedAuthentication(Request request2, HttpServletResponse response, boolean useSSO) {
        String username;
        Principal principal = request2.getUserPrincipal();
        String ssoId = (String)request2.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(sm.getString("authenticator.check.found", principal.getName()));
            }
            if (ssoId != null) {
                this.associate(ssoId, request2.getSessionInternal(true));
            }
            return true;
        }
        if (useSSO && ssoId != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(sm.getString("authenticator.check.sso", ssoId));
            }
            if (this.reauthenticateFromSSO(ssoId, request2)) {
                return true;
            }
        }
        if (request2.getCoyoteRequest().getRemoteUserNeedsAuthorization() && (username = request2.getCoyoteRequest().getRemoteUser().toString()) != null) {
            String authType;
            Principal authorized;
            if (this.log.isDebugEnabled()) {
                this.log.debug(sm.getString("authenticator.check.authorize", username));
            }
            if ((authorized = this.context.getRealm().authenticate(username)) == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(sm.getString("authenticator.check.authorizeFail", username));
                }
                authorized = new GenericPrincipal(username);
            }
            if ((authType = request2.getAuthType()) == null || authType.length() == 0) {
                authType = this.getAuthMethod();
            }
            this.register(request2, response, authorized, authType, username, null);
            return true;
        }
        return false;
    }

    protected boolean reauthenticateFromSSO(String ssoId, Request request2) {
        Realm realm;
        if (this.sso == null || ssoId == null) {
            return false;
        }
        boolean reauthenticated = false;
        Container parent = this.getContainer();
        if (parent != null && (realm = parent.getRealm()) != null) {
            reauthenticated = this.sso.reauthenticate(ssoId, realm, request2);
        }
        if (reauthenticated) {
            this.associate(ssoId, request2.getSessionInternal(true));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Reauthenticated cached principal '" + request2.getUserPrincipal().getName() + "' with auth type '" + request2.getAuthType() + "'");
            }
        }
        return reauthenticated;
    }

    public void register(Request request2, HttpServletResponse response, Principal principal, String authType, String username, String password) {
        this.register(request2, response, principal, authType, username, password, this.alwaysUseSession, this.cache);
    }

    protected void register(Request request2, HttpServletResponse response, Principal principal, String authType, String username, String password, boolean alwaysUseSession, boolean cache) {
        Session session;
        if (this.log.isDebugEnabled()) {
            String name = principal == null ? "none" : principal.getName();
            this.log.debug("Authenticated '" + name + "' with type '" + authType + "'");
        }
        request2.setAuthType(authType);
        request2.setUserPrincipal(principal);
        if (this.sendAuthInfoResponseHeaders && Boolean.TRUE.equals(request2.getAttribute("org.apache.tomcat.request.forwarded"))) {
            response.setHeader("remote-user", request2.getRemoteUser());
            response.setHeader("auth-type", request2.getAuthType());
        }
        if ((session = request2.getSessionInternal(false)) != null) {
            if (this.getChangeSessionIdOnAuthentication() && principal != null) {
                String newSessionId = this.changeSessionID(request2, session);
                if (session.getNote("org.apache.catalina.authenticator.SESSION_ID") != null) {
                    session.setNote("org.apache.catalina.authenticator.SESSION_ID", newSessionId);
                }
            }
        } else if (alwaysUseSession) {
            session = request2.getSessionInternal(true);
        }
        if (session != null && cache) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
        }
        if (this.sso == null) {
            return;
        }
        String ssoId = (String)request2.getNote("org.apache.catalina.request.SSOID");
        if (ssoId == null) {
            ssoId = this.sessionIdGenerator.generateSessionId();
            Cookie cookie = new Cookie(this.sso.getCookieName(), ssoId);
            cookie.setMaxAge(-1);
            cookie.setPath("/");
            cookie.setSecure(request2.isSecure());
            String ssoDomain = this.sso.getCookieDomain();
            if (ssoDomain != null) {
                cookie.setDomain(ssoDomain);
            }
            if (request2.getServletContext().getSessionCookieConfig().isHttpOnly() || request2.getContext().getUseHttpOnly()) {
                cookie.setHttpOnly(true);
            }
            response.addCookie(cookie);
            this.sso.register(ssoId, principal, authType, username, password);
            request2.setNote("org.apache.catalina.request.SSOID", ssoId);
        } else {
            if (principal == null) {
                this.sso.deregister(ssoId);
                request2.removeNote("org.apache.catalina.request.SSOID");
                return;
            }
            this.sso.update(ssoId, principal, authType, username, password);
        }
        if (session == null) {
            session = request2.getSessionInternal(true);
        }
        this.sso.associate(ssoId, session);
    }

    protected String changeSessionID(Request request2, Session session) {
        String oldId = null;
        if (this.log.isDebugEnabled()) {
            oldId = session.getId();
        }
        String newId = request2.changeSessionId();
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("authenticator.changeSessionId", oldId, newId));
        }
        return newId;
    }

    @Override
    public void login(String username, String password, Request request2) throws ServletException {
        Principal principal = this.doLogin(request2, username, password);
        this.register(request2, request2.getResponse(), principal, this.getAuthMethod(), username, password);
    }

    protected abstract String getAuthMethod();

    protected Principal doLogin(Request request2, String username, String password) throws ServletException {
        Principal p = this.context.getRealm().authenticate(username, password);
        if (p == null) {
            throw new ServletException(sm.getString("authenticator.loginFail"));
        }
        return p;
    }

    @Override
    public void logout(Request request2) {
        Principal p;
        AuthConfigProvider provider = this.getJaspicProvider();
        if (provider != null) {
            MessageInfoImpl messageInfo = new MessageInfoImpl(request2, request2.getResponse(), true);
            Subject client = (Subject)request2.getNote("org.apache.catalina.authenticator.jaspic.SUBJECT");
            if (client != null) {
                try {
                    ServerAuthConfig serverAuthConfig = provider.getServerAuthConfig("HttpServlet", this.jaspicAppContextID, this.getCallbackHandler());
                    String authContextID = serverAuthConfig.getAuthContextID(messageInfo);
                    ServerAuthContext serverAuthContext = serverAuthConfig.getAuthContext(authContextID, null, null);
                    serverAuthContext.cleanSubject(messageInfo, client);
                }
                catch (AuthException e) {
                    this.log.debug(sm.getString("authenticator.jaspicCleanSubjectFail"), e);
                }
            }
        }
        if ((p = request2.getPrincipal()) instanceof TomcatPrincipal) {
            try {
                ((TomcatPrincipal)p).logout();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                this.log.debug(sm.getString("authenticator.tomcatPrincipalLogoutFail"), t);
            }
        }
        this.register(request2, request2.getResponse(), null, null, null, null);
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        ServletContext servletContext = this.context.getServletContext();
        this.jaspicAppContextID = servletContext.getVirtualServerName() + " " + servletContext.getContextPath();
        Container parent = this.context.getParent();
        while (this.sso == null && parent != null) {
            Valve[] valves;
            for (Valve valve : valves = parent.getPipeline().getValves()) {
                if (!(valve instanceof SingleSignOn)) continue;
                this.sso = (SingleSignOn)valve;
                break;
            }
            if (this.sso != null) continue;
            parent = parent.getParent();
        }
        if (this.log.isDebugEnabled()) {
            if (this.sso != null) {
                this.log.debug("Found SingleSignOn Valve at " + this.sso);
            } else {
                this.log.debug("No SingleSignOn Valve is present");
            }
        }
        this.sessionIdGenerator = new StandardSessionIdGenerator();
        this.sessionIdGenerator.setSecureRandomAlgorithm(this.getSecureRandomAlgorithm());
        this.sessionIdGenerator.setSecureRandomClass(this.getSecureRandomClass());
        this.sessionIdGenerator.setSecureRandomProvider(this.getSecureRandomProvider());
        super.startInternal();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.sso = null;
    }

    protected boolean isPreemptiveAuthPossible(Request request2) {
        return false;
    }

    private AuthConfigProvider getJaspicProvider() {
        Optional<AuthConfigProvider> provider = this.jaspicProvider;
        if (provider == null) {
            provider = this.findJaspicProvider();
        }
        return provider.orElse(null);
    }

    private Optional<AuthConfigProvider> findJaspicProvider() {
        AuthConfigFactory factory = AuthConfigFactory.getFactory();
        Optional<AuthConfigProvider> provider = factory == null ? Optional.empty() : Optional.ofNullable(factory.getConfigProvider("HttpServlet", this.jaspicAppContextID, this));
        this.jaspicProvider = provider;
        return provider;
    }

    @Override
    public void notify(String layer, String appContext) {
        this.findJaspicProvider();
    }

    protected static enum AllowCorsPreflight {
        NEVER,
        FILTER,
        ALWAYS;

    }

    private static class JaspicState {
        public MessageInfo messageInfo = null;
        public ServerAuthContext serverAuthContext = null;

        private JaspicState() {
        }
    }
}

