/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayDeque;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.StringUtils;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.Host;

public class RemoteIpValve
extends ValveBase {
    private static final Pattern commaSeparatedValuesPattern = Pattern.compile("\\s*,\\s*");
    private static final Log log = LogFactory.getLog(RemoteIpValve.class);
    private String hostHeader = null;
    private boolean changeLocalName = false;
    private int httpServerPort = 80;
    private int httpsServerPort = 443;
    private String portHeader = null;
    private boolean changeLocalPort = false;
    private Pattern internalProxies = Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}|0:0:0:0:0:0:0:1|::1");
    private String protocolHeader = "X-Forwarded-Proto";
    private String protocolHeaderHttpsValue = "https";
    private String proxiesHeader = "X-Forwarded-By";
    private String remoteIpHeader = "X-Forwarded-For";
    private boolean requestAttributesEnabled = true;
    private Pattern trustedProxies = null;

    protected static String[] commaDelimitedListToStringArray(String commaDelimitedStrings) {
        return commaDelimitedStrings == null || commaDelimitedStrings.length() == 0 ? new String[]{} : commaSeparatedValuesPattern.split(commaDelimitedStrings);
    }

    public RemoteIpValve() {
        super(true);
    }

    public String getHostHeader() {
        return this.hostHeader;
    }

    public void setHostHeader(String hostHeader) {
        this.hostHeader = hostHeader;
    }

    public boolean isChangeLocalName() {
        return this.changeLocalName;
    }

    public void setChangeLocalName(boolean changeLocalName) {
        this.changeLocalName = changeLocalName;
    }

    public int getHttpServerPort() {
        return this.httpServerPort;
    }

    public int getHttpsServerPort() {
        return this.httpsServerPort;
    }

    public String getPortHeader() {
        return this.portHeader;
    }

    public void setPortHeader(String portHeader) {
        this.portHeader = portHeader;
    }

    public boolean isChangeLocalPort() {
        return this.changeLocalPort;
    }

    public void setChangeLocalPort(boolean changeLocalPort) {
        this.changeLocalPort = changeLocalPort;
    }

    public String getInternalProxies() {
        if (this.internalProxies == null) {
            return null;
        }
        return this.internalProxies.toString();
    }

    public String getProtocolHeader() {
        return this.protocolHeader;
    }

    public String getProtocolHeaderHttpsValue() {
        return this.protocolHeaderHttpsValue;
    }

    public String getProxiesHeader() {
        return this.proxiesHeader;
    }

    public String getRemoteIpHeader() {
        return this.remoteIpHeader;
    }

    public boolean getRequestAttributesEnabled() {
        return this.requestAttributesEnabled;
    }

    public String getTrustedProxies() {
        if (this.trustedProxies == null) {
            return null;
        }
        return this.trustedProxies.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request2, Response response) throws IOException, ServletException {
        boolean isInternal;
        String originalRemoteAddr = request2.getRemoteAddr();
        String originalRemoteHost = request2.getRemoteHost();
        String originalScheme = request2.getScheme();
        boolean originalSecure = request2.isSecure();
        String originalServerName = request2.getServerName();
        String originalLocalName = this.isChangeLocalName() ? request2.getLocalName() : null;
        int originalServerPort = request2.getServerPort();
        int originalLocalPort = request2.getLocalPort();
        String originalProxiesHeader = request2.getHeader(this.proxiesHeader);
        String originalRemoteIpHeader = request2.getHeader(this.remoteIpHeader);
        boolean bl = isInternal = this.internalProxies != null && this.internalProxies.matcher(originalRemoteAddr).matches();
        if (isInternal || this.trustedProxies != null && this.trustedProxies.matcher(originalRemoteAddr).matches()) {
            String hostHeaderValue;
            String protocolHeaderValue;
            int idx;
            String remoteIp = null;
            ArrayDeque<String> proxiesHeaderValue = new ArrayDeque<String>();
            StringBuilder concatRemoteIpHeaderValue = new StringBuilder();
            Enumeration<String> e = request2.getHeaders(this.remoteIpHeader);
            while (e.hasMoreElements()) {
                if (concatRemoteIpHeaderValue.length() > 0) {
                    concatRemoteIpHeaderValue.append(", ");
                }
                concatRemoteIpHeaderValue.append(e.nextElement());
            }
            String[] remoteIpHeaderValue = RemoteIpValve.commaDelimitedListToStringArray(concatRemoteIpHeaderValue.toString());
            if (!isInternal) {
                proxiesHeaderValue.addFirst(originalRemoteAddr);
            }
            for (idx = remoteIpHeaderValue.length - 1; idx >= 0; --idx) {
                String currentRemoteIp;
                remoteIp = currentRemoteIp = remoteIpHeaderValue[idx];
                if (this.internalProxies != null && this.internalProxies.matcher(currentRemoteIp).matches()) continue;
                if (this.trustedProxies != null && this.trustedProxies.matcher(currentRemoteIp).matches()) {
                    proxiesHeaderValue.addFirst(currentRemoteIp);
                    continue;
                }
                --idx;
                break;
            }
            ArrayDeque<String> newRemoteIpHeaderValue = new ArrayDeque<String>();
            while (idx >= 0) {
                String currentRemoteIp = remoteIpHeaderValue[idx];
                newRemoteIpHeaderValue.addFirst(currentRemoteIp);
                --idx;
            }
            if (remoteIp != null) {
                request2.setRemoteAddr(remoteIp);
                if (request2.getConnector().getEnableLookups()) {
                    try {
                        InetAddress inetAddress = InetAddress.getByName(remoteIp);
                        request2.setRemoteHost(inetAddress.getCanonicalHostName());
                    }
                    catch (UnknownHostException e2) {
                        log.debug(sm.getString("remoteIpValve.invalidRemoteAddress", remoteIp), e2);
                        request2.setRemoteHost(remoteIp);
                    }
                } else {
                    request2.setRemoteHost(remoteIp);
                }
                if (proxiesHeaderValue.size() == 0) {
                    request2.getCoyoteRequest().getMimeHeaders().removeHeader(this.proxiesHeader);
                } else {
                    String commaDelimitedListOfProxies = StringUtils.join(proxiesHeaderValue);
                    request2.getCoyoteRequest().getMimeHeaders().setValue(this.proxiesHeader).setString(commaDelimitedListOfProxies);
                }
                if (newRemoteIpHeaderValue.size() == 0) {
                    request2.getCoyoteRequest().getMimeHeaders().removeHeader(this.remoteIpHeader);
                } else {
                    String commaDelimitedRemoteIpHeaderValue = StringUtils.join(newRemoteIpHeaderValue);
                    request2.getCoyoteRequest().getMimeHeaders().setValue(this.remoteIpHeader).setString(commaDelimitedRemoteIpHeaderValue);
                }
            }
            if (this.protocolHeader != null && (protocolHeaderValue = request2.getHeader(this.protocolHeader)) != null) {
                if (this.isForwardedProtoHeaderValueSecure(protocolHeaderValue)) {
                    request2.setSecure(true);
                    request2.getCoyoteRequest().scheme().setString("https");
                    this.setPorts(request2, this.httpsServerPort);
                } else {
                    request2.setSecure(false);
                    request2.getCoyoteRequest().scheme().setString("http");
                    this.setPorts(request2, this.httpServerPort);
                }
            }
            if (this.hostHeader != null && (hostHeaderValue = request2.getHeader(this.hostHeader)) != null) {
                try {
                    int portIndex = Host.parse(hostHeaderValue);
                    if (portIndex > -1) {
                        log.debug(sm.getString("remoteIpValve.invalidHostWithPort", hostHeaderValue, this.hostHeader));
                        hostHeaderValue = hostHeaderValue.substring(0, portIndex);
                    }
                    request2.getCoyoteRequest().serverName().setString(hostHeaderValue);
                    if (this.isChangeLocalName()) {
                        request2.getCoyoteRequest().localName().setString(hostHeaderValue);
                    }
                }
                catch (IllegalArgumentException iae) {
                    log.debug(sm.getString("remoteIpValve.invalidHostHeader", hostHeaderValue, this.hostHeader));
                }
            }
            request2.setAttribute("org.apache.tomcat.request.forwarded", Boolean.TRUE);
            if (log.isDebugEnabled()) {
                log.debug("Incoming request " + request2.getRequestURI() + " with originalRemoteAddr [" + originalRemoteAddr + "], originalRemoteHost=[" + originalRemoteHost + "], originalSecure=[" + originalSecure + "], originalScheme=[" + originalScheme + "], originalServerName=[" + originalServerName + "], originalServerPort=[" + originalServerPort + "] will be seen as newRemoteAddr=[" + request2.getRemoteAddr() + "], newRemoteHost=[" + request2.getRemoteHost() + "], newSecure=[" + request2.isSecure() + "], newScheme=[" + request2.getScheme() + "], newServerName=[" + request2.getServerName() + "], newServerPort=[" + request2.getServerPort() + "]");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Skip RemoteIpValve for request " + request2.getRequestURI() + " with originalRemoteAddr '" + request2.getRemoteAddr() + "'");
        }
        if (this.requestAttributesEnabled) {
            request2.setAttribute("org.apache.catalina.AccessLog.RemoteAddr", request2.getRemoteAddr());
            request2.setAttribute("org.apache.tomcat.remoteAddr", request2.getRemoteAddr());
            request2.setAttribute("org.apache.catalina.AccessLog.RemoteHost", request2.getRemoteHost());
            request2.setAttribute("org.apache.catalina.AccessLog.Protocol", request2.getProtocol());
            request2.setAttribute("org.apache.catalina.AccessLog.ServerName", request2.getServerName());
            request2.setAttribute("org.apache.catalina.AccessLog.ServerPort", request2.getServerPort());
        }
        try {
            this.getNext().invoke(request2, response);
        }
        finally {
            if (!request2.isAsync()) {
                request2.setRemoteAddr(originalRemoteAddr);
                request2.setRemoteHost(originalRemoteHost);
                request2.setSecure(originalSecure);
                request2.getCoyoteRequest().scheme().setString(originalScheme);
                request2.getCoyoteRequest().serverName().setString(originalServerName);
                if (this.isChangeLocalName()) {
                    request2.getCoyoteRequest().localName().setString(originalLocalName);
                }
                request2.setServerPort(originalServerPort);
                request2.setLocalPort(originalLocalPort);
                MimeHeaders headers = request2.getCoyoteRequest().getMimeHeaders();
                if (originalProxiesHeader == null || originalProxiesHeader.length() == 0) {
                    headers.removeHeader(this.proxiesHeader);
                } else {
                    headers.setValue(this.proxiesHeader).setString(originalProxiesHeader);
                }
                if (originalRemoteIpHeader == null || originalRemoteIpHeader.length() == 0) {
                    headers.removeHeader(this.remoteIpHeader);
                } else {
                    headers.setValue(this.remoteIpHeader).setString(originalRemoteIpHeader);
                }
            }
        }
    }

    private boolean isForwardedProtoHeaderValueSecure(String protocolHeaderValue) {
        if (!protocolHeaderValue.contains(",")) {
            return this.protocolHeaderHttpsValue.equalsIgnoreCase(protocolHeaderValue);
        }
        String[] forwardedProtocols = RemoteIpValve.commaDelimitedListToStringArray(protocolHeaderValue);
        if (forwardedProtocols.length == 0) {
            return false;
        }
        for (String forwardedProtocol : forwardedProtocols) {
            if (this.protocolHeaderHttpsValue.equalsIgnoreCase(forwardedProtocol)) continue;
            return false;
        }
        return true;
    }

    private void setPorts(Request request2, int defaultPort) {
        int port;
        block4: {
            String portHeaderValue;
            port = defaultPort;
            if (this.portHeader != null && (portHeaderValue = request2.getHeader(this.portHeader)) != null) {
                try {
                    port = Integer.parseInt(portHeaderValue);
                }
                catch (NumberFormatException nfe) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug(sm.getString("remoteIpValve.invalidPortHeader", portHeaderValue, this.portHeader), nfe);
                }
            }
        }
        request2.setServerPort(port);
        if (this.changeLocalPort) {
            request2.setLocalPort(port);
        }
    }

    public void setHttpServerPort(int httpServerPort) {
        this.httpServerPort = httpServerPort;
    }

    public void setHttpsServerPort(int httpsServerPort) {
        this.httpsServerPort = httpsServerPort;
    }

    public void setInternalProxies(String internalProxies) {
        this.internalProxies = internalProxies == null || internalProxies.length() == 0 ? null : Pattern.compile(internalProxies);
    }

    public void setProtocolHeader(String protocolHeader) {
        this.protocolHeader = protocolHeader;
    }

    public void setProtocolHeaderHttpsValue(String protocolHeaderHttpsValue) {
        this.protocolHeaderHttpsValue = protocolHeaderHttpsValue;
    }

    public void setProxiesHeader(String proxiesHeader) {
        this.proxiesHeader = proxiesHeader;
    }

    public void setRemoteIpHeader(String remoteIpHeader) {
        this.remoteIpHeader = remoteIpHeader;
    }

    public void setRequestAttributesEnabled(boolean requestAttributesEnabled) {
        this.requestAttributesEnabled = requestAttributesEnabled;
    }

    public void setTrustedProxies(String trustedProxies) {
        this.trustedProxies = trustedProxies == null || trustedProxies.length() == 0 ? null : Pattern.compile(trustedProxies);
    }
}

