/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import javax.naming.NamingException;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeBase;

public class PojoMessageHandlerWholeBinary
extends PojoMessageHandlerWholeBase<ByteBuffer> {
    private static final StringManager sm = StringManager.getManager(PojoMessageHandlerWholeBinary.class);
    private final boolean isForInputStream;

    public PojoMessageHandlerWholeBinary(Object pojo, Method method, Session session, EndpointConfig config, List<Class<? extends Decoder>> decoderClazzes, Object[] params, int indexPayload, boolean convert2, int indexSession, boolean isForInputStream, long maxMessageSize) {
        super(pojo, method, session, params, indexPayload, convert2, indexSession, maxMessageSize);
        if (maxMessageSize > -1L && maxMessageSize > (long)session.getMaxBinaryMessageBufferSize()) {
            if (maxMessageSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(sm.getString("pojoMessageHandlerWhole.maxBufferSize"));
            }
            session.setMaxBinaryMessageBufferSize((int)maxMessageSize);
        }
        try {
            if (decoderClazzes != null) {
                for (Class<? extends Decoder> decoderClazz : decoderClazzes) {
                    Decoder decoder;
                    if (Decoder.Binary.class.isAssignableFrom(decoderClazz)) {
                        decoder = (Decoder.Binary)this.createDecoderInstance(decoderClazz);
                        decoder.init(config);
                        this.decoders.add(decoder);
                        continue;
                    }
                    if (!Decoder.BinaryStream.class.isAssignableFrom(decoderClazz)) continue;
                    decoder = (Decoder.BinaryStream)this.createDecoderInstance(decoderClazz);
                    decoder.init(config);
                    this.decoders.add(decoder);
                }
            }
        }
        catch (ReflectiveOperationException | NamingException e) {
            throw new IllegalArgumentException(e);
        }
        this.isForInputStream = isForInputStream;
    }

    @Override
    protected Object decode(ByteBuffer message) throws DecodeException {
        for (Decoder decoder : this.decoders) {
            if (decoder instanceof Decoder.Binary) {
                if (!((Decoder.Binary)decoder).willDecode(message)) continue;
                return ((Decoder.Binary)decoder).decode(message);
            }
            byte[] array = new byte[message.limit() - message.position()];
            message.get(array);
            ByteArrayInputStream bais = new ByteArrayInputStream(array);
            try {
                return ((Decoder.BinaryStream)decoder).decode(bais);
            }
            catch (IOException ioe) {
                throw new DecodeException(message, sm.getString("pojoMessageHandlerWhole.decodeIoFail"), (Throwable)ioe);
            }
        }
        return null;
    }

    @Override
    protected Object convert(ByteBuffer message) {
        byte[] array = new byte[message.remaining()];
        message.get(array);
        if (this.isForInputStream) {
            return new ByteArrayInputStream(array);
        }
        return array;
    }
}

