/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.Abstract2DArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.SubarraysShouldHaveSameSize;
import org.assertj.core.error.array2d.Array2dElementShouldBeDeepEqual;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Short2DArrays;
import org.assertj.core.util.VisibleForTesting;

public class Short2DArrayAssert
extends Abstract2DArrayAssert<Short2DArrayAssert, short[][], Short> {
    private final Failures failures = Failures.instance();
    @VisibleForTesting
    protected Short2DArrays short2dArrays = Short2DArrays.instance();

    public Short2DArrayAssert(short[][] actual) {
        super(actual, Short2DArrayAssert.class);
    }

    @Override
    public Short2DArrayAssert isDeepEqualTo(short[][] expected) {
        if (this.actual == expected) {
            return (Short2DArrayAssert)this.myself;
        }
        this.isNotNull();
        if (expected.length != ((short[][])this.actual).length) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(this.actual, expected, ((short[][])this.actual).length, expected.length));
        }
        for (int i2 = 0; i2 < ((short[][])this.actual).length; ++i2) {
            short[] actualSubArray = ((short[][])this.actual)[i2];
            short[] expectedSubArray = expected[i2];
            if (actualSubArray == expectedSubArray) continue;
            if (actualSubArray == null) {
                throw this.failures.failure((AssertionInfo)this.info, ShouldNotBeNull.shouldNotBeNull("actual[" + i2 + "]"));
            }
            if (expectedSubArray.length != actualSubArray.length) {
                throw this.failures.failure(this.info, SubarraysShouldHaveSameSize.subarraysShouldHaveSameSize(this.actual, expected, actualSubArray, actualSubArray.length, expectedSubArray, expectedSubArray.length, i2), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
            for (int j = 0; j < actualSubArray.length; ++j) {
                if (actualSubArray[j] == expectedSubArray[j]) continue;
                throw this.failures.failure(this.info, Array2dElementShouldBeDeepEqual.elementShouldBeEqual(actualSubArray[j], expectedSubArray[j], i2, j), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
        }
        return (Short2DArrayAssert)this.myself;
    }

    @Override
    public Short2DArrayAssert isEqualTo(Object expected) {
        return (Short2DArrayAssert)super.isEqualTo(expected);
    }

    @Override
    public void isNullOrEmpty() {
        this.short2dArrays.assertNullOrEmpty(this.info, (short[][])this.actual);
    }

    @Override
    public void isEmpty() {
        this.short2dArrays.assertEmpty(this.info, (short[][])this.actual);
    }

    @Override
    public Short2DArrayAssert isNotEmpty() {
        this.short2dArrays.assertNotEmpty(this.info, (short[][])this.actual);
        return (Short2DArrayAssert)this.myself;
    }

    @Override
    public Short2DArrayAssert hasDimensions(int expectedFirstDimension, int expectedSecondDimension) {
        this.short2dArrays.assertHasDimensions(this.info, (short[][])this.actual, expectedFirstDimension, expectedSecondDimension);
        return (Short2DArrayAssert)this.myself;
    }

    @Override
    public Short2DArrayAssert hasNumberOfRows(int expected) {
        this.short2dArrays.assertNumberOfRows(this.info, (short[][])this.actual, expected);
        return (Short2DArrayAssert)this.myself;
    }

    @Override
    public Short2DArrayAssert hasSameDimensionsAs(Object array) {
        this.short2dArrays.assertHasSameDimensionsAs(this.info, (short[][])this.actual, array);
        return (Short2DArrayAssert)this.myself;
    }

    public Short2DArrayAssert contains(short[] value, Index index) {
        this.short2dArrays.assertContains(this.info, (short[][])this.actual, value, index);
        return (Short2DArrayAssert)this.myself;
    }

    public Short2DArrayAssert contains(int[] value, Index index) {
        this.short2dArrays.assertContains(this.info, (short[][])this.actual, Short2DArrayAssert.toShort(value), index);
        return (Short2DArrayAssert)this.myself;
    }

    public Short2DArrayAssert doesNotContain(short[] value, Index index) {
        this.short2dArrays.assertDoesNotContain(this.info, (short[][])this.actual, value, index);
        return (Short2DArrayAssert)this.myself;
    }

    public Short2DArrayAssert doesNotContain(int[] value, Index index) {
        this.short2dArrays.assertDoesNotContain(this.info, (short[][])this.actual, Short2DArrayAssert.toShort(value), index);
        return (Short2DArrayAssert)this.myself;
    }

    private static short[] toShort(int[] value) {
        short[] shortArray = new short[value.length];
        for (int i2 = 0; i2 < value.length; ++i2) {
            shortArray[i2] = (short)value[i2];
        }
        return shortArray;
    }
}

