/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.List;
import java.util.function.Consumer;
import org.junit.jupiter.api.ClassDescriptor;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.TestClassOrder;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.discovery.AbstractAnnotatedDescriptorWrapper;
import org.junit.jupiter.engine.discovery.AbstractOrderingVisitor;
import org.junit.jupiter.engine.discovery.DefaultClassDescriptor;
import org.junit.jupiter.engine.discovery.DefaultClassOrdererContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;

class ClassOrderingVisitor
extends AbstractOrderingVisitor<JupiterEngineDescriptor, ClassBasedTestDescriptor, DefaultClassDescriptor> {
    private final JupiterConfiguration configuration;

    ClassOrderingVisitor(JupiterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void visit(TestDescriptor testDescriptor) {
        ClassOrderer globalClassOrderer = this.configuration.getDefaultTestClassOrderer().orElse(null);
        this.doWithMatchingDescriptor(JupiterEngineDescriptor.class, testDescriptor, descriptor -> this.orderContainedClasses((JupiterEngineDescriptor)descriptor, globalClassOrderer), descriptor -> "Failed to order classes");
    }

    private void orderContainedClasses(JupiterEngineDescriptor jupiterEngineDescriptor, ClassOrderer classOrderer) {
        this.orderChildrenTestDescriptors(jupiterEngineDescriptor, ClassBasedTestDescriptor.class, DefaultClassDescriptor::new, this.createDescriptorWrapperOrderer(classOrderer));
    }

    @Override
    protected AbstractOrderingVisitor.DescriptorWrapperOrderer getDescriptorWrapperOrderer(AbstractOrderingVisitor.DescriptorWrapperOrderer inheritedDescriptorWrapperOrderer, AbstractAnnotatedDescriptorWrapper<?> descriptorWrapper) {
        Object annotatedElement = descriptorWrapper.getAnnotatedElement();
        return AnnotationUtils.findAnnotation(annotatedElement, TestClassOrder.class).map(TestClassOrder::value).map(x$0 -> (ClassOrderer)ReflectionUtils.newInstance(x$0, new Object[0])).map(this::createDescriptorWrapperOrderer).orElse(inheritedDescriptorWrapperOrderer);
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer createDescriptorWrapperOrderer(ClassOrderer classOrderer) {
        Consumer orderingAction = classOrderer == null ? null : classDescriptors -> classOrderer.orderClasses(new DefaultClassOrdererContext((List<? extends ClassDescriptor>)classDescriptors, this.configuration));
        AbstractOrderingVisitor.MessageGenerator descriptorsAddedMessageGenerator = number -> String.format("ClassOrderer [%s] added %s ClassDescriptor(s) which will be ignored.", ClassOrderingVisitor.nullSafeToString(classOrderer), number);
        AbstractOrderingVisitor.MessageGenerator descriptorsRemovedMessageGenerator = number -> String.format("ClassOrderer [%s] removed %s ClassDescriptor(s) which will be retained with arbitrary ordering.", ClassOrderingVisitor.nullSafeToString(classOrderer), number);
        return new AbstractOrderingVisitor.DescriptorWrapperOrderer(orderingAction, descriptorsAddedMessageGenerator, descriptorsRemovedMessageGenerator);
    }

    private static String nullSafeToString(ClassOrderer classOrderer) {
        return classOrderer != null ? classOrderer.getClass().getName() : "<unknown>";
    }
}

