/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.autoconfigure.AutoConfigurationImportFilter;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

abstract class FilteringSpringBootCondition
extends SpringBootCondition
implements AutoConfigurationImportFilter,
BeanFactoryAware,
BeanClassLoaderAware {
    private BeanFactory beanFactory;
    private ClassLoader beanClassLoader;

    FilteringSpringBootCondition() {
    }

    @Override
    public boolean[] match(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        ConditionEvaluationReport report = ConditionEvaluationReport.find(this.beanFactory);
        ConditionOutcome[] outcomes = this.getOutcomes(autoConfigurationClasses, autoConfigurationMetadata);
        boolean[] match = new boolean[outcomes.length];
        for (int i2 = 0; i2 < outcomes.length; ++i2) {
            boolean bl = match[i2] = outcomes[i2] == null || outcomes[i2].isMatch();
            if (match[i2] || outcomes[i2] == null) continue;
            this.logOutcome(autoConfigurationClasses[i2], outcomes[i2]);
            if (report == null) continue;
            report.recordConditionEvaluation(autoConfigurationClasses[i2], this, outcomes[i2]);
        }
        return match;
    }

    protected abstract ConditionOutcome[] getOutcomes(String[] var1, AutoConfigurationMetadata var2);

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected final ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected final List<String> filter(Collection<String> classNames, ClassNameFilter classNameFilter, ClassLoader classLoader) {
        if (CollectionUtils.isEmpty(classNames)) {
            return Collections.emptyList();
        }
        ArrayList<String> matches = new ArrayList<String>(classNames.size());
        for (String candidate : classNames) {
            if (!classNameFilter.matches(candidate, classLoader)) continue;
            matches.add(candidate);
        }
        return matches;
    }

    protected static Class<?> resolve(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader != null) {
            return Class.forName(className, false, classLoader);
        }
        return Class.forName(className);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum ClassNameFilter {
        PRESENT{

            @Override
            public boolean matches(String className, ClassLoader classLoader) {
                return 1.isPresent(className, classLoader);
            }
        }
        ,
        MISSING{

            @Override
            public boolean matches(String className, ClassLoader classLoader) {
                return !2.isPresent(className, classLoader);
            }
        };


        abstract boolean matches(String var1, ClassLoader var2);

        static boolean isPresent(String className, ClassLoader classLoader) {
            if (classLoader == null) {
                classLoader = ClassUtils.getDefaultClassLoader();
            }
            try {
                FilteringSpringBootCondition.resolve(className, classLoader);
                return true;
            }
            catch (Throwable ex) {
                return false;
            }
        }
    }
}

