/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.webservices.client;

import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.util.ClassUtils;
import org.springframework.ws.test.client.MockWebServiceServer;

public class MockWebServiceServerTestExecutionListener
extends AbstractTestExecutionListener {
    private static final String MOCK_SERVER_CLASS = "org.springframework.ws.test.client.MockWebServiceServer";

    @Override
    public int getOrder() {
        return 2147483547;
    }

    @Override
    public void afterTestMethod(TestContext testContext) {
        if (this.isMockWebServiceServerPresent()) {
            String[] names;
            ApplicationContext applicationContext = testContext.getApplicationContext();
            for (String name : names = applicationContext.getBeanNamesForType(MockWebServiceServer.class, false, false)) {
                MockWebServiceServer mockServer = applicationContext.getBean(name, MockWebServiceServer.class);
                mockServer.verify();
                mockServer.reset();
            }
        }
    }

    private boolean isMockWebServiceServerPresent() {
        return ClassUtils.isPresent(MOCK_SERVER_CLASS, this.getClass().getClassLoader());
    }
}

