/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.util.List;
import org.mockito.MockSettings;
import org.mockito.MockingDetails;
import org.mockito.Mockito;
import org.mockito.listeners.InvocationListener;
import org.mockito.listeners.MethodInvocationReport;
import org.mockito.mock.MockCreationSettings;
import org.springframework.util.Assert;

public enum MockReset {
    BEFORE,
    AFTER,
    NONE;


    public static MockSettings before() {
        return MockReset.withSettings(BEFORE);
    }

    public static MockSettings after() {
        return MockReset.withSettings(AFTER);
    }

    public static MockSettings withSettings(MockReset reset2) {
        return MockReset.apply(reset2, Mockito.withSettings());
    }

    public static MockSettings apply(MockReset reset2, MockSettings settings) {
        Assert.notNull((Object)settings, "Settings must not be null");
        if (reset2 != null && reset2 != NONE) {
            settings.invocationListeners(new ResetInvocationListener(reset2));
        }
        return settings;
    }

    static MockReset get(Object mock) {
        MockReset reset2 = NONE;
        MockingDetails mockingDetails = Mockito.mockingDetails(mock);
        if (mockingDetails.isMock()) {
            MockCreationSettings<?> settings = mockingDetails.getMockCreationSettings();
            List<InvocationListener> listeners = settings.getInvocationListeners();
            for (InvocationListener listener : listeners) {
                if (!(listener instanceof ResetInvocationListener)) continue;
                ResetInvocationListener resetInvocationListener = (ResetInvocationListener)listener;
                reset2 = resetInvocationListener.getReset();
            }
        }
        return reset2;
    }

    private static class ResetInvocationListener
    implements InvocationListener {
        private final MockReset reset;

        ResetInvocationListener(MockReset reset2) {
            this.reset = reset2;
        }

        MockReset getReset() {
            return this.reset;
        }

        @Override
        public void reportInvocation(MethodInvocationReport methodInvocationReport) {
        }
    }
}

