/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Base64Utils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ResourceUtils;

final class PrivateKeyParser {
    private static final String PKCS1_HEADER = "-+BEGIN\\s+RSA\\s+PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+";
    private static final String PKCS1_FOOTER = "-+END\\s+RSA\\s+PRIVATE\\s+KEY[^-]*-+";
    private static final String PKCS8_HEADER = "-+BEGIN\\s+PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+";
    private static final String PKCS8_FOOTER = "-+END\\s+PRIVATE\\s+KEY[^-]*-+";
    private static final String EC_HEADER = "-+BEGIN\\s+EC\\s+PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+";
    private static final String EC_FOOTER = "-+END\\s+EC\\s+PRIVATE\\s+KEY[^-]*-+";
    private static final String BASE64_TEXT = "([a-z0-9+/=\\r\\n]+)";
    private static final List<PemParser> PEM_PARSERS;
    private static final int[] RSA_ALGORITHM;
    private static final int[] EC_ALGORITHM;
    private static final int[] EC_PARAMETERS;

    private PrivateKeyParser() {
    }

    private static PKCS8EncodedKeySpec createKeySpecForPkcs1(byte[] bytes) {
        return PrivateKeyParser.createKeySpecForAlgorithm(bytes, RSA_ALGORITHM, null);
    }

    private static PKCS8EncodedKeySpec createKeySpecForEc(byte[] bytes) {
        return PrivateKeyParser.createKeySpecForAlgorithm(bytes, EC_ALGORITHM, EC_PARAMETERS);
    }

    private static PKCS8EncodedKeySpec createKeySpecForAlgorithm(byte[] bytes, int[] algorithm, int[] parameters) {
        try {
            DerEncoder encoder = new DerEncoder();
            encoder.integer(0);
            DerEncoder algorithmIdentifier = new DerEncoder();
            algorithmIdentifier.objectIdentifier(algorithm);
            algorithmIdentifier.objectIdentifier(parameters);
            byte[] byteArray = algorithmIdentifier.toByteArray();
            encoder.sequence(byteArray);
            encoder.octetString(bytes);
            return new PKCS8EncodedKeySpec(encoder.toSequence());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static PrivateKey parse(String resource) {
        try {
            String text = PrivateKeyParser.readText(resource);
            for (PemParser pemParser : PEM_PARSERS) {
                PrivateKey privateKey = pemParser.parse(text);
                if (privateKey == null) continue;
                return privateKey;
            }
            throw new IllegalStateException("Unrecognized private key format");
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error loading private key file " + resource, ex);
        }
    }

    private static String readText(String resource) throws IOException {
        URL url = ResourceUtils.getURL(resource);
        try (InputStreamReader reader = new InputStreamReader(url.openStream());){
            String string = FileCopyUtils.copyToString(reader);
            return string;
        }
    }

    static {
        ArrayList<PemParser> parsers = new ArrayList<PemParser>();
        parsers.add(new PemParser(PKCS1_HEADER, PKCS1_FOOTER, "RSA", PrivateKeyParser::createKeySpecForPkcs1));
        parsers.add(new PemParser(EC_HEADER, EC_FOOTER, "EC", PrivateKeyParser::createKeySpecForEc));
        parsers.add(new PemParser(PKCS8_HEADER, PKCS8_FOOTER, "RSA", PKCS8EncodedKeySpec::new));
        PEM_PARSERS = Collections.unmodifiableList(parsers);
        RSA_ALGORITHM = new int[]{42, 134, 72, 134, 247, 13, 1, 1, 1};
        EC_ALGORITHM = new int[]{42, 134, 72, 206, 61, 2, 1};
        EC_PARAMETERS = new int[]{43, 129, 4, 0, 34};
    }

    static class DerEncoder {
        private final ByteArrayOutputStream stream = new ByteArrayOutputStream();

        DerEncoder() {
        }

        void objectIdentifier(int ... encodedObjectIdentifier) throws IOException {
            int code = encodedObjectIdentifier != null ? 6 : 5;
            this.codeLengthBytes(code, DerEncoder.bytes(encodedObjectIdentifier));
        }

        void integer(int ... encodedInteger) throws IOException {
            this.codeLengthBytes(2, DerEncoder.bytes(encodedInteger));
        }

        void octetString(byte[] bytes) throws IOException {
            this.codeLengthBytes(4, bytes);
        }

        void sequence(int ... elements) throws IOException {
            this.sequence(DerEncoder.bytes(elements));
        }

        void sequence(byte[] bytes) throws IOException {
            this.codeLengthBytes(48, bytes);
        }

        void codeLengthBytes(int code, byte[] bytes) throws IOException {
            int length;
            this.stream.write(code);
            int n = length = bytes != null ? bytes.length : 0;
            if (length <= 127) {
                this.stream.write(length & 0xFF);
            } else {
                ByteArrayOutputStream lengthStream = new ByteArrayOutputStream();
                while (length != 0) {
                    lengthStream.write(length & 0xFF);
                    length >>= 8;
                }
                byte[] lengthBytes = lengthStream.toByteArray();
                this.stream.write(0x80 | lengthBytes.length);
                for (int i2 = lengthBytes.length - 1; i2 >= 0; --i2) {
                    this.stream.write(lengthBytes[i2]);
                }
            }
            if (bytes != null) {
                this.stream.write(bytes);
            }
        }

        private static byte[] bytes(int ... elements) {
            if (elements == null) {
                return null;
            }
            byte[] result = new byte[elements.length];
            for (int i2 = 0; i2 < elements.length; ++i2) {
                result[i2] = (byte)elements[i2];
            }
            return result;
        }

        byte[] toSequence() throws IOException {
            DerEncoder sequenceEncoder = new DerEncoder();
            sequenceEncoder.sequence(this.toByteArray());
            return sequenceEncoder.toByteArray();
        }

        byte[] toByteArray() {
            return this.stream.toByteArray();
        }
    }

    private static class PemParser {
        private final Pattern pattern;
        private final String algorithm;
        private final Function<byte[], PKCS8EncodedKeySpec> keySpecFactory;

        PemParser(String header, String footer, String algorithm, Function<byte[], PKCS8EncodedKeySpec> keySpecFactory) {
            this.pattern = Pattern.compile(header + PrivateKeyParser.BASE64_TEXT + footer, 2);
            this.algorithm = algorithm;
            this.keySpecFactory = keySpecFactory;
        }

        PrivateKey parse(String text) {
            Matcher matcher = this.pattern.matcher(text);
            return !matcher.find() ? null : this.parse(PemParser.decodeBase64(matcher.group(1)));
        }

        private static byte[] decodeBase64(String content) {
            byte[] contentBytes = content.replaceAll("\r", "").replaceAll("\n", "").getBytes();
            return Base64Utils.decode(contentBytes);
        }

        private PrivateKey parse(byte[] bytes) {
            try {
                PKCS8EncodedKeySpec keySpec = this.keySpecFactory.apply(bytes);
                KeyFactory keyFactory = KeyFactory.getInstance(this.algorithm);
                return keyFactory.generatePrivate(keySpec);
            }
            catch (GeneralSecurityException ex) {
                throw new IllegalArgumentException("Unexpected key format", ex);
            }
        }
    }
}

