/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.filter.OncePerRequestFilter;

public class ApplicationContextHeaderFilter
extends OncePerRequestFilter {
    public static final String HEADER_NAME = "X-Application-Context";
    private final ApplicationContext applicationContext;

    public ApplicationContextHeaderFilter(ApplicationContext context) {
        this.applicationContext = context;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request2, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        response.addHeader(HEADER_NAME, this.applicationContext.getId());
        filterChain.doFilter(request2, response);
    }
}

