/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.Nullable;

public class KotlinReflectionParameterNameDiscoverer
implements ParameterNameDiscoverer {
    @Override
    @Nullable
    public String[] getParameterNames(Method method) {
        if (!KotlinDetector.isKotlinType(method.getDeclaringClass())) {
            return null;
        }
        try {
            KFunction function = ReflectJvmMapping.getKotlinFunction((Method)method);
            return function != null ? this.getParameterNames(function.getParameters()) : null;
        }
        catch (UnsupportedOperationException ex) {
            return null;
        }
    }

    @Override
    @Nullable
    public String[] getParameterNames(Constructor<?> ctor) {
        if (ctor.getDeclaringClass().isEnum() || !KotlinDetector.isKotlinType(ctor.getDeclaringClass())) {
            return null;
        }
        try {
            KFunction function = ReflectJvmMapping.getKotlinFunction(ctor);
            return function != null ? this.getParameterNames(function.getParameters()) : null;
        }
        catch (UnsupportedOperationException ex) {
            return null;
        }
    }

    @Nullable
    private String[] getParameterNames(List<KParameter> parameters) {
        List<KParameter> filteredParameters = parameters.stream().filter(p -> KParameter.Kind.VALUE.equals((Object)p.getKind()) || KParameter.Kind.EXTENSION_RECEIVER.equals((Object)p.getKind())).toList();
        String[] parameterNames = new String[filteredParameters.size()];
        for (int i2 = 0; i2 < filteredParameters.size(); ++i2) {
            String name;
            KParameter parameter = filteredParameters.get(i2);
            String string = name = KParameter.Kind.EXTENSION_RECEIVER.equals((Object)parameter.getKind()) ? "$receiver" : parameter.getName();
            if (name == null) {
                return null;
            }
            parameterNames[i2] = name;
        }
        return parameterNames;
    }
}

