/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.cache.CacheStatistics;
import org.springframework.data.redis.cache.CacheStatisticsCollector;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

enum NoOpCacheStatisticsCollector implements CacheStatisticsCollector
{
    INSTANCE;


    @Override
    public void incPuts(String cacheName) {
    }

    @Override
    public void incGets(String cacheName) {
    }

    @Override
    public void incHits(String cacheName) {
    }

    @Override
    public void incMisses(String cacheName) {
    }

    @Override
    public void incDeletesBy(String cacheName, int value) {
    }

    @Override
    public void incLockTime(String name, long durationNS) {
    }

    @Override
    public void reset(String cacheName) {
    }

    @Override
    public CacheStatistics getCacheStatistics(String cacheName) {
        return new EmptyStatistics(cacheName);
    }

    private static class EmptyStatistics
    implements CacheStatistics {
        private final String cacheName;

        EmptyStatistics(String cacheName) {
            this.cacheName = cacheName;
        }

        @Override
        public String getCacheName() {
            return this.cacheName;
        }

        @Override
        public long getPuts() {
            return 0L;
        }

        @Override
        public long getGets() {
            return 0L;
        }

        @Override
        public long getHits() {
            return 0L;
        }

        @Override
        public long getMisses() {
            return 0L;
        }

        @Override
        public long getDeletes() {
            return 0L;
        }

        @Override
        public long getLockWaitDuration(TimeUnit unit) {
            return 0L;
        }

        @Override
        public Instant getSince() {
            return Instant.EPOCH;
        }

        @Override
        public Instant getLastReset() {
            return this.getSince();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EmptyStatistics that = (EmptyStatistics)o;
            return ObjectUtils.nullSafeEquals(this.cacheName, that.cacheName);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.cacheName);
        }
    }
}

