/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisServer;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.convert.ListConverter;
import org.springframework.data.redis.connection.convert.SetConverter;
import org.springframework.data.redis.connection.convert.StringToRedisClientInfoConverter;
import org.springframework.data.redis.connection.zset.DefaultTuple;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.domain.geo.BoundingBox;
import org.springframework.data.redis.domain.geo.BoxShape;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import org.springframework.data.redis.domain.geo.RadiusShape;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.args.BitOP;
import redis.clients.jedis.args.FlushMode;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.args.ListPosition;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.GeoSearchParam;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.SortingParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.resps.GeoRadiusResponse;
import redis.clients.jedis.util.SafeEncoder;

abstract class JedisConverters
extends Converters {
    public static final byte[] PLUS_BYTES = JedisConverters.toBytes("+");
    public static final byte[] MINUS_BYTES = JedisConverters.toBytes("-");
    public static final byte[] POSITIVE_INFINITY_BYTES = JedisConverters.toBytes("+inf");
    public static final byte[] NEGATIVE_INFINITY_BYTES = JedisConverters.toBytes("-inf");

    JedisConverters() {
    }

    public static Converter<String, byte[]> stringToBytes() {
        return JedisConverters::toBytes;
    }

    static ListConverter<redis.clients.jedis.resps.Tuple, Tuple> tuplesToTuples() {
        return new ListConverter<redis.clients.jedis.resps.Tuple, Tuple>(JedisConverters::toTuple);
    }

    static ListConverter<String, byte[]> stringListToByteList() {
        return new ListConverter<String, byte[]>(JedisConverters.stringToBytes());
    }

    static Set<Tuple> toTupleSet(Set<redis.clients.jedis.resps.Tuple> source) {
        return new SetConverter<redis.clients.jedis.resps.Tuple, Tuple>(JedisConverters::toTuple).convert(source);
    }

    public static Tuple toTuple(redis.clients.jedis.resps.Tuple source) {
        return new DefaultTuple(source.getBinaryElement(), source.getScore());
    }

    public static Map<byte[], Double> toTupleMap(Set<Tuple> tuples) {
        Assert.notNull(tuples, "Tuple set must not be null");
        LinkedHashMap<byte[], Double> args = new LinkedHashMap<byte[], Double>(tuples.size(), 1.0f);
        for (Tuple tuple : tuples) {
            args.put(tuple.getValue(), tuple.getScore());
        }
        return args;
    }

    public static byte[] toBytes(Integer source) {
        return String.valueOf(source).getBytes();
    }

    public static byte[] toBytes(Long source) {
        return String.valueOf(source).getBytes();
    }

    public static byte[] toBytes(Double source) {
        return JedisConverters.toBytes(String.valueOf(source));
    }

    @Nullable
    public static byte[] toBytes(@Nullable String source) {
        return source == null ? null : SafeEncoder.encode((String)source);
    }

    @Nullable
    public static String toString(@Nullable byte[] source) {
        return source == null ? null : SafeEncoder.encode((byte[])source);
    }

    public static Long toLong(byte[] source) {
        return Long.valueOf(JedisConverters.toString(source));
    }

    public static ValueEncoding toEncoding(byte[] source) {
        return ValueEncoding.of(JedisConverters.toString(source));
    }

    public static RedisClusterNode toNode(Object source) {
        List values = (List)source;
        RedisClusterNode.SlotRange range = new RedisClusterNode.SlotRange(((Number)values.get(0)).intValue(), ((Number)values.get(1)).intValue());
        List nodeInfo = (List)values.get(2);
        return new RedisClusterNode(JedisConverters.toString((byte[])nodeInfo.get(0)), ((Number)nodeInfo.get(1)).intValue(), range);
    }

    public static List<RedisClientInfo> toListOfRedisClientInformation(String source) {
        if (!StringUtils.hasText(source)) {
            return Collections.emptyList();
        }
        return StringToRedisClientInfoConverter.INSTANCE.convert(source.split("\\r?\\n"));
    }

    public static List<RedisServer> toListOfRedisServer(List<Map<String, String>> source) {
        return JedisConverters.toList(it -> RedisServer.newServerFrom(Converters.toProperties(it)), source);
    }

    public static ListPosition toListPosition(RedisListCommands.Position source) {
        Assert.notNull((Object)source, "list positions are mandatory");
        return RedisListCommands.Position.AFTER.equals((Object)source) ? ListPosition.AFTER : ListPosition.BEFORE;
    }

    public static byte[][] toByteArrays(Map<byte[], byte[]> source) {
        byte[][] result = new byte[source.size() * 2][];
        int index = 0;
        for (Map.Entry<byte[], byte[]> entry : source.entrySet()) {
            result[index++] = entry.getKey();
            result[index++] = entry.getValue();
        }
        return result;
    }

    @Nullable
    public static SortingParams toSortingParams(@Nullable SortParameters params) {
        SortingParams jedisParams = null;
        if (params != null) {
            Boolean isAlpha;
            SortParameters.Order order;
            SortParameters.Range limit;
            byte[][] getPattern;
            jedisParams = new SortingParams();
            byte[] byPattern = params.getByPattern();
            if (byPattern != null) {
                jedisParams.by(params.getByPattern());
            }
            if ((getPattern = params.getGetPattern()) != null) {
                jedisParams.get(getPattern);
            }
            if ((limit = params.getLimit()) != null) {
                jedisParams.limit((int)limit.getStart(), (int)limit.getCount());
            }
            if ((order = params.getOrder()) != null && order.equals((Object)SortParameters.Order.DESC)) {
                jedisParams.desc();
            }
            if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
                jedisParams.alpha();
            }
        }
        return jedisParams;
    }

    public static BitOP toBitOp(RedisStringCommands.BitOperation bitOp) {
        switch (bitOp) {
            case AND: {
                return BitOP.AND;
            }
            case OR: {
                return BitOP.OR;
            }
            case NOT: {
                return BitOP.NOT;
            }
            case XOR: {
                return BitOP.XOR;
            }
        }
        throw new IllegalArgumentException();
    }

    public static byte[] boundaryToBytesForZRange(@Nullable Range.Bound<?> boundary, byte[] defaultValue) {
        if (boundary == null || !boundary.isBounded()) {
            return defaultValue;
        }
        return JedisConverters.boundaryToBytes(boundary, new byte[0], JedisConverters.toBytes("("));
    }

    public static byte[] boundaryToBytesForZRangeByLex(@Nullable Range.Bound<byte[]> boundary, byte[] defaultValue) {
        if (boundary == null || !boundary.isBounded()) {
            return defaultValue;
        }
        return JedisConverters.boundaryToBytes(boundary, JedisConverters.toBytes("["), JedisConverters.toBytes("("));
    }

    public static SetParams toSetCommandExPxArgument(Expiration expiration) {
        return JedisConverters.toSetCommandExPxArgument(expiration, SetParams.setParams());
    }

    public static SetParams toSetCommandExPxArgument(Expiration expiration, SetParams params) {
        SetParams paramsToUse;
        SetParams setParams = paramsToUse = params == null ? SetParams.setParams() : params;
        if (expiration.isKeepTtl()) {
            return paramsToUse.keepttl();
        }
        if (expiration.isPersistent()) {
            return paramsToUse;
        }
        if (expiration.getTimeUnit() == TimeUnit.MILLISECONDS) {
            return expiration.isUnixTimestamp() ? paramsToUse.pxAt(expiration.getExpirationTime()) : paramsToUse.px(expiration.getExpirationTime());
        }
        return expiration.isUnixTimestamp() ? paramsToUse.exAt(expiration.getConverted(TimeUnit.SECONDS)) : paramsToUse.ex(expiration.getConverted(TimeUnit.SECONDS));
    }

    static GetExParams toGetExParams(Expiration expiration) {
        GetExParams params = new GetExParams();
        if (expiration.isPersistent()) {
            return params.persist();
        }
        if (expiration.getTimeUnit() == TimeUnit.MILLISECONDS) {
            if (expiration.isUnixTimestamp()) {
                return params.pxAt(expiration.getExpirationTime());
            }
            return params.px(expiration.getExpirationTime());
        }
        return expiration.isUnixTimestamp() ? params.exAt(expiration.getConverted(TimeUnit.SECONDS)) : params.ex(expiration.getConverted(TimeUnit.SECONDS));
    }

    public static SetParams toSetCommandNxXxArgument(RedisStringCommands.SetOption option) {
        return JedisConverters.toSetCommandNxXxArgument(option, SetParams.setParams());
    }

    public static SetParams toSetCommandNxXxArgument(RedisStringCommands.SetOption option, SetParams params) {
        SetParams paramsToUse = params == null ? SetParams.setParams() : params;
        switch (option) {
            case SET_IF_PRESENT: {
                return paramsToUse.xx();
            }
            case SET_IF_ABSENT: {
                return paramsToUse.nx();
            }
        }
        return paramsToUse;
    }

    private static byte[] boundaryToBytes(Range.Bound<?> boundary, byte[] inclPrefix, byte[] exclPrefix) {
        byte[] prefix = boundary.isInclusive() ? inclPrefix : exclPrefix;
        byte[] value = null;
        Object theValue = boundary.getValue().get();
        if (theValue instanceof byte[]) {
            value = (byte[])theValue;
        } else if (theValue instanceof Double) {
            value = JedisConverters.toBytes((Double)theValue);
        } else if (theValue instanceof Long) {
            value = JedisConverters.toBytes((Long)theValue);
        } else if (theValue instanceof Integer) {
            value = JedisConverters.toBytes((Integer)theValue);
        } else if (theValue instanceof String) {
            value = JedisConverters.toBytes((String)theValue);
        } else {
            throw new IllegalArgumentException(String.format("Cannot convert %s to binary format", boundary.getValue()));
        }
        ByteBuffer buffer = ByteBuffer.allocate(prefix.length + value.length);
        buffer.put(prefix);
        buffer.put(value);
        return buffer.array();
    }

    public static ScanParams toScanParams(ScanOptions options2) {
        ScanParams sp = new ScanParams();
        if (!options2.equals(ScanOptions.NONE)) {
            byte[] pattern;
            if (options2.getCount() != null) {
                sp.count(Integer.valueOf(options2.getCount().intValue()));
            }
            if ((pattern = options2.getBytePattern()) != null) {
                sp.match(pattern);
            }
        }
        return sp;
    }

    static Long toTime(List<String> source, TimeUnit timeUnit) {
        Assert.notEmpty(source, "Received invalid result from server; Expected 2 items in collection");
        Assert.isTrue(source.size() == 2, "Received invalid nr of arguments from redis server; Expected 2 received " + source.size());
        Assert.notNull((Object)timeUnit, "TimeUnit must not be null");
        return JedisConverters.toTimeMillis(source.get(0), source.get(1), timeUnit);
    }

    public static List<String> toStrings(List<byte[]> source) {
        return JedisConverters.toList(JedisConverters::toString, source);
    }

    private static <S, T> List<T> toList(Converter<S, T> converter, @Nullable Collection<S> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> target = new ArrayList<T>(source.size());
        for (S s : source) {
            target.add(converter.convert(s));
        }
        return target;
    }

    public static ListConverter<GeoCoordinate, Point> geoCoordinateToPointConverter() {
        return new ListConverter<GeoCoordinate, Point>(JedisConverters::toPoint);
    }

    @Nullable
    static Point toPoint(@Nullable GeoCoordinate geoCoordinate) {
        return geoCoordinate == null ? null : new Point(geoCoordinate.getLongitude(), geoCoordinate.getLatitude());
    }

    public static GeoCoordinate toGeoCoordinate(Point source) {
        return new GeoCoordinate(source.getX(), source.getY());
    }

    public static Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> geoRadiusResponseToGeoResultsConverter(Metric metric) {
        return GeoResultsConverterFactory.INSTANCE.forMetric(metric);
    }

    public static GeoUnit toGeoUnit(Metric metric) {
        RedisGeoCommands.DistanceUnit metricToUse = metric == null || ObjectUtils.nullSafeEquals(Metrics.NEUTRAL, metric) ? RedisGeoCommands.DistanceUnit.METERS : metric;
        return (GeoUnit)ObjectUtils.caseInsensitiveValueOf((Enum[])GeoUnit.values(), (String)metricToUse.getAbbreviation());
    }

    static ZAddParams toZAddParams(final RedisZSetCommands.ZAddArgs source) {
        if (!source.isEmpty()) {
            return new ZAddParams();
        }
        ZAddParams target = new ZAddParams(){
            {
                if (source.contains(RedisZSetCommands.ZAddArgs.Flag.GT)) {
                    this.addParam("gt");
                }
                if (source.contains(RedisZSetCommands.ZAddArgs.Flag.LT)) {
                    this.addParam("lt");
                }
            }
        };
        if (source.contains(RedisZSetCommands.ZAddArgs.Flag.XX)) {
            target.xx();
        }
        if (source.contains(RedisZSetCommands.ZAddArgs.Flag.NX)) {
            target.nx();
        }
        if (source.contains(RedisZSetCommands.ZAddArgs.Flag.CH)) {
            target.ch();
        }
        return target;
    }

    public static GeoRadiusParam toGeoRadiusParam(RedisGeoCommands.GeoRadiusCommandArgs source) {
        GeoRadiusParam param = GeoRadiusParam.geoRadiusParam();
        if (source == null) {
            return param;
        }
        if (source.hasFlags()) {
            for (RedisGeoCommands.GeoRadiusCommandArgs.Flag flag : source.getFlags()) {
                switch (flag) {
                    case WITHCOORD: {
                        param.withCoord();
                        break;
                    }
                    case WITHDIST: {
                        param.withDist();
                    }
                }
            }
        }
        if (source.hasSortDirection()) {
            switch (source.getSortDirection()) {
                case ASC: {
                    param.sortAscending();
                    break;
                }
                case DESC: {
                    param.sortDescending();
                }
            }
        }
        if (source.hasLimit()) {
            param.count(source.getLimit().intValue());
        }
        return param;
    }

    static double toSeconds(long timeout, TimeUnit unit) {
        switch (unit) {
            case MILLISECONDS: 
            case MICROSECONDS: 
            case NANOSECONDS: {
                return (double)unit.toMillis(timeout) / 1000.0;
            }
        }
        return unit.toSeconds(timeout);
    }

    public static byte[][] toBitfieldCommandArguments(BitFieldSubCommands source) {
        ArrayList<byte[]> args = new ArrayList<byte[]>(source.getSubCommands().size() * 4);
        for (BitFieldSubCommands.BitFieldSubCommand command : source.getSubCommands()) {
            BitFieldSubCommands.BitFieldIncrBy.Overflow overflow;
            if (command instanceof BitFieldSubCommands.BitFieldIncrBy && (overflow = ((BitFieldSubCommands.BitFieldIncrBy)command).getOverflow()) != null) {
                args.add(JedisConverters.toBytes("OVERFLOW"));
                args.add(JedisConverters.toBytes(overflow.name()));
            }
            args.add(JedisConverters.toBytes(command.getCommand()));
            args.add(JedisConverters.toBytes(command.getType().asString()));
            args.add(JedisConverters.toBytes(command.getOffset().asString()));
            if (command instanceof BitFieldSubCommands.BitFieldSet) {
                args.add(JedisConverters.toBytes(((BitFieldSubCommands.BitFieldSet)command).getValue()));
                continue;
            }
            if (!(command instanceof BitFieldSubCommands.BitFieldIncrBy)) continue;
            args.add(JedisConverters.toBytes(((BitFieldSubCommands.BitFieldIncrBy)command).getValue()));
        }
        return (byte[][])args.toArray((T[])new byte[0][0]);
    }

    static FlushMode toFlushMode(@Nullable RedisServerCommands.FlushOption option) {
        if (option == null) {
            return FlushMode.SYNC;
        }
        switch (option) {
            case ASYNC: {
                return FlushMode.ASYNC;
            }
            case SYNC: {
                return FlushMode.SYNC;
            }
        }
        throw new IllegalArgumentException("Flush option " + option + " is not supported");
    }

    static GeoSearchParam toGeoSearchParams(GeoReference<byte[]> reference, GeoShape predicate, RedisGeoCommands.GeoCommandArgs args) {
        Assert.notNull(reference, "GeoReference must not be null");
        Assert.notNull((Object)predicate, "GeoShape must not be null");
        Assert.notNull((Object)args, "GeoSearchCommandArgs must not be null");
        GeoSearchParam param = GeoSearchParam.geoSearchParam();
        JedisConverters.configureGeoReference(reference, param);
        if (args.getLimit() != null) {
            boolean hasAnyLimit = args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.ANY);
            param.count(Math.toIntExact(args.getLimit()), hasAnyLimit);
        }
        if (args.getSortDirection() != null) {
            if (args.getSortDirection() == Sort.Direction.ASC) {
                param.asc();
            } else {
                param.desc();
            }
        }
        if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHDIST)) {
            param.withDist();
        }
        if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
            param.withCoord();
        }
        return JedisConverters.getGeoSearchParam(predicate, param);
    }

    private static GeoSearchParam getGeoSearchParam(GeoShape predicate, GeoSearchParam param) {
        if (predicate instanceof RadiusShape) {
            Distance radius = ((RadiusShape)predicate).getRadius();
            param.byRadius(radius.getValue(), JedisConverters.toGeoUnit(radius.getMetric()));
            return param;
        }
        if (predicate instanceof BoxShape) {
            BoxShape boxPredicate = (BoxShape)predicate;
            BoundingBox boundingBox = boxPredicate.getBoundingBox();
            param.byBox(boundingBox.getWidth().getValue(), boundingBox.getHeight().getValue(), JedisConverters.toGeoUnit(boxPredicate.getMetric()));
            return param;
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to Jedis GeoSearchParam", predicate));
    }

    private static void configureGeoReference(GeoReference<byte[]> reference, GeoSearchParam param) {
        if (reference instanceof GeoReference.GeoMemberReference) {
            param.fromMember(JedisConverters.toString((byte[])((GeoReference.GeoMemberReference)reference).getMember()));
            return;
        }
        if (reference instanceof GeoReference.GeoCoordinateReference) {
            GeoReference.GeoCoordinateReference coordinates = (GeoReference.GeoCoordinateReference)reference;
            param.fromLonLat(coordinates.getLongitude(), coordinates.getLatitude());
            return;
        }
        throw new IllegalArgumentException(String.format("Cannot extract Geo Reference from %s", reference));
    }

    static enum GeoResultsConverterFactory {
        INSTANCE;


        Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> forMetric(Metric metric) {
            return new GeoResultsConverter(ObjectUtils.nullSafeEquals(Metrics.NEUTRAL, metric) ? RedisGeoCommands.DistanceUnit.METERS : metric);
        }

        private static class GeoResultsConverter
        implements Converter<List<GeoRadiusResponse>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> {
            private final Metric metric;

            public GeoResultsConverter(Metric metric) {
                this.metric = metric;
            }

            @Override
            public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> convert(List<GeoRadiusResponse> source) {
                ArrayList<GeoResult<RedisGeoCommands.GeoLocation<byte[]>>> results = new ArrayList<GeoResult<RedisGeoCommands.GeoLocation<byte[]>>>(source.size());
                Converter<GeoRadiusResponse, GeoResult<RedisGeoCommands.GeoLocation<byte[]>>> converter = GeoResultConverterFactory.INSTANCE.forMetric(this.metric);
                for (GeoRadiusResponse result : source) {
                    results.add(converter.convert(result));
                }
                return new GeoResults<RedisGeoCommands.GeoLocation<byte[]>>(results, this.metric);
            }
        }
    }

    static enum GeoResultConverterFactory {
        INSTANCE;


        Converter<GeoRadiusResponse, GeoResult<RedisGeoCommands.GeoLocation<byte[]>>> forMetric(Metric metric) {
            return new GeoResultConverter(metric);
        }

        private static class GeoResultConverter
        implements Converter<GeoRadiusResponse, GeoResult<RedisGeoCommands.GeoLocation<byte[]>>> {
            private final Metric metric;

            public GeoResultConverter(Metric metric) {
                this.metric = metric;
            }

            @Override
            public GeoResult<RedisGeoCommands.GeoLocation<byte[]>> convert(GeoRadiusResponse source) {
                Point point = JedisConverters.toPoint(source.getCoordinate());
                return new GeoResult<RedisGeoCommands.GeoLocation<byte[]>>(new RedisGeoCommands.GeoLocation<byte[]>(source.getMember(), point), new Distance(source.getDistance(), this.metric));
            }
        }
    }
}

