/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.BitFieldArgs;
import io.lettuce.core.GetExArgs;
import io.lettuce.core.SetArgs;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveStringCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveStringCommands
implements ReactiveStringCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveStringCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, "Connection must not be null");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<List<ByteBuffer>, ByteBuffer>> mGet(Publisher<List<ByteBuffer>> keyCollections) {
        return this.connection.execute(cmd -> Flux.from(keyCollections).concatMap(keys -> {
            Assert.notNull(keys, "Keys must not be null");
            return cmd.mget(keys.toArray(new ByteBuffer[0])).collectList().map(value -> value.stream().map(keyValue -> keyValue.getValueOrElse(null)).collect(Collectors.toList())).map(values -> new ReactiveRedisConnection.MultiValueResponse((List)keys, values));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> set(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getValue(), "Value must not be null");
            SetArgs args = null;
            if (command.getExpiration().isPresent() || command.getOption().isPresent()) {
                args = LettuceConverters.toSetArgs(command.getExpiration().isPresent() ? command.getExpiration().get() : null, command.getOption().isPresent() ? command.getOption().get() : null);
            }
            Mono<String> mono = args != null ? cmd.set(command.getKey(), command.getValue(), args) : cmd.set(command.getKey(), command.getValue());
            return mono.map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (Boolean)value)).switchIfEmpty(Mono.just(new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, Boolean.FALSE)));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveStringCommands.SetCommand>> getSet(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getValue(), "Value must not be null");
            if (command.getExpiration().isPresent() || command.getOption().isPresent()) {
                throw new IllegalArgumentException("Command must not define expiration nor option for GETSET.");
            }
            return cmd.getset(command.getKey(), command.getValue()).map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (ByteBuffer)value)).defaultIfEmpty(new ReactiveRedisConnection.AbsentByteBufferResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>> get(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            return cmd.get(command.getKey()).map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, (ByteBuffer)value)).defaultIfEmpty(new ReactiveRedisConnection.AbsentByteBufferResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>> getDel(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            return cmd.getdel(command.getKey()).map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command, (ByteBuffer)value)).defaultIfEmpty(new ReactiveRedisConnection.AbsentByteBufferResponse<ReactiveRedisConnection.KeyCommand>((ReactiveRedisConnection.KeyCommand)command));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveStringCommands.GetExCommand>> getEx(Publisher<ReactiveStringCommands.GetExCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            GetExArgs args = LettuceConverters.toGetExArgs(command.getExpiration());
            return cmd.getex(command.getKey(), args).map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveStringCommands.GetExCommand>((ReactiveStringCommands.GetExCommand)command, (ByteBuffer)value)).defaultIfEmpty(new ReactiveRedisConnection.AbsentByteBufferResponse<ReactiveStringCommands.GetExCommand>((ReactiveStringCommands.GetExCommand)command));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> setNX(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getValue(), "Value must not be null");
            return cmd.setnx(command.getKey(), command.getValue()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> setEX(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getValue(), "Value must not be null");
            Assert.isTrue(command.getExpiration().isPresent(), "Expiration time must not be null");
            return cmd.setex(command.getKey(), command.getExpiration().get().getExpirationTimeInSeconds(), command.getValue()).map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>> pSetEX(Publisher<ReactiveStringCommands.SetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getValue(), "Value must not be null");
            Assert.isTrue(command.getExpiration().isPresent(), "Expiration time must not be null");
            return cmd.psetex(command.getKey(), command.getExpiration().get().getExpirationTimeInMilliseconds(), command.getValue()).map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetCommand>((ReactiveStringCommands.SetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>> mSet(Publisher<ReactiveStringCommands.MSetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notEmpty(command.getKeyValuePairs(), "Pairs must not be null or empty");
            return cmd.mset(command.getKeyValuePairs()).map(Converters::stringToBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>((ReactiveStringCommands.MSetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>> mSetNX(Publisher<ReactiveStringCommands.MSetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notEmpty(command.getKeyValuePairs(), "Pairs must not be null or empty");
            return cmd.msetnx(command.getKeyValuePairs()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.MSetCommand>((ReactiveStringCommands.MSetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.AppendCommand, Long>> append(Publisher<ReactiveStringCommands.AppendCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getValue(), "Value must not be null");
            return cmd.append(command.getKey(), command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.AppendCommand, Long>((ReactiveStringCommands.AppendCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.RangeCommand>> getRange(Publisher<ReactiveRedisConnection.RangeCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull(command.getRange(), "Range must not be null");
            Range<Long> range = command.getRange();
            Mono result = cmd.getrange(command.getKey(), LettuceConverters.getLowerBoundIndex(range), LettuceConverters.getUpperBoundIndex(range));
            return result.map(value -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveRedisConnection.RangeCommand>((ReactiveRedisConnection.RangeCommand)command, (ByteBuffer)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.SetRangeCommand, Long>> setRange(Publisher<ReactiveStringCommands.SetRangeCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getValue(), "Value must not be null");
            Assert.notNull((Object)command.getOffset(), "Offset must not be null");
            return cmd.setrange(command.getKey(), command.getOffset(), command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.SetRangeCommand, Long>((ReactiveStringCommands.SetRangeCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.GetBitCommand>> getBit(Publisher<ReactiveStringCommands.GetBitCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getOffset(), "Offset must not be null");
            return cmd.getbit(command.getKey(), command.getOffset()).map(Converters::toBoolean).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.GetBitCommand>((ReactiveStringCommands.GetBitCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetBitCommand>> setBit(Publisher<ReactiveStringCommands.SetBitCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Assert.notNull((Object)command.getValue(), "Value must not be null");
            Assert.notNull((Object)command.getOffset(), "Offset must not be null");
            return cmd.setbit(command.getKey(), command.getOffset(), command.getValue() ? 1 : 0).map(Converters::toBoolean).map(respValue -> new ReactiveRedisConnection.BooleanResponse<ReactiveStringCommands.SetBitCommand>((ReactiveStringCommands.SetBitCommand)command, (Boolean)respValue));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitCountCommand, Long>> bitCount(Publisher<ReactiveStringCommands.BitCountCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            Range<Long> range = command.getRange();
            return (!Range.unbounded().equals(range) ? cmd.bitcount(command.getKey(), LettuceConverters.getLowerBoundIndex(range), LettuceConverters.getUpperBoundIndex(range)) : cmd.bitcount(command.getKey())).map(responseValue -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitCountCommand, Long>((ReactiveStringCommands.BitCountCommand)command, (Long)responseValue));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveStringCommands.BitFieldCommand, Long>> bitField(Publisher<ReactiveStringCommands.BitFieldCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null");
            BitFieldArgs args = LettuceConverters.toBitFieldArgs(command.getSubCommands());
            return cmd.bitfield(command.getKey(), args).collectList().map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveStringCommands.BitFieldCommand)command, value.stream().map(v -> v.getValueOrElse(null)).collect(Collectors.toList())));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitOpCommand, Long>> bitOp(Publisher<ReactiveStringCommands.BitOpCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> {
            Assert.notNull((Object)command.getDestinationKey(), "DestinationKey must not be null");
            Assert.notEmpty(command.getKeys(), "Keys must not be null or empty");
            Mono<Long> result = null;
            ByteBuffer destinationKey = command.getDestinationKey();
            ByteBuffer[] sourceKeys = command.getKeys().toArray(new ByteBuffer[0]);
            switch (command.getBitOp()) {
                case AND: {
                    result = cmd.bitopAnd(destinationKey, sourceKeys);
                    break;
                }
                case OR: {
                    result = cmd.bitopOr(destinationKey, sourceKeys);
                    break;
                }
                case XOR: {
                    result = cmd.bitopXor(destinationKey, sourceKeys);
                    break;
                }
                case NOT: {
                    Assert.isTrue(sourceKeys.length == 1, "BITOP NOT does not allow more than 1 source key.");
                    result = cmd.bitopNot(destinationKey, sourceKeys[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unknown BITOP '%s'.", new Object[]{command.getBitOp()}));
                }
            }
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitOpCommand, Long>((ReactiveStringCommands.BitOpCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitPosCommand, Long>> bitPos(Publisher<ReactiveStringCommands.BitPosCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).flatMap(command -> {
            Mono<Long> result;
            Range<Long> range = command.getRange();
            if (range.getLowerBound().isBounded()) {
                result = cmd.bitpos(command.getKey(), command.getBit(), LettuceReactiveStringCommands.getLowerValue(range));
                if (range.getUpperBound().isBounded()) {
                    result = cmd.bitpos(command.getKey(), command.getBit(), LettuceReactiveStringCommands.getLowerValue(range), LettuceReactiveStringCommands.getUpperValue(range));
                }
            } else {
                result = cmd.bitpos(command.getKey(), command.getBit());
            }
            return result.map(respValue -> new ReactiveRedisConnection.NumericResponse<ReactiveStringCommands.BitPosCommand, Long>((ReactiveStringCommands.BitPosCommand)command, (Long)respValue));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> strLen(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from(commands).concatMap(command -> cmd.strlen(command.getKey()).map(respValue -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)respValue))));
    }

    protected LettuceReactiveRedisConnection getConnection() {
        return this.connection;
    }

    private static <T extends Comparable<T>> T getUpperValue(Range<T> range) {
        return (T)((Comparable)range.getUpperBound().getValue().orElseThrow(() -> new IllegalArgumentException("Range does not contain upper bound value")));
    }

    private static <T extends Comparable<T>> T getLowerValue(Range<T> range) {
        return (T)((Comparable)range.getLowerBound().getValue().orElseThrow(() -> new IllegalArgumentException("Range does not contain lower bound value")));
    }
}

