/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveHashCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.core.ReactiveHashOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultReactiveHashOperations<H, HK, HV>
implements ReactiveHashOperations<H, HK, HV> {
    private final ReactiveRedisTemplate<?, ?> template;
    private final RedisSerializationContext<H, ?> serializationContext;

    DefaultReactiveHashOperations(ReactiveRedisTemplate<?, ?> template, RedisSerializationContext<H, ?> serializationContext) {
        this.template = template;
        this.serializationContext = serializationContext;
    }

    @Override
    public Mono<Long> remove(H key, Object ... hashKeys) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull((Object)hashKeys, "Hash keys must not be null");
        Assert.notEmpty(hashKeys, "Hash keys must not be empty");
        Assert.noNullElements(hashKeys, "Hash keys must not contain null elements");
        return this.createMono(connection -> Flux.fromArray(hashKeys).map(o -> o).map(this::rawHashKey).collectList().flatMap(hks -> connection.hDel(this.rawKey(key), (Collection<ByteBuffer>)hks)));
    }

    @Override
    public Mono<Boolean> hasKey(H key, Object hashKey) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull(hashKey, "Hash key must not be null");
        return this.createMono(connection -> connection.hExists(this.rawKey(key), this.rawHashKey(hashKey)));
    }

    @Override
    public Mono<HV> get(H key, Object hashKey) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull(hashKey, "Hash key must not be null");
        return this.createMono(connection -> connection.hGet(this.rawKey(key), this.rawHashKey(hashKey)).map(this::readHashValue));
    }

    @Override
    public Mono<List<HV>> multiGet(H key, Collection<HK> hashKeys) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull(hashKeys, "Hash keys must not be null");
        Assert.notEmpty(hashKeys, "Hash keys must not be empty");
        return this.createMono(connection -> Flux.fromIterable(hashKeys).map(this::rawHashKey).collectList().flatMap(hks -> connection.hMGet(this.rawKey(key), (Collection<ByteBuffer>)hks)).map(this::deserializeHashValues));
    }

    @Override
    public Mono<Long> increment(H key, HK hashKey, long delta) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull(hashKey, "Hash key must not be null");
        return this.template.doCreateMono(connection -> connection.numberCommands().hIncrBy(this.rawKey(key), this.rawHashKey(hashKey), delta));
    }

    @Override
    public Mono<Double> increment(H key, HK hashKey, double delta) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull(hashKey, "Hash key must not be null");
        return this.template.doCreateMono(connection -> connection.numberCommands().hIncrBy(this.rawKey(key), this.rawHashKey(hashKey), delta));
    }

    @Override
    public Mono<HK> randomKey(H key) {
        Assert.notNull(key, "Key must not be null");
        return this.template.doCreateMono(connection -> connection.hashCommands().hRandField(this.rawKey(key))).map(this::readHashKey);
    }

    @Override
    public Mono<Map.Entry<HK, HV>> randomEntry(H key) {
        Assert.notNull(key, "Key must not be null");
        return this.template.doCreateMono(connection -> connection.hashCommands().hRandFieldWithValues(this.rawKey(key))).map(this::deserializeHashEntry);
    }

    @Override
    public Flux<HK> randomKeys(H key, long count) {
        Assert.notNull(key, "Key must not be null");
        return this.template.doCreateFlux(connection -> connection.hashCommands().hRandField(this.rawKey(key), count)).map(this::readHashKey);
    }

    @Override
    public Flux<Map.Entry<HK, HV>> randomEntries(H key, long count) {
        Assert.notNull(key, "Key must not be null");
        return this.template.doCreateFlux(connection -> connection.hashCommands().hRandFieldWithValues(this.rawKey(key), count)).map(this::deserializeHashEntry);
    }

    @Override
    public Flux<HK> keys(H key) {
        Assert.notNull(key, "Key must not be null");
        return this.createFlux(connection -> connection.hKeys(this.rawKey(key)).map(this::readHashKey));
    }

    @Override
    public Mono<Long> size(H key) {
        Assert.notNull(key, "Key must not be null");
        return this.createMono(connection -> connection.hLen(this.rawKey(key)));
    }

    @Override
    public Mono<Boolean> putAll(H key, Map<? extends HK, ? extends HV> map) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull(map, "Map must not be null");
        return this.createMono(connection -> Flux.fromIterable(() -> map.entrySet().iterator()).collectMap(entry -> this.rawHashKey(entry.getKey()), entry -> this.rawHashValue(entry.getValue())).flatMap(serialized -> connection.hMSet(this.rawKey(key), (Map<ByteBuffer, ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Boolean> put(H key, HK hashKey, HV value) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull(hashKey, "Hash key must not be null");
        Assert.notNull(value, "Hash value must not be null");
        return this.createMono(connection -> connection.hSet(this.rawKey(key), this.rawHashKey(hashKey), this.rawHashValue(value)));
    }

    @Override
    public Mono<Boolean> putIfAbsent(H key, HK hashKey, HV value) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull(hashKey, "Hash key must not be null");
        Assert.notNull(value, "Hash value must not be null");
        return this.createMono(connection -> connection.hSetNX(this.rawKey(key), this.rawHashKey(hashKey), this.rawHashValue(value)));
    }

    @Override
    public Flux<HV> values(H key) {
        Assert.notNull(key, "Key must not be null");
        return this.createFlux(connection -> connection.hVals(this.rawKey(key)).map(this::readHashValue));
    }

    @Override
    public Flux<Map.Entry<HK, HV>> entries(H key) {
        Assert.notNull(key, "Key must not be null");
        return this.createFlux(connection -> connection.hGetAll(this.rawKey(key)).map(this::deserializeHashEntry));
    }

    @Override
    public Flux<Map.Entry<HK, HV>> scan(H key, ScanOptions options2) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull(key, "ScanOptions must not be null");
        return this.createFlux(connection -> connection.hScan(this.rawKey(key), options2).map(this::deserializeHashEntry));
    }

    @Override
    public Mono<Boolean> delete(H key) {
        Assert.notNull(key, "Key must not be null");
        return this.template.doCreateMono(connection -> connection.keyCommands().del(this.rawKey(key))).map(l -> l != 0L);
    }

    private <T> Mono<T> createMono(Function<ReactiveHashCommands, Publisher<T>> function) {
        Assert.notNull(function, "Function must not be null");
        return this.template.doCreateMono(connection -> (Publisher)function.apply(connection.hashCommands()));
    }

    private <T> Flux<T> createFlux(Function<ReactiveHashCommands, Publisher<T>> function) {
        Assert.notNull(function, "Function must not be null");
        return this.template.doCreateFlux(connection -> (Publisher)function.apply(connection.hashCommands()));
    }

    private ByteBuffer rawKey(H key) {
        return this.serializationContext.getKeySerializationPair().write(key);
    }

    private ByteBuffer rawHashKey(HK key) {
        return this.serializationContext.getHashKeySerializationPair().write(key);
    }

    private ByteBuffer rawHashValue(HV key) {
        return this.serializationContext.getHashValueSerializationPair().write(key);
    }

    private HK readHashKey(ByteBuffer value) {
        return this.serializationContext.getHashKeySerializationPair().read(value);
    }

    private HV readHashValue(ByteBuffer value) {
        return (HV)(value == null ? value : this.serializationContext.getHashValueSerializationPair().read(value));
    }

    private Map.Entry<HK, HV> deserializeHashEntry(Map.Entry<ByteBuffer, ByteBuffer> source) {
        return Converters.entryOf(this.readHashKey(source.getKey()), this.readHashValue(source.getValue()));
    }

    private List<HV> deserializeHashValues(List<ByteBuffer> source) {
        ArrayList<HV> values = new ArrayList<HV>(source.size());
        for (ByteBuffer byteBuffer : source) {
            values.add(this.readHashValue(byteBuffer));
        }
        return values;
    }
}

