/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Arrays;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.stream.ByteBufferRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.HashMapperProvider;
import org.springframework.data.redis.core.StreamObjectMapper;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveStreamOperations<K, HK, HV>
extends HashMapperProvider<HK, HV> {
    default public Mono<Long> acknowledge(K key, String group, String ... recordIds) {
        return this.acknowledge(key, group, (RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
    }

    public Mono<Long> acknowledge(K var1, String var2, RecordId ... var3);

    default public Mono<Long> acknowledge(String group, Record<K, ?> record) {
        return this.acknowledge(record.getRequiredStream(), group, record.getId());
    }

    default public Flux<RecordId> add(K key, Publisher<? extends Map<? extends HK, ? extends HV>> bodyPublisher) {
        return Flux.from(bodyPublisher).flatMap(it -> this.add(key, (Map<? extends HK, ? extends HV>)it));
    }

    default public Mono<RecordId> add(K key, Map<? extends HK, ? extends HV> content) {
        return this.add(StreamRecords.newRecord().in(key).ofMap(content));
    }

    default public Mono<RecordId> add(MapRecord<K, ? extends HK, ? extends HV> record) {
        return this.add((Record<K, ?>)record);
    }

    public Mono<RecordId> add(Record<K, ?> var1);

    default public Mono<Long> delete(K key, String ... recordIds) {
        return this.delete(key, (RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
    }

    default public Mono<Long> delete(Record<K, ?> record) {
        return this.delete(record.getStream(), record.getId());
    }

    public Mono<Long> delete(K var1, RecordId ... var2);

    default public Mono<String> createGroup(K key, String group) {
        return this.createGroup(key, ReadOffset.latest(), group);
    }

    public Mono<String> createGroup(K var1, ReadOffset var2, String var3);

    public Mono<String> deleteConsumer(K var1, Consumer var2);

    public Mono<String> destroyGroup(K var1, String var2);

    public Flux<StreamInfo.XInfoConsumer> consumers(K var1, String var2);

    public Flux<StreamInfo.XInfoGroup> groups(K var1);

    public Mono<StreamInfo.XInfoStream> info(K var1);

    @Nullable
    public Mono<PendingMessagesSummary> pending(K var1, String var2);

    default public Mono<PendingMessages> pending(K key, Consumer consumer) {
        return this.pending(key, consumer, Range.unbounded(), -1L);
    }

    public Mono<PendingMessages> pending(K var1, String var2, Range<?> var3, long var4);

    public Mono<PendingMessages> pending(K var1, Consumer var2, Range<?> var3, long var4);

    public Mono<Long> size(K var1);

    default public Flux<MapRecord<K, HK, HV>> range(K key, Range<String> range) {
        return this.range(key, range, Limit.unlimited());
    }

    public Flux<MapRecord<K, HK, HV>> range(K var1, Range<String> var2, Limit var3);

    default public <V> Flux<ObjectRecord<K, V>> range(Class<V> targetType, K key, Range<String> range) {
        return this.range(targetType, key, range, Limit.unlimited());
    }

    default public <V> Flux<ObjectRecord<K, V>> range(Class<V> targetType, K key, Range<String> range, Limit limit) {
        Assert.notNull(targetType, "Target type must not be null");
        return this.range(key, range, limit).map(it -> this.map((MapRecord<K, HK, HV>)it, targetType));
    }

    default public Flux<MapRecord<K, HK, HV>> read(StreamOffset<K> stream) {
        Assert.notNull(stream, "StreamOffset must not be null");
        return this.read(StreamReadOptions.empty(), stream);
    }

    default public <V> Flux<ObjectRecord<K, V>> read(Class<V> targetType, StreamOffset<K> stream) {
        Assert.notNull(stream, "StreamOffset must not be null");
        return this.read(targetType, StreamReadOptions.empty(), stream);
    }

    default public Flux<MapRecord<K, HK, HV>> read(StreamOffset<K> ... streams) {
        return this.read(StreamReadOptions.empty(), streams);
    }

    default public <V> Flux<ObjectRecord<K, V>> read(Class<V> targetType, StreamOffset<K> ... streams) {
        return this.read(targetType, StreamReadOptions.empty(), streams);
    }

    public Flux<MapRecord<K, HK, HV>> read(StreamReadOptions var1, StreamOffset<K> ... var2);

    default public <V> Flux<ObjectRecord<K, V>> read(Class<V> targetType, StreamReadOptions readOptions, StreamOffset<K> ... streams) {
        Assert.notNull(targetType, "Target type must not be null");
        return this.read(readOptions, streams).map(it -> this.map((MapRecord<K, HK, HV>)it, targetType));
    }

    default public Flux<MapRecord<K, HK, HV>> read(Consumer consumer, StreamOffset<K> ... streams) {
        return this.read(consumer, StreamReadOptions.empty(), streams);
    }

    default public <V> Flux<ObjectRecord<K, V>> read(Class<V> targetType, Consumer consumer, StreamOffset<K> ... streams) {
        return this.read(targetType, consumer, StreamReadOptions.empty(), streams);
    }

    public Flux<MapRecord<K, HK, HV>> read(Consumer var1, StreamReadOptions var2, StreamOffset<K> ... var3);

    default public <V> Flux<ObjectRecord<K, V>> read(Class<V> targetType, Consumer consumer, StreamReadOptions readOptions, StreamOffset<K> ... streams) {
        Assert.notNull(targetType, "Target type must not be null");
        return this.read(consumer, readOptions, streams).map(it -> this.map((MapRecord<K, HK, HV>)it, targetType));
    }

    default public Flux<MapRecord<K, HK, HV>> reverseRange(K key, Range<String> range) {
        return this.reverseRange(key, range, Limit.unlimited());
    }

    public Flux<MapRecord<K, HK, HV>> reverseRange(K var1, Range<String> var2, Limit var3);

    default public <V> Flux<ObjectRecord<K, V>> reverseRange(Class<V> targetType, K key, Range<String> range) {
        return this.reverseRange(targetType, key, range, Limit.unlimited());
    }

    default public <V> Flux<ObjectRecord<K, V>> reverseRange(Class<V> targetType, K key, Range<String> range, Limit limit) {
        Assert.notNull(targetType, "Target type must not be null");
        return this.reverseRange(key, range, limit).map(it -> this.map((MapRecord<K, HK, HV>)it, targetType));
    }

    public Mono<Long> trim(K var1, long var2);

    public Mono<Long> trim(K var1, long var2, boolean var4);

    @Override
    public <V> HashMapper<V, HK, HV> getHashMapper(Class<V> var1);

    default public <V> ObjectRecord<K, V> map(MapRecord<K, HK, HV> record, Class<V> targetType) {
        Assert.notNull(record, "Records must not be null");
        Assert.notNull(targetType, "Target type must not be null");
        return StreamObjectMapper.toObjectRecord(record, this, targetType);
    }

    public MapRecord<K, HK, HV> deserializeRecord(ByteBufferRecord var1);
}

