/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public abstract class ScanCursor<T>
implements Cursor<T> {
    private CursorState state;
    private long cursorId;
    private Iterator<T> delegate;
    private final ScanOptions scanOptions;
    private long position;

    public ScanCursor() {
        this(ScanOptions.NONE);
    }

    public ScanCursor(ScanOptions options2) {
        this(0L, options2);
    }

    public ScanCursor(long cursorId) {
        this(cursorId, ScanOptions.NONE);
    }

    public ScanCursor(long cursorId, @Nullable ScanOptions options2) {
        this.scanOptions = options2 != null ? options2 : ScanOptions.NONE;
        this.cursorId = cursorId;
        this.state = CursorState.READY;
        this.delegate = Collections.emptyIterator();
    }

    private void scan(long cursorId) {
        try {
            this.processScanResult(this.doScan(cursorId, this.scanOptions));
        }
        catch (RuntimeException e) {
            try {
                this.close();
            }
            catch (RuntimeException nested) {
                e.addSuppressed(nested);
            }
            throw e;
        }
    }

    protected abstract ScanIteration<T> doScan(long var1, ScanOptions var3);

    public final ScanCursor<T> open() {
        if (!this.isReady()) {
            throw new InvalidDataAccessApiUsageException("Cursor already " + this.state + "; Cannot (re)open it");
        }
        this.state = CursorState.OPEN;
        this.doOpen(this.cursorId);
        return this;
    }

    protected void doOpen(long cursorId) {
        this.scan(cursorId);
    }

    private void processScanResult(ScanIteration<T> result) {
        this.cursorId = result.getCursorId();
        if (this.isFinished(this.cursorId)) {
            this.state = CursorState.FINISHED;
        }
        if (!CollectionUtils.isEmpty(result.getItems())) {
            this.delegate = result.iterator();
        } else {
            this.resetDelegate();
        }
    }

    protected boolean isFinished(long cursorId) {
        return cursorId == 0L;
    }

    private void resetDelegate() {
        this.delegate = Collections.emptyIterator();
    }

    @Override
    public long getCursorId() {
        return this.cursorId;
    }

    @Override
    public boolean hasNext() {
        this.assertCursorIsOpen();
        while (!this.delegate.hasNext() && !CursorState.FINISHED.equals((Object)this.state)) {
            this.scan(this.cursorId);
        }
        if (this.delegate.hasNext()) {
            return true;
        }
        return this.cursorId > 0L;
    }

    private void assertCursorIsOpen() {
        if (this.isReady() || this.isClosed()) {
            throw new InvalidDataAccessApiUsageException("Cannot access closed cursor; Did you forget to call open()");
        }
    }

    @Override
    public T next() {
        this.assertCursorIsOpen();
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available for cursor " + this.cursorId);
        }
        T next = this.moveNext(this.delegate);
        ++this.position;
        return next;
    }

    protected T moveNext(Iterator<T> source) {
        return source.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    @Override
    public final void close() {
        try {
            this.doClose();
        }
        finally {
            this.state = CursorState.CLOSED;
        }
    }

    protected void doClose() {
    }

    @Override
    public boolean isClosed() {
        return this.state == CursorState.CLOSED;
    }

    protected final boolean isReady() {
        return this.state == CursorState.READY;
    }

    protected final boolean isOpen() {
        return this.state == CursorState.OPEN;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    static enum CursorState {
        READY,
        OPEN,
        FINISHED,
        CLOSED;

    }
}

