/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.support;

import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.query.KeyValuePartTreeQuery;
import org.springframework.data.keyvalue.repository.support.KeyValueRepositoryFactory;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.repository.core.MappingRedisEntityInformation;
import org.springframework.data.redis.repository.query.RedisQueryCreator;
import org.springframework.data.redis.repository.support.QueryByExampleRedisExecutor;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.query.QueryByExampleExecutor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;

public class RedisRepositoryFactory
extends KeyValueRepositoryFactory {
    private final KeyValueOperations operations;

    public RedisRepositoryFactory(KeyValueOperations keyValueOperations) {
        this(keyValueOperations, RedisQueryCreator.class);
    }

    public RedisRepositoryFactory(KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        this(keyValueOperations, queryCreator, KeyValuePartTreeQuery.class);
    }

    public RedisRepositoryFactory(KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, Class<? extends RepositoryQuery> repositoryQueryType) {
        super(keyValueOperations, queryCreator, repositoryQueryType);
        this.operations = keyValueOperations;
    }

    @Override
    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        RepositoryComposition.RepositoryFragments fragments = RepositoryComposition.RepositoryFragments.empty();
        if (QueryByExampleExecutor.class.isAssignableFrom(metadata.getRepositoryInterface())) {
            RedisMappingContext mappingContext = (RedisMappingContext)this.operations.getMappingContext();
            RedisPersistentEntity persistentEntity = (RedisPersistentEntity)mappingContext.getRequiredPersistentEntity(metadata.getDomainType());
            MappingRedisEntityInformation entityInformation = new MappingRedisEntityInformation(persistentEntity);
            fragments = fragments.append(RepositoryFragment.implemented(QueryByExampleExecutor.class, (QueryByExampleExecutor)this.instantiateClass(QueryByExampleRedisExecutor.class, entityInformation, this.operations)));
        }
        return fragments;
    }

    @Override
    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        RedisPersistentEntity entity = (RedisPersistentEntity)this.operations.getMappingContext().getRequiredPersistentEntity(domainClass);
        return new MappingRedisEntityInformation(entity);
    }
}

