/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.data.repository.config.FragmentMetadata;
import org.springframework.data.repository.config.ImplementationDetectionConfiguration;
import org.springframework.data.repository.config.ImplementationLookupConfiguration;
import org.springframework.data.repository.config.NamedQueriesBeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationAdapter;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryFragmentConfiguration;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.core.support.RepositoryFragmentsFactoryBean;
import org.springframework.data.util.Optionals;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class RepositoryBeanDefinitionBuilder {
    private static final Log logger = LogFactory.getLog(RepositoryBeanDefinitionBuilder.class);
    private final BeanDefinitionRegistry registry;
    private final RepositoryConfigurationExtension extension;
    private final ResourceLoader resourceLoader;
    private final MetadataReaderFactory metadataReaderFactory;
    private final FragmentMetadata fragmentMetadata;
    private final CustomRepositoryImplementationDetector implementationDetector;

    public RepositoryBeanDefinitionBuilder(BeanDefinitionRegistry registry, RepositoryConfigurationExtension extension, RepositoryConfigurationSource configurationSource, ResourceLoader resourceLoader, Environment environment2) {
        Assert.notNull((Object)extension, "RepositoryConfigurationExtension must not be null");
        Assert.notNull((Object)resourceLoader, "ResourceLoader must not be null");
        Assert.notNull((Object)environment2, "Environment must not be null");
        this.registry = registry;
        this.extension = extension;
        this.resourceLoader = resourceLoader;
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
        this.fragmentMetadata = new FragmentMetadata(this.metadataReaderFactory);
        this.implementationDetector = new CustomRepositoryImplementationDetector(environment2, resourceLoader, configurationSource.toImplementationDetectionConfiguration(this.metadataReaderFactory));
    }

    public BeanDefinitionBuilder build(RepositoryConfiguration<?> configuration) {
        Assert.notNull((Object)this.registry, "BeanDefinitionRegistry must not be null");
        Assert.notNull((Object)this.resourceLoader, "ResourceLoader must not be null");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(configuration.getRepositoryFactoryBeanClassName());
        builder.getRawBeanDefinition().setSource(configuration.getSource());
        builder.addConstructorArgValue(configuration.getRepositoryInterface());
        builder.addPropertyValue("queryLookupStrategyKey", configuration.getQueryLookupStrategyKey());
        builder.addPropertyValue("lazyInit", configuration.isLazyInit());
        builder.setLazyInit(configuration.isLazyInit());
        builder.setPrimary(configuration.isPrimary());
        configuration.getRepositoryBaseClassName().ifPresent(it -> builder.addPropertyValue("repositoryBaseClass", it));
        NamedQueriesBeanDefinitionBuilder definitionBuilder = new NamedQueriesBeanDefinitionBuilder(this.extension.getDefaultNamedQueryLocation());
        configuration.getNamedQueriesLocation().ifPresent(definitionBuilder::setLocations);
        String namedQueriesBeanName = BeanDefinitionReaderUtils.uniqueBeanName(this.extension.getModuleIdentifier() + ".named-queries", this.registry);
        BeanDefinition namedQueries = definitionBuilder.build(configuration.getSource());
        this.registry.registerBeanDefinition(namedQueriesBeanName, namedQueries);
        builder.addPropertyValue("namedQueries", new RuntimeBeanReference(namedQueriesBeanName));
        this.registerCustomImplementation(configuration).ifPresent(it -> {
            builder.addPropertyReference("customImplementation", (String)it);
            builder.addDependsOn((String)it);
        });
        String fragmentsBeanName = this.registerRepositoryFragments(configuration);
        builder.addPropertyValue("repositoryFragments", new RuntimeBeanReference(fragmentsBeanName));
        return builder;
    }

    RepositoryConfigurationAdapter<?> buildMetadata(RepositoryConfiguration<?> configuration) {
        ImplementationLookupConfiguration lookup;
        Optional<AbstractBeanDefinition> beanDefinition;
        ImplementationDetectionConfiguration config = configuration.toImplementationDetectionConfiguration(this.metadataReaderFactory);
        List<RepositoryFragmentConfiguration> repositoryFragmentConfigurationStream = this.fragmentMetadata.getFragmentInterfaces(configuration.getRepositoryInterface()).map(it -> this.detectRepositoryFragmentConfiguration((String)it, config, configuration)).flatMap(xva$0 -> Optionals.toStream(xva$0)).toList();
        if (repositoryFragmentConfigurationStream.isEmpty() && (beanDefinition = this.implementationDetector.detectCustomImplementation(lookup = configuration.toLookupConfiguration(this.metadataReaderFactory))).isPresent()) {
            repositoryFragmentConfigurationStream = new ArrayList<RepositoryFragmentConfiguration>(1);
            List<String> interfaceNames = this.fragmentMetadata.getFragmentInterfaces(configuration.getRepositoryInterface()).toList();
            String implClassName = beanDefinition.get().getBeanClassName();
            try {
                for (String iName : this.metadataReaderFactory.getMetadataReader(implClassName).getClassMetadata().getInterfaceNames()) {
                    if (!interfaceNames.contains(iName)) continue;
                    repositoryFragmentConfigurationStream.add(new RepositoryFragmentConfiguration(iName, implClassName));
                    break;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return new RepositoryConfigurationAdapter(configuration, repositoryFragmentConfigurationStream);
    }

    private Optional<String> registerCustomImplementation(RepositoryConfiguration<?> configuration) {
        ImplementationLookupConfiguration lookup = configuration.toLookupConfiguration(this.metadataReaderFactory);
        String configurationBeanName = lookup.getImplementationBeanName();
        if (this.registry.containsBeanDefinition(configurationBeanName)) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Custom repository implementation already registered: %s", configurationBeanName));
            }
            return Optional.of(configurationBeanName);
        }
        return this.implementationDetector.detectCustomImplementation(lookup).map(it -> this.potentiallyRegisterRepositoryImplementation(configuration, (AbstractBeanDefinition)it));
    }

    private String registerRepositoryFragments(RepositoryConfiguration<?> configuration) {
        BeanDefinitionBuilder fragmentsBuilder = BeanDefinitionBuilder.rootBeanDefinition(RepositoryFragmentsFactoryBean.class).setRole(2);
        List fragmentBeanNames = this.registerRepositoryFragmentsImplementation(configuration).map(RepositoryFragmentConfiguration::getFragmentBeanName).collect(Collectors.toList());
        fragmentsBuilder.addConstructorArgValue(fragmentBeanNames);
        String fragmentsBeanName = BeanDefinitionReaderUtils.uniqueBeanName(String.format("%s.%s.fragments", this.extension.getModuleName().toLowerCase(Locale.ROOT), ClassUtils.getShortName(configuration.getRepositoryInterface())), this.registry);
        this.registry.registerBeanDefinition(fragmentsBeanName, fragmentsBuilder.getBeanDefinition());
        return fragmentsBeanName;
    }

    private Stream<RepositoryFragmentConfiguration> registerRepositoryFragmentsImplementation(RepositoryConfiguration<?> configuration) {
        ImplementationDetectionConfiguration config = configuration.toImplementationDetectionConfiguration(this.metadataReaderFactory);
        return this.fragmentMetadata.getFragmentInterfaces(configuration.getRepositoryInterface()).map(it -> this.detectRepositoryFragmentConfiguration((String)it, config, configuration)).flatMap(xva$0 -> Optionals.toStream(xva$0)).peek(it -> this.potentiallyRegisterFragmentImplementation(configuration, (RepositoryFragmentConfiguration)it)).peek(it -> this.potentiallyRegisterRepositoryFragment(configuration, (RepositoryFragmentConfiguration)it));
    }

    private Optional<RepositoryFragmentConfiguration> detectRepositoryFragmentConfiguration(String fragmentInterface, ImplementationDetectionConfiguration config, RepositoryConfiguration<?> configuration) {
        ImplementationLookupConfiguration lookup = config.forFragment(fragmentInterface);
        Optional<AbstractBeanDefinition> beanDefinition = this.implementationDetector.detectCustomImplementation(lookup);
        return beanDefinition.map(bd -> new RepositoryFragmentConfiguration(fragmentInterface, (AbstractBeanDefinition)bd, configuration.getConfigurationSource().generateBeanName((BeanDefinition)bd)));
    }

    private String potentiallyRegisterRepositoryImplementation(RepositoryConfiguration<?> configuration, AbstractBeanDefinition beanDefinition) {
        String targetBeanName = configuration.getConfigurationSource().generateBeanName(beanDefinition);
        beanDefinition.setSource(configuration.getSource());
        if (this.registry.containsBeanDefinition(targetBeanName)) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Custom repository implementation already registered: %s %s", targetBeanName, beanDefinition.getBeanClassName()));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Registering custom repository implementation: %s %s", targetBeanName, beanDefinition.getBeanClassName()));
            }
            this.registry.registerBeanDefinition(targetBeanName, beanDefinition);
        }
        return targetBeanName;
    }

    private void potentiallyRegisterFragmentImplementation(RepositoryConfiguration<?> repositoryConfiguration, RepositoryFragmentConfiguration fragmentConfiguration) {
        String beanName = fragmentConfiguration.getImplementationBeanName();
        if (this.registry.containsBeanDefinition(beanName)) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Repository fragment implementation already registered: %s", beanName));
            }
            return;
        }
        fragmentConfiguration.getBeanDefinition().ifPresent(bd -> {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Registering repository fragment implementation: %s %s", beanName, fragmentConfiguration.getClassName()));
            }
            bd.setSource(repositoryConfiguration.getSource());
            this.registry.registerBeanDefinition(beanName, (BeanDefinition)bd);
        });
    }

    private void potentiallyRegisterRepositoryFragment(RepositoryConfiguration<?> configuration, RepositoryFragmentConfiguration fragmentConfiguration) {
        String beanName = fragmentConfiguration.getFragmentBeanName();
        if (this.registry.containsBeanDefinition(beanName)) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("RepositoryFragment already registered: %s", beanName));
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Registering RepositoryFragment: %s", beanName));
        }
        BeanDefinitionBuilder fragmentBuilder = BeanDefinitionBuilder.rootBeanDefinition(RepositoryFragment.class, "implemented");
        fragmentBuilder.addConstructorArgValue(fragmentConfiguration.getInterfaceName());
        fragmentBuilder.addConstructorArgReference(fragmentConfiguration.getImplementationBeanName());
        this.registry.registerBeanDefinition(beanName, ParsingUtils.getSourceBeanDefinition(fragmentBuilder, configuration.getSource()));
    }
}

