/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.type.classreading;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.data.type.MethodsMetadata;
import org.springframework.data.type.classreading.MethodsMetadataReader;
import org.springframework.lang.Nullable;

@Deprecated
public class MethodsMetadataReaderFactory
extends SimpleMetadataReaderFactory {
    public MethodsMetadataReaderFactory() {
    }

    public MethodsMetadataReaderFactory(@Nullable ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    public MethodsMetadataReaderFactory(@Nullable ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public MethodsMetadataReader getMetadataReader(String className) throws IOException {
        return new MetadataReaderWrapper(super.getMetadataReader(className));
    }

    @Override
    public MethodsMetadataReader getMetadataReader(Resource resource) throws IOException {
        return new MetadataReaderWrapper(super.getMetadataReader(resource));
    }

    private static class MetadataReaderWrapper
    implements MethodsMetadataReader {
        private final MetadataReader delegate;

        MetadataReaderWrapper(MetadataReader delegate) {
            this.delegate = delegate;
        }

        @Override
        public MethodsMetadata getMethodsMetadata() {
            return new MethodsMetadataWrapper(this.getAnnotationMetadata(), this.getClassMetadata());
        }

        @Override
        public Resource getResource() {
            return this.delegate.getResource();
        }

        @Override
        public ClassMetadata getClassMetadata() {
            return this.delegate.getClassMetadata();
        }

        @Override
        public AnnotationMetadata getAnnotationMetadata() {
            return this.delegate.getAnnotationMetadata();
        }
    }

    private static class MethodsMetadataWrapper
    implements MethodsMetadata,
    ClassMetadata {
        private final AnnotationMetadata annotationMetadata;
        private final ClassMetadata classMetadata;

        MethodsMetadataWrapper(AnnotationMetadata annotationMetadata, ClassMetadata classMetadata) {
            this.annotationMetadata = annotationMetadata;
            this.classMetadata = classMetadata;
        }

        @Override
        public Set<MethodMetadata> getMethods() {
            return this.annotationMetadata.getDeclaredMethods();
        }

        @Override
        public Set<MethodMetadata> getMethods(String name) {
            return this.annotationMetadata.getDeclaredMethods().stream().filter(it -> it.getMethodName().equals(name)).collect(Collectors.toSet());
        }

        @Override
        public String getClassName() {
            return this.classMetadata.getClassName();
        }

        @Override
        public boolean isInterface() {
            return this.classMetadata.isInterface();
        }

        @Override
        public boolean isAnnotation() {
            return this.classMetadata.isAnnotation();
        }

        @Override
        public boolean isAbstract() {
            return this.classMetadata.isAbstract();
        }

        @Override
        public boolean isConcrete() {
            return this.classMetadata.isConcrete();
        }

        @Override
        public boolean isFinal() {
            return this.classMetadata.isFinal();
        }

        @Override
        public boolean isIndependent() {
            return this.classMetadata.isIndependent();
        }

        @Override
        public boolean hasEnclosingClass() {
            return this.classMetadata.hasEnclosingClass();
        }

        @Override
        @Nullable
        public String getEnclosingClassName() {
            return this.classMetadata.getEnclosingClassName();
        }

        @Override
        public boolean hasSuperClass() {
            return this.classMetadata.hasSuperClass();
        }

        @Override
        @Nullable
        public String getSuperClassName() {
            return this.classMetadata.getSuperClassName();
        }

        @Override
        public String[] getInterfaceNames() {
            return this.classMetadata.getInterfaceNames();
        }

        @Override
        public String[] getMemberClassNames() {
            return this.classMetadata.getMemberClassNames();
        }
    }
}

