/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.server;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.session.InMemoryWebSessionStore;
import reactor.core.publisher.Mono;

public class MockWebSession
implements WebSession {
    private final WebSession delegate;

    public MockWebSession() {
        this(null);
    }

    public MockWebSession(@Nullable Clock clock) {
        WebSession session;
        InMemoryWebSessionStore sessionStore = new InMemoryWebSessionStore();
        if (clock != null) {
            sessionStore.setClock(clock);
        }
        Assert.state((session = sessionStore.createWebSession().block()) != null, "WebSession must not be null");
        this.delegate = session;
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.delegate.getAttributes();
    }

    @Override
    public void start() {
        this.delegate.start();
    }

    @Override
    public boolean isStarted() {
        return this.delegate.isStarted();
    }

    @Override
    public Mono<Void> changeSessionId() {
        return this.delegate.changeSessionId();
    }

    @Override
    public Mono<Void> invalidate() {
        return this.delegate.invalidate();
    }

    @Override
    public Mono<Void> save() {
        return this.delegate.save();
    }

    @Override
    public boolean isExpired() {
        return this.delegate.isExpired();
    }

    @Override
    public Instant getCreationTime() {
        return this.delegate.getCreationTime();
    }

    @Override
    public Instant getLastAccessTime() {
        return this.delegate.getLastAccessTime();
    }

    @Override
    public void setMaxIdleTime(Duration maxIdleTime) {
        this.delegate.setMaxIdleTime(maxIdleTime);
    }

    @Override
    public Duration getMaxIdleTime() {
        return this.delegate.getMaxIdleTime();
    }
}

