/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.support;

import java.io.IOException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.springframework.lang.Nullable;
import org.springframework.oxm.Marshaller;
import org.springframework.util.Assert;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class MarshallingSource
extends SAXSource {
    private final Marshaller marshaller;
    private final Object content;

    public MarshallingSource(Marshaller marshaller, Object content) {
        super(new MarshallingXMLReader(marshaller, content), new InputSource());
        Assert.notNull((Object)marshaller, "'marshaller' must not be null");
        Assert.notNull(content, "'content' must not be null");
        this.marshaller = marshaller;
        this.content = content;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public Object getContent() {
        return this.content;
    }

    @Override
    public void setInputSource(InputSource inputSource) {
        throw new UnsupportedOperationException("setInputSource is not supported");
    }

    @Override
    public void setXMLReader(XMLReader reader) {
        throw new UnsupportedOperationException("setXMLReader is not supported");
    }

    private static final class MarshallingXMLReader
    implements XMLReader {
        private final Marshaller marshaller;
        private final Object content;
        @Nullable
        private DTDHandler dtdHandler;
        @Nullable
        private ContentHandler contentHandler;
        @Nullable
        private EntityResolver entityResolver;
        @Nullable
        private ErrorHandler errorHandler;
        @Nullable
        private LexicalHandler lexicalHandler;

        private MarshallingXMLReader(Marshaller marshaller, Object content) {
            Assert.notNull((Object)marshaller, "'marshaller' must not be null");
            Assert.notNull(content, "'content' must not be null");
            this.marshaller = marshaller;
            this.content = content;
        }

        @Override
        public void setContentHandler(@Nullable ContentHandler contentHandler) {
            this.contentHandler = contentHandler;
        }

        @Override
        @Nullable
        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }

        @Override
        public void setDTDHandler(@Nullable DTDHandler dtdHandler) {
            this.dtdHandler = dtdHandler;
        }

        @Override
        @Nullable
        public DTDHandler getDTDHandler() {
            return this.dtdHandler;
        }

        @Override
        public void setEntityResolver(@Nullable EntityResolver entityResolver) {
            this.entityResolver = entityResolver;
        }

        @Override
        @Nullable
        public EntityResolver getEntityResolver() {
            return this.entityResolver;
        }

        @Override
        public void setErrorHandler(@Nullable ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }

        @Override
        @Nullable
        public ErrorHandler getErrorHandler() {
            return this.errorHandler;
        }

        @Nullable
        protected LexicalHandler getLexicalHandler() {
            return this.lexicalHandler;
        }

        @Override
        public boolean getFeature(String name) throws SAXNotRecognizedException {
            throw new SAXNotRecognizedException(name);
        }

        @Override
        public void setFeature(String name, boolean value) throws SAXNotRecognizedException {
            throw new SAXNotRecognizedException(name);
        }

        @Override
        @Nullable
        public Object getProperty(String name) throws SAXNotRecognizedException {
            if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
                return this.lexicalHandler;
            }
            throw new SAXNotRecognizedException(name);
        }

        @Override
        public void setProperty(String name, Object value) throws SAXNotRecognizedException {
            if (!"http://xml.org/sax/properties/lexical-handler".equals(name)) {
                throw new SAXNotRecognizedException(name);
            }
            this.lexicalHandler = (LexicalHandler)value;
        }

        @Override
        public void parse(InputSource input) throws SAXException {
            this.parse();
        }

        @Override
        public void parse(String systemId) throws SAXException {
            this.parse();
        }

        private void parse() throws SAXException {
            SAXResult result = new SAXResult(this.getContentHandler());
            result.setLexicalHandler(this.getLexicalHandler());
            try {
                this.marshaller.marshal(this.content, result);
            }
            catch (IOException ex) {
                SAXParseException saxException = new SAXParseException(ex.getMessage(), null, null, -1, -1, ex);
                ErrorHandler errorHandler = this.getErrorHandler();
                if (errorHandler != null) {
                    errorHandler.fatalError(saxException);
                }
                throw saxException;
            }
        }
    }
}

