/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.oxm.xstream;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterMatcher;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.core.DefaultConverterLookup;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.DomWriter;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.SaxWriter;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.io.xml.StaxReader;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import com.thoughtworks.xstream.security.ForbiddenClassException;
import com.thoughtworks.xstream.security.TypePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamSource;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.UncategorizedMappingException;
import org.springframework.oxm.UnmarshallingFailureException;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.support.AbstractMarshaller;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.util.xml.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XStreamMarshaller
extends AbstractMarshaller
implements BeanClassLoaderAware,
InitializingBean {
    public static final String DEFAULT_ENCODING = "UTF-8";
    @Nullable
    private ReflectionProvider reflectionProvider;
    @Nullable
    private HierarchicalStreamDriver streamDriver;
    @Nullable
    private HierarchicalStreamDriver defaultDriver;
    @Nullable
    private Mapper mapper;
    @Nullable
    private Class<? extends MapperWrapper>[] mapperWrappers;
    private ConverterLookup converterLookup = new DefaultConverterLookup();
    private ConverterRegistry converterRegistry = (ConverterRegistry)this.converterLookup;
    @Nullable
    private ConverterMatcher[] converters;
    @Nullable
    private TypePermission[] typePermissions;
    @Nullable
    private MarshallingStrategy marshallingStrategy;
    @Nullable
    private Integer mode;
    @Nullable
    private Map<String, ?> aliases;
    @Nullable
    private Map<String, ?> aliasesByType;
    @Nullable
    private Map<String, String> fieldAliases;
    @Nullable
    private Class<?>[] useAttributeForTypes;
    @Nullable
    private Map<?, ?> useAttributeFor;
    @Nullable
    private Map<Class<?>, String> implicitCollections;
    @Nullable
    private Map<Class<?>, String> omittedFields;
    @Nullable
    private Class<?>[] annotatedClasses;
    private boolean autodetectAnnotations;
    private String encoding = "UTF-8";
    private NameCoder nameCoder = new XmlFriendlyNameCoder();
    @Nullable
    private Class<?>[] supportedClasses;
    @Nullable
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private final SingletonSupplier<XStream> xstream = SingletonSupplier.of(this::buildXStream);

    public void setReflectionProvider(ReflectionProvider reflectionProvider) {
        this.reflectionProvider = reflectionProvider;
    }

    public void setStreamDriver(HierarchicalStreamDriver streamDriver) {
        this.streamDriver = streamDriver;
        this.defaultDriver = streamDriver;
    }

    private HierarchicalStreamDriver getDefaultDriver() {
        if (this.defaultDriver == null) {
            this.defaultDriver = new DomDriver(this.encoding, this.nameCoder);
        }
        return this.defaultDriver;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public void setMapperWrappers(Class<? extends MapperWrapper> ... mapperWrappers) {
        this.mapperWrappers = mapperWrappers;
    }

    public void setConverterLookup(ConverterLookup converterLookup) {
        this.converterLookup = converterLookup;
        if (converterLookup instanceof ConverterRegistry) {
            ConverterRegistry registry;
            this.converterRegistry = registry = (ConverterRegistry)converterLookup;
        }
    }

    public void setConverterRegistry(ConverterRegistry converterRegistry) {
        this.converterRegistry = converterRegistry;
    }

    public void setConverters(ConverterMatcher ... converters) {
        this.converters = converters;
    }

    public void setTypePermissions(TypePermission ... typePermissions) {
        this.typePermissions = typePermissions;
    }

    public void setMarshallingStrategy(MarshallingStrategy marshallingStrategy) {
        this.marshallingStrategy = marshallingStrategy;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setAliases(Map<String, ?> aliases) {
        this.aliases = aliases;
    }

    public void setAliasesByType(Map<String, ?> aliasesByType) {
        this.aliasesByType = aliasesByType;
    }

    public void setFieldAliases(Map<String, String> fieldAliases) {
        this.fieldAliases = fieldAliases;
    }

    public void setUseAttributeForTypes(Class<?> ... useAttributeForTypes) {
        this.useAttributeForTypes = useAttributeForTypes;
    }

    public void setUseAttributeFor(Map<?, ?> useAttributeFor) {
        this.useAttributeFor = useAttributeFor;
    }

    public void setImplicitCollections(Map<Class<?>, String> implicitCollections) {
        this.implicitCollections = implicitCollections;
    }

    public void setOmittedFields(Map<Class<?>, String> omittedFields) {
        this.omittedFields = omittedFields;
    }

    public void setAnnotatedClasses(Class<?> ... annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
    }

    public void setAutodetectAnnotations(boolean autodetectAnnotations) {
        this.autodetectAnnotations = autodetectAnnotations;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    protected String getDefaultEncoding() {
        return this.encoding;
    }

    public void setNameCoder(NameCoder nameCoder) {
        this.nameCoder = nameCoder;
    }

    public void setSupportedClasses(Class<?> ... supportedClasses) {
        this.supportedClasses = supportedClasses;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public void afterPropertiesSet() {
    }

    protected XStream buildXStream() {
        XStream xstream = this.constructXStream();
        this.configureXStream(xstream);
        this.customizeXStream(xstream);
        return xstream;
    }

    protected XStream constructXStream() {
        return new XStream(this.reflectionProvider, this.getDefaultDriver(), new ClassLoaderReference(this.beanClassLoader), this.mapper, this.converterLookup, this.converterRegistry){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                MapperWrapper mapperToWrap = next;
                if (XStreamMarshaller.this.mapperWrappers != null) {
                    for (Class<? extends MapperWrapper> mapperWrapper : XStreamMarshaller.this.mapperWrappers) {
                        Constructor<? extends MapperWrapper> ctor;
                        try {
                            ctor = mapperWrapper.getConstructor(Mapper.class);
                        }
                        catch (NoSuchMethodException ex) {
                            try {
                                ctor = mapperWrapper.getConstructor(MapperWrapper.class);
                            }
                            catch (NoSuchMethodException ex2) {
                                throw new IllegalStateException("No appropriate MapperWrapper constructor found: " + mapperWrapper);
                            }
                        }
                        try {
                            mapperToWrap = ctor.newInstance(mapperToWrap);
                        }
                        catch (Throwable ex) {
                            throw new IllegalStateException("Failed to construct MapperWrapper: " + mapperWrapper);
                        }
                    }
                }
                return mapperToWrap;
            }
        };
    }

    protected void configureXStream(XStream xstream) {
        Object className;
        if (this.converters != null) {
            for (int i2 = 0; i2 < this.converters.length; ++i2) {
                ConverterMatcher converterMatcher = this.converters[i2];
                if (converterMatcher instanceof Converter) {
                    Converter converter = (Converter)converterMatcher;
                    xstream.registerConverter(converter, i2);
                    continue;
                }
                converterMatcher = this.converters[i2];
                if (converterMatcher instanceof SingleValueConverter) {
                    SingleValueConverter converter = (SingleValueConverter)converterMatcher;
                    xstream.registerConverter(converter, i2);
                    continue;
                }
                throw new IllegalArgumentException("Invalid ConverterMatcher [" + this.converters[i2] + "]");
            }
        }
        if (this.typePermissions != null) {
            for (TypePermission permission : this.typePermissions) {
                xstream.addPermission(permission);
            }
        }
        if (this.marshallingStrategy != null) {
            xstream.setMarshallingStrategy(this.marshallingStrategy);
        }
        if (this.mode != null) {
            xstream.setMode(this.mode.intValue());
        }
        try {
            if (this.aliases != null) {
                Map<String, Class<?>> classMap = this.toClassMap(this.aliases);
                classMap.forEach((arg_0, arg_1) -> ((XStream)xstream).alias(arg_0, arg_1));
            }
            if (this.aliasesByType != null) {
                Map<String, Class<?>> classMap = this.toClassMap(this.aliasesByType);
                classMap.forEach((arg_0, arg_1) -> ((XStream)xstream).aliasType(arg_0, arg_1));
            }
            if (this.fieldAliases != null) {
                for (Map.Entry<String, String> entry : this.fieldAliases.entrySet()) {
                    String alias = entry.getValue();
                    String field = entry.getKey();
                    int idx = field.lastIndexOf(46);
                    if (idx != -1) {
                        className = field.substring(0, idx);
                        Class<?> clazz = ClassUtils.forName(className, this.beanClassLoader);
                        String fieldName = field.substring(idx + 1);
                        xstream.aliasField(alias, clazz, fieldName);
                        continue;
                    }
                    throw new IllegalArgumentException("Field name [" + field + "] does not contain '.'");
                }
            }
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Failed to load specified alias class", ex);
        }
        if (this.useAttributeForTypes != null) {
            for (Class<?> type : this.useAttributeForTypes) {
                xstream.useAttributeFor(type);
            }
        }
        if (this.useAttributeFor != null) {
            for (Map.Entry<?, ?> entry : this.useAttributeFor.entrySet()) {
                Object clazz;
                Object idx = entry.getKey();
                if (idx instanceof String) {
                    String key2 = (String)idx;
                    className = entry.getValue();
                    if (className instanceof Class) {
                        clazz = (Class)className;
                        xstream.useAttributeFor(key2, clazz);
                        continue;
                    }
                    throw new IllegalArgumentException("'useAttributesFor' takes Map<String, Class> when using a map key of type String");
                }
                clazz = entry.getKey();
                if (clazz instanceof Class) {
                    Class key3 = (Class)clazz;
                    Object object = entry.getValue();
                    if (object instanceof String) {
                        String value2 = (String)object;
                        xstream.useAttributeFor(key3, value2);
                        continue;
                    }
                    object = entry.getValue();
                    if (object instanceof List) {
                        List listValue = (List)object;
                        for (Object element : listValue) {
                            if (!(element instanceof String)) continue;
                            String value3 = (String)element;
                            xstream.useAttributeFor(key3, value3);
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("'useAttributesFor' property takes either Map<Class, String> or Map<Class, List<String>> when using a map key of type Class");
                }
                throw new IllegalArgumentException("'useAttributesFor' property takes either a map key of type String or Class");
            }
        }
        if (this.implicitCollections != null) {
            this.implicitCollections.forEach((key, fields) -> {
                String[] collectionFields;
                for (String collectionField : collectionFields = StringUtils.commaDelimitedListToStringArray(fields)) {
                    xstream.addImplicitCollection(key, collectionField);
                }
            });
        }
        if (this.omittedFields != null) {
            this.omittedFields.forEach((key, value) -> {
                String[] fields;
                for (String field : fields = StringUtils.commaDelimitedListToStringArray(value)) {
                    xstream.omitField(key, field);
                }
            });
        }
        if (this.annotatedClasses != null) {
            xstream.processAnnotations((Class[])this.annotatedClasses);
        }
        if (this.autodetectAnnotations) {
            xstream.autodetectAnnotations(true);
        }
    }

    private Map<String, Class<?>> toClassMap(Map<String, ?> map) throws ClassNotFoundException {
        LinkedHashMap<String, Class<?>> result = CollectionUtils.newLinkedHashMap(map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Class<?> type;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Class) {
                Class<?> clazz;
                type = clazz = (Class<?>)value;
            } else if (value instanceof String) {
                String className = (String)value;
                type = ClassUtils.forName(className, this.beanClassLoader);
            } else {
                throw new IllegalArgumentException("Unknown value [" + value + "] - expected String or Class");
            }
            result.put(key, type);
        }
        return result;
    }

    protected void customizeXStream(XStream xstream) {
    }

    public final XStream getXStream() {
        return this.xstream.obtain();
    }

    @Override
    public boolean supports(Class<?> clazz) {
        if (ObjectUtils.isEmpty(this.supportedClasses)) {
            return true;
        }
        for (Class<?> supportedClass : this.supportedClasses) {
            if (!supportedClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void marshalDomNode(Object graph, Node node) throws XmlMappingException {
        DomWriter streamWriter;
        if (node instanceof Document) {
            Document document = (Document)node;
            streamWriter = new DomWriter(document, this.nameCoder);
        } else if (node instanceof Element) {
            Element element = (Element)node;
            streamWriter = new DomWriter(element, node.getOwnerDocument(), this.nameCoder);
        } else {
            throw new IllegalArgumentException("DOMResult contains neither Document nor Element");
        }
        this.doMarshal(graph, (HierarchicalStreamWriter)streamWriter, null);
    }

    @Override
    protected void marshalXmlEventWriter(Object graph, XMLEventWriter eventWriter) throws XmlMappingException {
        LexicalHandler handler;
        ContentHandler contentHandler = StaxUtils.createContentHandler(eventWriter);
        LexicalHandler lexicalHandler = contentHandler instanceof LexicalHandler ? (handler = (LexicalHandler)((Object)contentHandler)) : null;
        this.marshalSaxHandlers(graph, contentHandler, lexicalHandler);
    }

    @Override
    protected void marshalXmlStreamWriter(Object graph, XMLStreamWriter streamWriter) throws XmlMappingException {
        try {
            StaxWriter writer;
            HierarchicalStreamDriver hierarchicalStreamDriver = this.streamDriver;
            if (hierarchicalStreamDriver instanceof StaxDriver) {
                StaxDriver staxDriver = (StaxDriver)hierarchicalStreamDriver;
                writer = staxDriver.createStaxWriter(streamWriter);
            } else {
                writer = new StaxWriter(new QNameMap(), streamWriter, this.nameCoder);
            }
            this.doMarshal(graph, (HierarchicalStreamWriter)writer, null);
        }
        catch (XMLStreamException ex) {
            throw this.convertXStreamException(ex, true);
        }
    }

    @Override
    protected void marshalSaxHandlers(Object graph, ContentHandler contentHandler, @Nullable LexicalHandler lexicalHandler) throws XmlMappingException {
        SaxWriter saxWriter = new SaxWriter(this.nameCoder);
        saxWriter.setContentHandler(contentHandler);
        this.doMarshal(graph, (HierarchicalStreamWriter)saxWriter, null);
    }

    @Override
    public void marshalOutputStream(Object graph, OutputStream outputStream) throws XmlMappingException, IOException {
        this.marshalOutputStream(graph, outputStream, null);
    }

    public void marshalOutputStream(Object graph, OutputStream outputStream, @Nullable DataHolder dataHolder) throws XmlMappingException, IOException {
        if (this.streamDriver != null) {
            this.doMarshal(graph, this.streamDriver.createWriter(outputStream), dataHolder);
        } else {
            this.marshalWriter(graph, new OutputStreamWriter(outputStream, this.encoding), dataHolder);
        }
    }

    @Override
    public void marshalWriter(Object graph, Writer writer) throws XmlMappingException, IOException {
        this.marshalWriter(graph, writer, null);
    }

    public void marshalWriter(Object graph, Writer writer, @Nullable DataHolder dataHolder) throws XmlMappingException, IOException {
        if (this.streamDriver != null) {
            this.doMarshal(graph, this.streamDriver.createWriter(writer), dataHolder);
        } else {
            this.doMarshal(graph, (HierarchicalStreamWriter)new CompactWriter(writer), dataHolder);
        }
    }

    private void doMarshal(Object graph, HierarchicalStreamWriter streamWriter, @Nullable DataHolder dataHolder) {
        try {
            this.getXStream().marshal(graph, streamWriter, dataHolder);
        }
        catch (Exception ex) {
            throw this.convertXStreamException(ex, true);
        }
        finally {
            try {
                streamWriter.flush();
            }
            catch (Exception ex) {
                this.logger.debug("Could not flush HierarchicalStreamWriter", ex);
            }
        }
    }

    @Override
    protected Object unmarshalStreamSource(StreamSource streamSource) throws XmlMappingException, IOException {
        if (streamSource.getInputStream() != null) {
            return this.unmarshalInputStream(streamSource.getInputStream());
        }
        if (streamSource.getReader() != null) {
            return this.unmarshalReader(streamSource.getReader());
        }
        throw new IllegalArgumentException("StreamSource contains neither InputStream nor Reader");
    }

    @Override
    protected Object unmarshalDomNode(Node node) throws XmlMappingException {
        DomReader streamReader;
        if (node instanceof Document) {
            Document document = (Document)node;
            streamReader = new DomReader(document, this.nameCoder);
        } else if (node instanceof Element) {
            Element element = (Element)node;
            streamReader = new DomReader(element, this.nameCoder);
        } else {
            throw new IllegalArgumentException("DOMSource contains neither Document nor Element");
        }
        return this.doUnmarshal((HierarchicalStreamReader)streamReader, null);
    }

    @Override
    protected Object unmarshalXmlEventReader(XMLEventReader eventReader) throws XmlMappingException {
        try {
            XMLStreamReader streamReader = StaxUtils.createEventStreamReader(eventReader);
            return this.unmarshalXmlStreamReader(streamReader);
        }
        catch (XMLStreamException ex) {
            throw this.convertXStreamException(ex, false);
        }
    }

    @Override
    protected Object unmarshalXmlStreamReader(XMLStreamReader streamReader) throws XmlMappingException {
        return this.doUnmarshal((HierarchicalStreamReader)new StaxReader(new QNameMap(), streamReader, this.nameCoder), null);
    }

    @Override
    protected Object unmarshalSaxReader(XMLReader xmlReader, InputSource inputSource) throws XmlMappingException, IOException {
        throw new UnsupportedOperationException("XStreamMarshaller does not support unmarshalling using SAX XMLReaders");
    }

    @Override
    public Object unmarshalInputStream(InputStream inputStream) throws XmlMappingException, IOException {
        return this.unmarshalInputStream(inputStream, null);
    }

    public Object unmarshalInputStream(InputStream inputStream, @Nullable DataHolder dataHolder) throws XmlMappingException, IOException {
        if (this.streamDriver != null) {
            return this.doUnmarshal(this.streamDriver.createReader(inputStream), dataHolder);
        }
        return this.unmarshalReader(new InputStreamReader(inputStream, this.encoding), dataHolder);
    }

    @Override
    public Object unmarshalReader(Reader reader) throws XmlMappingException, IOException {
        return this.unmarshalReader(reader, null);
    }

    public Object unmarshalReader(Reader reader, @Nullable DataHolder dataHolder) throws XmlMappingException, IOException {
        return this.doUnmarshal(this.getDefaultDriver().createReader(reader), dataHolder);
    }

    private Object doUnmarshal(HierarchicalStreamReader streamReader, @Nullable DataHolder dataHolder) {
        try {
            return this.getXStream().unmarshal(streamReader, null, dataHolder);
        }
        catch (Exception ex) {
            throw this.convertXStreamException(ex, false);
        }
    }

    protected XmlMappingException convertXStreamException(Exception ex, boolean marshalling) {
        if (ex instanceof StreamException || ex instanceof CannotResolveClassException || ex instanceof ForbiddenClassException || ex instanceof ConversionException) {
            if (marshalling) {
                return new MarshallingFailureException("XStream marshalling exception", ex);
            }
            return new UnmarshallingFailureException("XStream unmarshalling exception", ex);
        }
        return new UncategorizedMappingException("Unknown XStream exception", ex);
    }
}

