/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.saml2;

import jakarta.servlet.Filter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml4AuthenticationProvider;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.HttpSessionSaml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationTokenConverter;
import org.springframework.security.saml2.provider.service.web.Saml2WebSsoAuthenticationRequestFilter;
import org.springframework.security.saml2.provider.service.web.authentication.OpenSaml4AuthenticationRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2AuthenticationRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2WebSsoAuthenticationFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class Saml2LoginConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractAuthenticationFilterConfigurer<B, Saml2LoginConfigurer<B>, Saml2WebSsoAuthenticationFilter> {
    private String loginPage;
    private String authenticationRequestUri = "/saml2/authenticate/{registrationId}";
    private Saml2AuthenticationRequestResolver authenticationRequestResolver;
    private String loginProcessingUrl = "/login/saml2/sso/{registrationId}";
    private RelyingPartyRegistrationRepository relyingPartyRegistrationRepository;
    private AuthenticationConverter authenticationConverter;
    private AuthenticationManager authenticationManager;
    private Saml2WebSsoAuthenticationFilter saml2WebSsoAuthenticationFilter;

    public Saml2LoginConfigurer<B> authenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, "authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
        return this;
    }

    public Saml2LoginConfigurer<B> authenticationManager(AuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationManager, "authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
        return this;
    }

    public Saml2LoginConfigurer<B> relyingPartyRegistrationRepository(RelyingPartyRegistrationRepository repo) {
        this.relyingPartyRegistrationRepository = repo;
        return this;
    }

    @Override
    public Saml2LoginConfigurer<B> loginPage(String loginPage) {
        Assert.hasText(loginPage, "loginPage cannot be empty");
        this.loginPage = loginPage;
        return this;
    }

    public Saml2LoginConfigurer<B> authenticationRequestResolver(Saml2AuthenticationRequestResolver authenticationRequestResolver) {
        Assert.notNull((Object)authenticationRequestResolver, "authenticationRequestResolver cannot be null");
        this.authenticationRequestResolver = authenticationRequestResolver;
        return this;
    }

    public Saml2LoginConfigurer<B> authenticationRequestUri(String authenticationRequestUri) {
        Assert.state(authenticationRequestUri.contains("{registrationId}"), "authenticationRequestUri must contain {registrationId} path variable");
        this.authenticationRequestUri = authenticationRequestUri;
        return this;
    }

    @Override
    public Saml2LoginConfigurer<B> loginProcessingUrl(String loginProcessingUrl) {
        Assert.hasText(loginProcessingUrl, "loginProcessingUrl cannot be empty");
        this.loginProcessingUrl = loginProcessingUrl;
        return this;
    }

    @Override
    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return new AntPathRequestMatcher(loginProcessingUrl);
    }

    @Override
    public void init(B http) throws Exception {
        this.registerDefaultCsrfOverride(http);
        this.relyingPartyRegistrationRepository(http);
        this.saml2WebSsoAuthenticationFilter = new Saml2WebSsoAuthenticationFilter(this.getAuthenticationConverter(http), this.loginProcessingUrl);
        this.saml2WebSsoAuthenticationFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        this.setAuthenticationRequestRepository(http, this.saml2WebSsoAuthenticationFilter);
        this.setAuthenticationFilter(this.saml2WebSsoAuthenticationFilter);
        super.loginProcessingUrl(this.loginProcessingUrl);
        if (StringUtils.hasText(this.loginPage)) {
            super.loginPage(this.loginPage);
            super.init(http);
        } else {
            boolean singleProvider;
            Map<String, String> providerUrlMap = this.getIdentityProviderUrlMap(this.authenticationRequestUri, this.relyingPartyRegistrationRepository);
            boolean bl = singleProvider = providerUrlMap.size() == 1;
            if (singleProvider) {
                this.updateAuthenticationDefaults();
                this.updateAccessDefaults(http);
                String loginUrl = providerUrlMap.entrySet().iterator().next().getKey();
                this.registerAuthenticationEntryPoint(http, this.getLoginEntryPoint(http, loginUrl));
            } else {
                super.init(http);
            }
        }
        this.initDefaultLoginFilter(http);
    }

    @Override
    public void configure(B http) throws Exception {
        Saml2WebSsoAuthenticationRequestFilter filter2 = this.getAuthenticationRequestFilter(http);
        filter2.setAuthenticationRequestRepository(this.getAuthenticationRequestRepository(http));
        http.addFilter((Filter)this.postProcess(filter2));
        super.configure(http);
        if (this.authenticationManager == null) {
            this.registerDefaultAuthenticationProvider(http);
        } else {
            this.saml2WebSsoAuthenticationFilter.setAuthenticationManager(this.authenticationManager);
        }
    }

    private RelyingPartyRegistrationResolver relyingPartyRegistrationResolver(B http) {
        RelyingPartyRegistrationRepository registrations = this.relyingPartyRegistrationRepository(http);
        return new DefaultRelyingPartyRegistrationResolver(registrations);
    }

    RelyingPartyRegistrationRepository relyingPartyRegistrationRepository(B http) {
        if (this.relyingPartyRegistrationRepository == null) {
            this.relyingPartyRegistrationRepository = this.getSharedOrBean(http, RelyingPartyRegistrationRepository.class);
        }
        return this.relyingPartyRegistrationRepository;
    }

    private AuthenticationEntryPoint getLoginEntryPoint(B http, String providerLoginPage) {
        AntPathRequestMatcher loginPageMatcher = new AntPathRequestMatcher(this.getLoginPage());
        AntPathRequestMatcher faviconMatcher = new AntPathRequestMatcher("/favicon.ico");
        RequestMatcher defaultEntryPointMatcher = this.getAuthenticationEntryPointMatcher(http);
        AndRequestMatcher defaultLoginPageMatcher = new AndRequestMatcher(new OrRequestMatcher(loginPageMatcher, faviconMatcher), defaultEntryPointMatcher);
        NegatedRequestMatcher notXRequestedWith = new NegatedRequestMatcher(new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest"));
        LinkedHashMap<RequestMatcher, AuthenticationEntryPoint> entryPoints = new LinkedHashMap<RequestMatcher, AuthenticationEntryPoint>();
        entryPoints.put(new AndRequestMatcher(notXRequestedWith, new NegatedRequestMatcher(defaultLoginPageMatcher)), new LoginUrlAuthenticationEntryPoint(providerLoginPage));
        DelegatingAuthenticationEntryPoint loginEntryPoint = new DelegatingAuthenticationEntryPoint(entryPoints);
        loginEntryPoint.setDefaultEntryPoint(this.getAuthenticationEntryPoint());
        return loginEntryPoint;
    }

    private void setAuthenticationRequestRepository(B http, Saml2WebSsoAuthenticationFilter saml2WebSsoAuthenticationFilter) {
        saml2WebSsoAuthenticationFilter.setAuthenticationRequestRepository(this.getAuthenticationRequestRepository(http));
    }

    private Saml2WebSsoAuthenticationRequestFilter getAuthenticationRequestFilter(B http) {
        Saml2AuthenticationRequestResolver authenticationRequestResolver = this.getAuthenticationRequestResolver(http);
        return new Saml2WebSsoAuthenticationRequestFilter(authenticationRequestResolver);
    }

    private Saml2AuthenticationRequestResolver getAuthenticationRequestResolver(B http) {
        if (this.authenticationRequestResolver != null) {
            return this.authenticationRequestResolver;
        }
        Saml2AuthenticationRequestResolver bean2 = this.getBeanOrNull(http, Saml2AuthenticationRequestResolver.class);
        if (bean2 != null) {
            return bean2;
        }
        OpenSaml4AuthenticationRequestResolver openSaml4AuthenticationRequestResolver = new OpenSaml4AuthenticationRequestResolver(this.relyingPartyRegistrationResolver(http));
        openSaml4AuthenticationRequestResolver.setRequestMatcher((RequestMatcher)new AntPathRequestMatcher(this.authenticationRequestUri));
        return openSaml4AuthenticationRequestResolver;
    }

    private AuthenticationConverter getAuthenticationConverter(B http) {
        if (this.authenticationConverter != null) {
            return this.authenticationConverter;
        }
        AuthenticationConverter authenticationConverterBean = (AuthenticationConverter)this.getBeanOrNull(http, Saml2AuthenticationTokenConverter.class);
        if (authenticationConverterBean == null) {
            Assert.state(this.loginProcessingUrl.contains("{registrationId}"), "loginProcessingUrl must contain {registrationId} path variable");
            return new Saml2AuthenticationTokenConverter((RelyingPartyRegistrationResolver)new DefaultRelyingPartyRegistrationResolver(this.relyingPartyRegistrationRepository));
        }
        return authenticationConverterBean;
    }

    private void registerDefaultAuthenticationProvider(B http) {
        http.authenticationProvider((AuthenticationProvider)this.postProcess(new OpenSaml4AuthenticationProvider()));
    }

    private void registerDefaultCsrfOverride(B http) {
        CsrfConfigurer csrf = http.getConfigurer(CsrfConfigurer.class);
        if (csrf == null) {
            return;
        }
        csrf.ignoringRequestMatchers(new AntPathRequestMatcher(this.loginProcessingUrl));
    }

    private void initDefaultLoginFilter(B http) {
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter == null || this.isCustomLoginPage()) {
            return;
        }
        loginPageGeneratingFilter.setSaml2LoginEnabled(true);
        loginPageGeneratingFilter.setSaml2AuthenticationUrlToProviderName(this.getIdentityProviderUrlMap(this.authenticationRequestUri, this.relyingPartyRegistrationRepository));
        loginPageGeneratingFilter.setLoginPageUrl(this.getLoginPage());
        loginPageGeneratingFilter.setFailureUrl(this.getFailureUrl());
    }

    private Map<String, String> getIdentityProviderUrlMap(String authRequestPrefixUrl, RelyingPartyRegistrationRepository idpRepo) {
        LinkedHashMap<String, String> idps = new LinkedHashMap<String, String>();
        if (idpRepo instanceof Iterable) {
            Iterable repo = (Iterable)idpRepo;
            repo.forEach(p -> idps.put(authRequestPrefixUrl.replace("{registrationId}", p.getRegistrationId()), p.getRegistrationId()));
        }
        return idps;
    }

    private Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> getAuthenticationRequestRepository(B http) {
        Saml2AuthenticationRequestRepository repository = this.getBeanOrNull(http, Saml2AuthenticationRequestRepository.class);
        if (repository == null) {
            return new HttpSessionSaml2AuthenticationRequestRepository();
        }
        return repository;
    }

    private <C> C getSharedOrBean(B http, Class<C> clazz) {
        C shared = http.getSharedObject(clazz);
        if (shared != null) {
            return shared;
        }
        return this.getBeanOrNull(http, clazz);
    }

    private <C> C getBeanOrNull(B http, Class<C> clazz) {
        ApplicationContext context = http.getSharedObject(ApplicationContext.class);
        if (context == null) {
            return null;
        }
        try {
            return context.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    private <C> void setSharedObject(B http, Class<C> clazz, C object) {
        if (http.getSharedObject(clazz) == null) {
            http.setSharedObject(clazz, object);
        }
    }
}

