/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.http.HandlerMappingIntrospectorFactoryBean;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public enum MatcherType {
    ant(AntPathRequestMatcher.class),
    regex(RegexRequestMatcher.class),
    ciRegex(RegexRequestMatcher.class),
    mvc(MvcRequestMatcher.class);

    private static final String HANDLER_MAPPING_INTROSPECTOR = "org.springframework.web.servlet.handler.HandlerMappingIntrospector";
    private static final boolean mvcPresent;
    private static final String ATT_MATCHER_TYPE = "request-matcher";
    final Class<? extends RequestMatcher> type;

    private MatcherType(Class<? extends RequestMatcher> type) {
        this.type = type;
    }

    public BeanDefinition createMatcher(ParserContext pc, String path, String method) {
        return this.createMatcher(pc, path, method, null);
    }

    public BeanDefinition createMatcher(ParserContext pc, String path, String method, String servletPath) {
        if (("/**".equals(path) || "**".equals(path)) && method == null) {
            return new RootBeanDefinition(AnyRequestMatcher.class);
        }
        BeanDefinitionBuilder matcherBldr = BeanDefinitionBuilder.rootBeanDefinition(this.type);
        if (this == mvc) {
            matcherBldr.addConstructorArgValue(new RootBeanDefinition(HandlerMappingIntrospectorFactoryBean.class));
        }
        matcherBldr.addConstructorArgValue(path);
        if (this == mvc) {
            matcherBldr.addPropertyValue("method", StringUtils.hasText(method) ? HttpMethod.valueOf(method) : null);
            matcherBldr.addPropertyValue("servletPath", servletPath);
        } else {
            matcherBldr.addConstructorArgValue(method);
        }
        if (this == ciRegex) {
            matcherBldr.addConstructorArgValue(true);
        }
        return matcherBldr.getBeanDefinition();
    }

    static MatcherType fromElement(Element elt) {
        if (StringUtils.hasText(elt.getAttribute(ATT_MATCHER_TYPE))) {
            return MatcherType.valueOf(elt.getAttribute(ATT_MATCHER_TYPE));
        }
        return ant;
    }

    static MatcherType fromElementOrMvc(Element elt) {
        String matcherTypeName = elt.getAttribute(ATT_MATCHER_TYPE);
        if (!StringUtils.hasText(matcherTypeName) && mvcPresent) {
            return mvc;
        }
        return MatcherType.fromElement(elt);
    }

    static {
        mvcPresent = ClassUtils.isPresent(HANDLER_MAPPING_INTROSPECTOR, MatcherType.class.getClassLoader());
    }
}

