/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.util.List;
import java.util.Map;
import org.springframework.aop.Pointcut;
import org.springframework.aop.config.AbstractInterceptorDrivenBeanDefinitionDecorator;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.access.method.MapBasedMethodSecurityMetadataSource;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.MethodExpressionAuthorizationManager;
import org.springframework.security.config.method.MethodConfigUtils;
import org.springframework.security.config.method.PointcutDelegatingAuthorizationManager;
import org.springframework.security.config.method.PrefixBasedMethodMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InterceptMethodsBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    private final InternalAuthorizationManagerInterceptMethodsBeanDefinitionDecorator authorizationManagerDelegate = new InternalAuthorizationManagerInterceptMethodsBeanDefinitionDecorator();
    private final BeanDefinitionDecorator delegate = new InternalInterceptMethodsBeanDefinitionDecorator();

    @Override
    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
        if (this.authorizationManagerDelegate.supports(node)) {
            return this.authorizationManagerDelegate.decorate(node, definition, parserContext);
        }
        MethodConfigUtils.registerDefaultMethodAccessManagerIfNecessary(parserContext);
        return this.delegate.decorate(node, definition, parserContext);
    }

    static class InternalAuthorizationManagerInterceptMethodsBeanDefinitionDecorator
    extends AbstractInterceptorDrivenBeanDefinitionDecorator {
        static final String ATT_METHOD = "method";
        static final String ATT_ACCESS = "access";
        private static final String ATT_USE_AUTHORIZATION_MGR = "use-authorization-manager";
        private static final String ATT_AUTHORIZATION_MGR = "authorization-manager-ref";

        InternalAuthorizationManagerInterceptMethodsBeanDefinitionDecorator() {
        }

        @Override
        protected BeanDefinition createInterceptorDefinition(Node node) {
            Element interceptMethodsElt = (Element)node;
            BeanDefinitionBuilder interceptor = BeanDefinitionBuilder.rootBeanDefinition(AuthorizationManagerBeforeMethodInterceptor.class);
            interceptor.setAutowireMode(2);
            ManagedMap<Pointcut, BeanMetadataElement> managers = new ManagedMap<Pointcut, BeanMetadataElement>();
            List<Element> methods = DomUtils.getChildElementsByTagName(interceptMethodsElt, "protect");
            for (Element protectElt : methods) {
                managers.put(this.pointcut(interceptMethodsElt, protectElt), this.authorizationManager(interceptMethodsElt, protectElt));
            }
            return interceptor.addConstructorArgValue(Pointcut.TRUE).addConstructorArgValue(this.authorizationManager(managers)).getBeanDefinition();
        }

        boolean supports(Node node) {
            Element interceptMethodsElt = (Element)node;
            if (StringUtils.hasText(interceptMethodsElt.getAttribute(ATT_AUTHORIZATION_MGR))) {
                return true;
            }
            if (StringUtils.hasText(interceptMethodsElt.getAttribute(ATT_USE_AUTHORIZATION_MGR))) {
                return Boolean.parseBoolean(interceptMethodsElt.getAttribute(ATT_USE_AUTHORIZATION_MGR));
            }
            return true;
        }

        private Pointcut pointcut(Element interceptorElt, Element protectElt) {
            String method = protectElt.getAttribute(ATT_METHOD);
            String parentBeanClass = ((Element)interceptorElt.getParentNode()).getAttribute("class");
            return PrefixBasedMethodMatcher.fromClass(parentBeanClass, method);
        }

        private BeanMetadataElement authorizationManager(Element interceptMethodsElt, Element protectElt) {
            String authorizationManager = interceptMethodsElt.getAttribute(ATT_AUTHORIZATION_MGR);
            if (StringUtils.hasText(authorizationManager)) {
                return new RuntimeBeanReference(authorizationManager);
            }
            String access = protectElt.getAttribute(ATT_ACCESS);
            return BeanDefinitionBuilder.rootBeanDefinition(MethodExpressionAuthorizationManager.class).addConstructorArgValue(access).getBeanDefinition();
        }

        private BeanMetadataElement authorizationManager(Map<Pointcut, BeanMetadataElement> managers) {
            return BeanDefinitionBuilder.rootBeanDefinition(PointcutDelegatingAuthorizationManager.class).addConstructorArgValue(managers).getBeanDefinition();
        }
    }

    @Deprecated
    static class InternalInterceptMethodsBeanDefinitionDecorator
    extends AbstractInterceptorDrivenBeanDefinitionDecorator {
        static final String ATT_METHOD = "method";
        static final String ATT_ACCESS = "access";
        private static final String ATT_ACCESS_MGR = "access-decision-manager-ref";

        InternalInterceptMethodsBeanDefinitionDecorator() {
        }

        @Override
        protected BeanDefinition createInterceptorDefinition(Node node) {
            Element interceptMethodsElt = (Element)node;
            BeanDefinitionBuilder interceptor = BeanDefinitionBuilder.rootBeanDefinition(MethodSecurityInterceptor.class);
            interceptor.setAutowireMode(2);
            String accessManagerId = interceptMethodsElt.getAttribute(ATT_ACCESS_MGR);
            if (!StringUtils.hasText(accessManagerId)) {
                accessManagerId = "org.springframework.security.defaultMethodAccessManager";
            }
            interceptor.addPropertyValue("accessDecisionManager", new RuntimeBeanReference(accessManagerId));
            interceptor.addPropertyValue("authenticationManager", new RuntimeBeanReference("org.springframework.security.authenticationManager"));
            String parentBeanClass = ((Element)interceptMethodsElt.getParentNode()).getAttribute("class");
            List<Element> methods = DomUtils.getChildElementsByTagName(interceptMethodsElt, "protect");
            ManagedMap<String, AbstractBeanDefinition> mappings = new ManagedMap<String, AbstractBeanDefinition>();
            for (Element protectmethodElt : methods) {
                BeanDefinitionBuilder attributeBuilder = BeanDefinitionBuilder.rootBeanDefinition(SecurityConfig.class);
                attributeBuilder.setFactoryMethod("createListFromCommaDelimitedString");
                attributeBuilder.addConstructorArgValue(protectmethodElt.getAttribute(ATT_ACCESS));
                Object methodName = protectmethodElt.getAttribute(ATT_METHOD);
                if (((String)methodName).lastIndexOf(".") == -1 && parentBeanClass != null && !"".equals(parentBeanClass)) {
                    methodName = parentBeanClass + "." + (String)methodName;
                }
                mappings.put((String)methodName, attributeBuilder.getBeanDefinition());
            }
            RootBeanDefinition metadataSource = new RootBeanDefinition(MapBasedMethodSecurityMetadataSource.class);
            metadataSource.getConstructorArgumentValues().addGenericArgumentValue(mappings);
            interceptor.addPropertyValue("securityMetadataSource", metadataSource);
            return interceptor.getBeanDefinition();
        }
    }
}

