/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;

public class ForwardAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private final String forwardUrl;

    public ForwardAuthenticationFailureHandler(String forwardUrl) {
        Assert.isTrue(UrlUtils.isValidRedirectUrl(forwardUrl), () -> "'" + forwardUrl + "' is not a valid forward URL");
        this.forwardUrl = forwardUrl;
    }

    @Override
    public void onAuthenticationFailure(HttpServletRequest request2, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        request2.setAttribute("SPRING_SECURITY_LAST_EXCEPTION", exception);
        request2.getRequestDispatcher(this.forwardUrl).forward(request2, response);
    }
}

