/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.Transient;
import org.springframework.security.core.context.DeferredSecurityContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SaveContextOnUpdateOrErrorResponseWrapper;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.context.SupplierDeferredSecurityContext;
import org.springframework.util.Assert;
import org.springframework.web.util.WebUtils;

public class HttpSessionSecurityContextRepository
implements SecurityContextRepository {
    public static final String SPRING_SECURITY_CONTEXT_KEY = "SPRING_SECURITY_CONTEXT";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private Object contextObject = this.securityContextHolderStrategy.createEmptyContext();
    private boolean allowSessionCreation = true;
    private boolean disableUrlRewriting = false;
    private String springSecurityContextKey = "SPRING_SECURITY_CONTEXT";
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();

    @Override
    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        HttpServletRequest request2 = requestResponseHolder.getRequest();
        HttpServletResponse response = requestResponseHolder.getResponse();
        HttpSession httpSession = request2.getSession(false);
        SecurityContext context = this.readSecurityContextFromSession(httpSession);
        if (context == null) {
            context = this.generateNewContext();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(LogMessage.format("Created %s", (Object)context));
            }
        }
        if (response != null) {
            SaveToSessionResponseWrapper wrappedResponse = new SaveToSessionResponseWrapper(response, request2, httpSession != null, context);
            wrappedResponse.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
            requestResponseHolder.setResponse(wrappedResponse);
            requestResponseHolder.setRequest(new SaveToSessionRequestWrapper(request2, wrappedResponse));
        }
        return context;
    }

    @Override
    public DeferredSecurityContext loadDeferredContext(HttpServletRequest request2) {
        Supplier<SecurityContext> supplier = () -> this.readSecurityContextFromSession(request2.getSession(false));
        return new SupplierDeferredSecurityContext(supplier, this.securityContextHolderStrategy);
    }

    @Override
    public void saveContext(SecurityContext context, HttpServletRequest request2, HttpServletResponse response) {
        SaveContextOnUpdateOrErrorResponseWrapper responseWrapper = WebUtils.getNativeResponse(response, SaveContextOnUpdateOrErrorResponseWrapper.class);
        if (responseWrapper == null) {
            boolean httpSessionExists = request2.getSession(false) != null;
            SecurityContext initialContext = this.securityContextHolderStrategy.createEmptyContext();
            responseWrapper = new SaveToSessionResponseWrapper(response, request2, httpSessionExists, initialContext);
        }
        responseWrapper.saveContext(context);
    }

    @Override
    public boolean containsContext(HttpServletRequest request2) {
        HttpSession session = request2.getSession(false);
        if (session == null) {
            return false;
        }
        return session.getAttribute(this.springSecurityContextKey) != null;
    }

    private SecurityContext readSecurityContextFromSession(HttpSession httpSession) {
        if (httpSession == null) {
            this.logger.trace("No HttpSession currently exists");
            return null;
        }
        Object contextFromSession = httpSession.getAttribute(this.springSecurityContextKey);
        if (contextFromSession == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(LogMessage.format("Did not find SecurityContext in HttpSession %s using the SPRING_SECURITY_CONTEXT session attribute", (Object)httpSession.getId()));
            }
            return null;
        }
        if (!(contextFromSession instanceof SecurityContext)) {
            this.logger.warn(LogMessage.format("%s did not contain a SecurityContext but contained: '%s'; are you improperly modifying the HttpSession directly (you should always use SecurityContextHolder) or using the HttpSession attribute reserved for this class?", (Object)this.springSecurityContextKey, contextFromSession));
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(LogMessage.format("Retrieved %s from %s", contextFromSession, (Object)this.springSecurityContextKey));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(LogMessage.format("Retrieved %s", contextFromSession));
        }
        return (SecurityContext)contextFromSession;
    }

    protected SecurityContext generateNewContext() {
        return this.securityContextHolderStrategy.createEmptyContext();
    }

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    public void setDisableUrlRewriting(boolean disableUrlRewriting) {
        this.disableUrlRewriting = disableUrlRewriting;
    }

    public void setSpringSecurityContextKey(String springSecurityContextKey) {
        Assert.hasText(springSecurityContextKey, "springSecurityContextKey cannot be empty");
        this.springSecurityContextKey = springSecurityContextKey;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy strategy) {
        this.securityContextHolderStrategy = strategy;
        this.contextObject = this.securityContextHolderStrategy.createEmptyContext();
    }

    private boolean isTransient(Object object) {
        if (object == null) {
            return false;
        }
        return AnnotationUtils.getAnnotation(object.getClass(), Transient.class) != null;
    }

    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        Assert.notNull((Object)trustResolver, "trustResolver cannot be null");
        this.trustResolver = trustResolver;
    }

    final class SaveToSessionResponseWrapper
    extends SaveContextOnUpdateOrErrorResponseWrapper {
        private final Log logger;
        private final HttpServletRequest request;
        private final boolean httpSessionExistedAtStartOfRequest;
        private final SecurityContext contextBeforeExecution;
        private final Authentication authBeforeExecution;
        private boolean isSaveContextInvoked;

        SaveToSessionResponseWrapper(HttpServletResponse response, HttpServletRequest request2, boolean httpSessionExistedAtStartOfRequest, SecurityContext context) {
            super(response, HttpSessionSecurityContextRepository.this.disableUrlRewriting);
            this.logger = HttpSessionSecurityContextRepository.this.logger;
            this.request = request2;
            this.httpSessionExistedAtStartOfRequest = httpSessionExistedAtStartOfRequest;
            this.contextBeforeExecution = context;
            this.authBeforeExecution = context.getAuthentication();
        }

        @Override
        protected void saveContext(SecurityContext context) {
            if (HttpSessionSecurityContextRepository.this.isTransient(context)) {
                return;
            }
            Authentication authentication = context.getAuthentication();
            if (HttpSessionSecurityContextRepository.this.isTransient(authentication)) {
                return;
            }
            HttpSession httpSession = this.request.getSession(false);
            String springSecurityContextKey = HttpSessionSecurityContextRepository.this.springSecurityContextKey;
            if (authentication == null || HttpSessionSecurityContextRepository.this.trustResolver.isAnonymous(authentication)) {
                if (httpSession != null && this.authBeforeExecution != null) {
                    httpSession.removeAttribute(springSecurityContextKey);
                    this.isSaveContextInvoked = true;
                }
                if (this.logger.isDebugEnabled()) {
                    if (authentication == null) {
                        this.logger.debug("Did not store empty SecurityContext");
                    } else {
                        this.logger.debug("Did not store anonymous SecurityContext");
                    }
                }
                return;
            }
            HttpSession httpSession2 = httpSession = httpSession != null ? httpSession : this.createNewSessionIfAllowed(context);
            if (httpSession != null && (this.contextChanged(context) || httpSession.getAttribute(springSecurityContextKey) == null)) {
                httpSession.setAttribute(springSecurityContextKey, context);
                this.isSaveContextInvoked = true;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(LogMessage.format("Stored %s to HttpSession [%s]", (Object)context, (Object)httpSession));
                }
            }
        }

        private boolean contextChanged(SecurityContext context) {
            return this.isSaveContextInvoked || context != this.contextBeforeExecution || context.getAuthentication() != this.authBeforeExecution;
        }

        private HttpSession createNewSessionIfAllowed(SecurityContext context) {
            if (this.httpSessionExistedAtStartOfRequest) {
                this.logger.debug("HttpSession is now null, but was not null at start of request; session was invalidated, so do not create a new session");
                return null;
            }
            if (!HttpSessionSecurityContextRepository.this.allowSessionCreation) {
                this.logger.debug("The HttpSession is currently null, and the " + HttpSessionSecurityContextRepository.class.getSimpleName() + " is prohibited from creating an HttpSession (because the allowSessionCreation property is false) - SecurityContext thus not stored for next request");
                return null;
            }
            if (HttpSessionSecurityContextRepository.this.contextObject.equals(context)) {
                this.logger.debug(LogMessage.format("HttpSession is null, but SecurityContext has not changed from default empty context %s so not creating HttpSession or storing SecurityContext", (Object)context));
                return null;
            }
            try {
                HttpSession session = this.request.getSession(true);
                this.logger.debug("Created HttpSession as SecurityContext is non-default");
                return session;
            }
            catch (IllegalStateException ex) {
                this.logger.warn("Failed to create a session, as response has been committed. Unable to store SecurityContext.");
                return null;
            }
        }
    }

    private static class SaveToSessionRequestWrapper
    extends HttpServletRequestWrapper {
        private final SaveContextOnUpdateOrErrorResponseWrapper response;

        SaveToSessionRequestWrapper(HttpServletRequest request2, SaveContextOnUpdateOrErrorResponseWrapper response) {
            super(request2);
            this.response = response;
        }

        @Override
        public AsyncContext startAsync() {
            this.response.disableSaveOnResponseCommitted();
            return super.startAsync();
        }

        @Override
        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
            this.response.disableSaveOnResponseCommitted();
            return super.startAsync(servletRequest, servletResponse);
        }
    }
}

