/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.csrf;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.DeferredCsrfToken;
import org.springframework.security.web.csrf.XorCsrfTokenRequestAttributeHandler;
import org.springframework.util.Assert;

public final class CsrfAuthenticationStrategy
implements SessionAuthenticationStrategy {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final CsrfTokenRepository tokenRepository;
    private CsrfTokenRequestHandler requestHandler = new XorCsrfTokenRequestAttributeHandler();

    public CsrfAuthenticationStrategy(CsrfTokenRepository tokenRepository) {
        Assert.notNull((Object)tokenRepository, "tokenRepository cannot be null");
        this.tokenRepository = tokenRepository;
    }

    public void setRequestHandler(CsrfTokenRequestHandler requestHandler) {
        Assert.notNull((Object)requestHandler, "requestHandler cannot be null");
        this.requestHandler = requestHandler;
    }

    @Override
    public void onAuthentication(Authentication authentication, HttpServletRequest request2, HttpServletResponse response) throws SessionAuthenticationException {
        boolean containsToken;
        boolean bl = containsToken = this.tokenRepository.loadToken(request2) != null;
        if (containsToken) {
            this.tokenRepository.saveToken(null, request2, response);
            DeferredCsrfToken deferredCsrfToken = this.tokenRepository.loadDeferredToken(request2, response);
            this.requestHandler.handle(request2, response, deferredCsrfToken::get);
            this.logger.debug("Replaced CSRF Token");
        }
    }
}

