/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.method.annotation;

import java.lang.annotation.Annotation;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.security.core.annotation.CurrentSecurityContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public final class CurrentSecurityContextArgumentResolver
implements HandlerMethodArgumentResolver {
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private ExpressionParser parser = new SpelExpressionParser();
    private BeanResolver beanResolver;

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.findMethodAnnotation(CurrentSecurityContext.class, parameter) != null;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        SecurityContext securityContext = this.securityContextHolderStrategy.getContext();
        if (securityContext == null) {
            return null;
        }
        Object securityContextResult = securityContext;
        CurrentSecurityContext annotation = this.findMethodAnnotation(CurrentSecurityContext.class, parameter);
        String expressionToParse = annotation.expression();
        if (StringUtils.hasLength(expressionToParse)) {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject(securityContext);
            context.setVariable("this", securityContext);
            context.setBeanResolver(this.beanResolver);
            Expression expression = this.parser.parseExpression(expressionToParse);
            securityContextResult = expression.getValue(context);
        }
        if (securityContextResult != null && !parameter.getParameterType().isAssignableFrom(securityContextResult.getClass())) {
            if (annotation.errorOnInvalidType()) {
                throw new ClassCastException(securityContextResult + " is not assignable to " + parameter.getParameterType());
            }
            return null;
        }
        return securityContextResult;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, "securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        Assert.notNull((Object)beanResolver, "beanResolver cannot be null");
        this.beanResolver = beanResolver;
    }

    private <T extends Annotation> T findMethodAnnotation(Class<T> annotationClass, MethodParameter parameter) {
        Annotation[] annotationsToSearch;
        T annotation = parameter.getParameterAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        for (Annotation toSearch : annotationsToSearch = parameter.getParameterAnnotations()) {
            annotation = AnnotationUtils.findAnnotation(toSearch.annotationType(), annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }
}

