/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.csrf;

import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.codec.multipart.FormFieldPart;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRequestHandler;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ServerCsrfTokenRequestAttributeHandler
implements ServerCsrfTokenRequestHandler {
    private boolean isTokenFromMultipartDataEnabled;

    @Override
    public void handle(ServerWebExchange exchange2, Mono<CsrfToken> csrfToken) {
        Assert.notNull((Object)exchange2, "exchange cannot be null");
        Assert.notNull(csrfToken, "csrfToken cannot be null");
        exchange2.getAttributes().put(CsrfToken.class.getName(), csrfToken);
    }

    @Override
    public Mono<String> resolveCsrfTokenValue(ServerWebExchange exchange2, CsrfToken csrfToken) {
        return ServerCsrfTokenRequestHandler.super.resolveCsrfTokenValue(exchange2, csrfToken).switchIfEmpty(this.tokenFromMultipartData(exchange2, csrfToken));
    }

    public void setTokenFromMultipartDataEnabled(boolean tokenFromMultipartDataEnabled) {
        this.isTokenFromMultipartDataEnabled = tokenFromMultipartDataEnabled;
    }

    private Mono<String> tokenFromMultipartData(ServerWebExchange exchange2, CsrfToken expected) {
        if (!this.isTokenFromMultipartDataEnabled) {
            return Mono.empty();
        }
        ServerHttpRequest request2 = exchange2.getRequest();
        HttpHeaders headers = request2.getHeaders();
        MediaType contentType = headers.getContentType();
        if (!MediaType.MULTIPART_FORM_DATA.isCompatibleWith(contentType)) {
            return Mono.empty();
        }
        return exchange2.getMultipartData().map(d -> (Part)d.getFirst(expected.getParameterName())).cast(FormFieldPart.class).map(FormFieldPart::value);
    }
}

