/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.csrf;

import java.security.SecureRandom;
import java.util.Base64;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.csrf.DefaultCsrfToken;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRequestAttributeHandler;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class XorServerCsrfTokenRequestAttributeHandler
extends ServerCsrfTokenRequestAttributeHandler {
    private SecureRandom secureRandom = new SecureRandom();

    public void setSecureRandom(SecureRandom secureRandom) {
        Assert.notNull((Object)secureRandom, "secureRandom cannot be null");
        this.secureRandom = secureRandom;
    }

    @Override
    public void handle(ServerWebExchange exchange2, Mono<CsrfToken> csrfToken) {
        Assert.notNull((Object)exchange2, "exchange cannot be null");
        Assert.notNull(csrfToken, "csrfToken cannot be null");
        Mono<CsrfToken> updatedCsrfToken = csrfToken.map(token -> new DefaultCsrfToken(token.getHeaderName(), token.getParameterName(), XorServerCsrfTokenRequestAttributeHandler.createXoredCsrfToken(this.secureRandom, token.getToken()))).cast(CsrfToken.class).cache();
        super.handle(exchange2, updatedCsrfToken);
    }

    @Override
    public Mono<String> resolveCsrfTokenValue(ServerWebExchange exchange2, CsrfToken csrfToken) {
        return super.resolveCsrfTokenValue(exchange2, csrfToken).flatMap(actualToken -> Mono.justOrEmpty(XorServerCsrfTokenRequestAttributeHandler.getTokenValue(actualToken, csrfToken.getToken())));
    }

    private static String getTokenValue(String actualToken, String token) {
        byte[] actualBytes;
        try {
            actualBytes = Base64.getUrlDecoder().decode(actualToken);
        }
        catch (Exception ex) {
            return null;
        }
        byte[] tokenBytes = Utf8.encode(token);
        int tokenSize = tokenBytes.length;
        if (actualBytes.length < tokenSize) {
            return null;
        }
        int randomBytesSize = actualBytes.length - tokenSize;
        byte[] xoredCsrf = new byte[tokenSize];
        byte[] randomBytes = new byte[randomBytesSize];
        System.arraycopy(actualBytes, 0, randomBytes, 0, randomBytesSize);
        System.arraycopy(actualBytes, randomBytesSize, xoredCsrf, 0, tokenSize);
        byte[] csrfBytes = XorServerCsrfTokenRequestAttributeHandler.xorCsrf(randomBytes, xoredCsrf);
        return Utf8.decode(csrfBytes);
    }

    private static String createXoredCsrfToken(SecureRandom secureRandom, String token) {
        byte[] tokenBytes = Utf8.encode(token);
        byte[] randomBytes = new byte[tokenBytes.length];
        secureRandom.nextBytes(randomBytes);
        byte[] xoredBytes = XorServerCsrfTokenRequestAttributeHandler.xorCsrf(randomBytes, tokenBytes);
        byte[] combinedBytes = new byte[tokenBytes.length + randomBytes.length];
        System.arraycopy(randomBytes, 0, combinedBytes, 0, randomBytes.length);
        System.arraycopy(xoredBytes, 0, combinedBytes, randomBytes.length, xoredBytes.length);
        return Base64.getUrlEncoder().encodeToString(combinedBytes);
    }

    private static byte[] xorCsrf(byte[] randomBytes, byte[] csrfBytes) {
        int len = Math.min(randomBytes.length, csrfBytes.length);
        byte[] xoredCsrf = new byte[len];
        System.arraycopy(csrfBytes, 0, xoredCsrf, 0, csrfBytes.length);
        for (int i2 = 0; i2 < len; ++i2) {
            int n = i2;
            xoredCsrf[n] = (byte)(xoredCsrf[n] ^ randomBytes[i2]);
        }
        return xoredCsrf;
    }
}

