/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.servletapi;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.servletapi.HttpServletRequestFactory;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

final class HttpServlet3RequestFactory
implements HttpServletRequestFactory {
    private Log logger = LogFactory.getLog(this.getClass());
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private final String rolePrefix;
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private final AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private AuthenticationEntryPoint authenticationEntryPoint;
    private AuthenticationManager authenticationManager;
    private List<LogoutHandler> logoutHandlers;
    private SecurityContextRepository securityContextRepository;

    HttpServlet3RequestFactory(String rolePrefix, SecurityContextRepository securityContextRepository) {
        this.rolePrefix = rolePrefix;
        this.securityContextRepository = securityContextRepository;
    }

    void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    void setLogoutHandlers(List<LogoutHandler> logoutHandlers) {
        this.logoutHandlers = logoutHandlers;
    }

    void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        Assert.notNull((Object)trustResolver, "trustResolver cannot be null");
        this.trustResolver = trustResolver;
    }

    void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, "securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    @Override
    public HttpServletRequest create(HttpServletRequest request2, HttpServletResponse response) {
        Servlet3SecurityContextHolderAwareRequestWrapper wrapper = new Servlet3SecurityContextHolderAwareRequestWrapper(request2, this.rolePrefix, response);
        wrapper.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
        return wrapper;
    }

    private class Servlet3SecurityContextHolderAwareRequestWrapper
    extends SecurityContextHolderAwareRequestWrapper {
        private final HttpServletResponse response;

        Servlet3SecurityContextHolderAwareRequestWrapper(HttpServletRequest request2, String rolePrefix, HttpServletResponse response) {
            super(request2, HttpServlet3RequestFactory.this.trustResolver, rolePrefix);
            this.response = response;
        }

        @Override
        public AsyncContext getAsyncContext() {
            AsyncContext asyncContext = super.getAsyncContext();
            if (asyncContext == null) {
                return null;
            }
            return new SecurityContextAsyncContext(asyncContext);
        }

        @Override
        public AsyncContext startAsync() {
            AsyncContext startAsync = super.startAsync();
            return new SecurityContextAsyncContext(startAsync);
        }

        @Override
        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
            AsyncContext startAsync = super.startAsync(servletRequest, servletResponse);
            return new SecurityContextAsyncContext(startAsync);
        }

        @Override
        public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
            AuthenticationEntryPoint entryPoint = HttpServlet3RequestFactory.this.authenticationEntryPoint;
            if (entryPoint == null) {
                HttpServlet3RequestFactory.this.logger.debug("authenticationEntryPoint is null, so allowing original HttpServletRequest to handle authenticate");
                return super.authenticate(response);
            }
            if (this.isAuthenticated()) {
                return true;
            }
            entryPoint.commence(this, response, new AuthenticationCredentialsNotFoundException("User is not Authenticated"));
            return false;
        }

        @Override
        public void login(String username, String password) throws ServletException {
            if (this.isAuthenticated()) {
                throw new ServletException("Cannot perform login for '" + username + "' already authenticated as '" + this.getRemoteUser() + "'");
            }
            AuthenticationManager authManager = HttpServlet3RequestFactory.this.authenticationManager;
            if (authManager == null) {
                HttpServlet3RequestFactory.this.logger.debug("authenticationManager is null, so allowing original HttpServletRequest to handle login");
                super.login(username, password);
                return;
            }
            Authentication authentication = this.getAuthentication(authManager, username, password);
            SecurityContext context = HttpServlet3RequestFactory.this.securityContextHolderStrategy.createEmptyContext();
            context.setAuthentication(authentication);
            HttpServlet3RequestFactory.this.securityContextHolderStrategy.setContext(context);
            HttpServlet3RequestFactory.this.securityContextRepository.saveContext(context, this, this.response);
        }

        private Authentication getAuthentication(AuthenticationManager authManager, String username, String password) throws ServletException {
            try {
                UsernamePasswordAuthenticationToken authentication = UsernamePasswordAuthenticationToken.unauthenticated(username, password);
                Object details = HttpServlet3RequestFactory.this.authenticationDetailsSource.buildDetails(this);
                authentication.setDetails(details);
                return authManager.authenticate(authentication);
            }
            catch (AuthenticationException ex) {
                HttpServlet3RequestFactory.this.securityContextHolderStrategy.clearContext();
                throw new ServletException(ex.getMessage(), ex);
            }
        }

        @Override
        public void logout() throws ServletException {
            List<LogoutHandler> handlers = HttpServlet3RequestFactory.this.logoutHandlers;
            if (CollectionUtils.isEmpty(handlers)) {
                HttpServlet3RequestFactory.this.logger.debug("logoutHandlers is null, so allowing original HttpServletRequest to handle logout");
                super.logout();
                return;
            }
            Authentication authentication = HttpServlet3RequestFactory.this.securityContextHolderStrategy.getContext().getAuthentication();
            for (LogoutHandler handler : handlers) {
                handler.logout(this, this.response, authentication);
            }
        }

        private boolean isAuthenticated() {
            return this.getUserPrincipal() != null;
        }
    }

    private static class SecurityContextAsyncContext
    implements AsyncContext {
        private final AsyncContext asyncContext;

        SecurityContextAsyncContext(AsyncContext asyncContext) {
            this.asyncContext = asyncContext;
        }

        @Override
        public ServletRequest getRequest() {
            return this.asyncContext.getRequest();
        }

        @Override
        public ServletResponse getResponse() {
            return this.asyncContext.getResponse();
        }

        @Override
        public boolean hasOriginalRequestAndResponse() {
            return this.asyncContext.hasOriginalRequestAndResponse();
        }

        @Override
        public void dispatch() {
            this.asyncContext.dispatch();
        }

        @Override
        public void dispatch(String path) {
            this.asyncContext.dispatch(path);
        }

        @Override
        public void dispatch(ServletContext context, String path) {
            this.asyncContext.dispatch(context, path);
        }

        @Override
        public void complete() {
            this.asyncContext.complete();
        }

        @Override
        public void start(Runnable run) {
            this.asyncContext.start(new DelegatingSecurityContextRunnable(run));
        }

        @Override
        public void addListener(AsyncListener listener) {
            this.asyncContext.addListener(listener);
        }

        @Override
        public void addListener(AsyncListener listener, ServletRequest request2, ServletResponse response) {
            this.asyncContext.addListener(listener, request2, response);
        }

        @Override
        public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
            return this.asyncContext.createListener(clazz);
        }

        @Override
        public long getTimeout() {
            return this.asyncContext.getTimeout();
        }

        @Override
        public void setTimeout(long timeout) {
            this.asyncContext.setTimeout(timeout);
        }
    }
}

