/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.servletapi;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.security.Principal;
import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class SecurityContextHolderAwareRequestWrapper
extends HttpServletRequestWrapper {
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private final AuthenticationTrustResolver trustResolver;
    private final String rolePrefix;

    public SecurityContextHolderAwareRequestWrapper(HttpServletRequest request2, String rolePrefix) {
        this(request2, new AuthenticationTrustResolverImpl(), rolePrefix);
    }

    public SecurityContextHolderAwareRequestWrapper(HttpServletRequest request2, AuthenticationTrustResolver trustResolver, String rolePrefix) {
        super(request2);
        Assert.notNull((Object)trustResolver, "trustResolver cannot be null");
        this.rolePrefix = rolePrefix;
        this.trustResolver = trustResolver;
    }

    private Authentication getAuthentication() {
        Authentication auth = this.securityContextHolderStrategy.getContext().getAuthentication();
        return !this.trustResolver.isAnonymous(auth) ? auth : null;
    }

    @Override
    public String getRemoteUser() {
        Authentication auth = this.getAuthentication();
        if (auth == null || auth.getPrincipal() == null) {
            return null;
        }
        if (auth.getPrincipal() instanceof UserDetails) {
            return ((UserDetails)auth.getPrincipal()).getUsername();
        }
        if (auth instanceof AbstractAuthenticationToken) {
            return auth.getName();
        }
        return auth.getPrincipal().toString();
    }

    @Override
    public Principal getUserPrincipal() {
        Authentication auth = this.getAuthentication();
        if (auth == null || auth.getPrincipal() == null) {
            return null;
        }
        return auth;
    }

    private boolean isGranted(String role) {
        Authentication auth = this.getAuthentication();
        if (this.rolePrefix != null && role != null && !((String)role).startsWith(this.rolePrefix)) {
            role = this.rolePrefix + (String)role;
        }
        if (auth == null || auth.getPrincipal() == null) {
            return false;
        }
        Collection<? extends GrantedAuthority> authorities = auth.getAuthorities();
        if (authorities == null) {
            return false;
        }
        for (GrantedAuthority grantedAuthority : authorities) {
            if (!((String)role).equals(grantedAuthority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.isGranted(role);
    }

    public String toString() {
        return "SecurityContextHolderAwareRequestWrapper[ " + this.getRequest() + "]";
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, "securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }
}

