/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.springframework.core.style.DefaultToStringStyler;
import org.springframework.core.style.SimpleValueStyler;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.BootstrapContext;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.util.Assert;

public class DefaultBootstrapContext
implements BootstrapContext {
    private final Class<?> testClass;
    private final CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate;

    public DefaultBootstrapContext(Class<?> testClass, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate) {
        Assert.notNull(testClass, "Test class must not be null");
        Assert.notNull((Object)cacheAwareContextLoaderDelegate, "CacheAwareContextLoaderDelegate must not be null");
        this.testClass = testClass;
        this.cacheAwareContextLoaderDelegate = cacheAwareContextLoaderDelegate;
    }

    @Override
    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public CacheAwareContextLoaderDelegate getCacheAwareContextLoaderDelegate() {
        return this.cacheAwareContextLoaderDelegate;
    }

    public String toString() {
        return new ToStringCreator((Object)this, new DefaultToStringStyler(new SimpleValueStyler())).append("testClass", this.testClass).append("cacheAwareContextLoaderDelegate", this.cacheAwareContextLoaderDelegate.getClass()).toString();
    }
}

