/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.Arrays;
import org.springframework.core.style.DefaultToStringStyler;
import org.springframework.core.style.SimpleValueStyler;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class MergedTestPropertySources {
    private static final MergedTestPropertySources empty = new MergedTestPropertySources(new String[0], new String[0]);
    private final String[] locations;
    private final String[] properties;

    static MergedTestPropertySources empty() {
        return empty;
    }

    MergedTestPropertySources(String[] locations, String[] properties) {
        Assert.notNull((Object)locations, "The locations array must not be null");
        Assert.notNull((Object)properties, "The properties array must not be null");
        this.locations = locations;
        this.properties = properties;
    }

    String[] getLocations() {
        return this.locations;
    }

    String[] getProperties() {
        return this.properties;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        MergedTestPropertySources that = (MergedTestPropertySources)other;
        if (!Arrays.equals(this.locations, that.locations)) {
            return false;
        }
        return Arrays.equals(this.properties, that.properties);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.locations);
        result = 31 * result + Arrays.hashCode(this.properties);
        return result;
    }

    public String toString() {
        return new ToStringCreator((Object)this, new DefaultToStringStyler(new SimpleValueStyler())).append("locations", this.locations).append("properties", this.properties).toString();
    }
}

