/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.composite;

import com.jhlabs.composite.RGBComposite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;

public final class NegationComposite
extends RGBComposite {
    public NegationComposite(float alpha) {
        super(alpha);
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new Context(this.extraAlpha, srcColorModel, dstColorModel);
    }

    static class Context
    extends RGBComposite.RGBCompositeContext {
        public Context(float alpha, ColorModel srcColorModel, ColorModel dstColorModel) {
            super(alpha, srcColorModel, dstColorModel);
        }

        @Override
        public void composeRGB(int[] src, int[] dst, float alpha) {
            int w = src.length;
            int i2 = 0;
            while (i2 < w) {
                int sr = src[i2];
                int dir = dst[i2];
                int sg = src[i2 + 1];
                int dig = dst[i2 + 1];
                int sb = src[i2 + 2];
                int dib = dst[i2 + 2];
                int sa = src[i2 + 3];
                int dia = dst[i2 + 3];
                int dor = 255 - Math.abs(255 - sr - dir);
                int dog = 255 - Math.abs(255 - sg - dig);
                int dob = 255 - Math.abs(255 - sb - dib);
                float a = alpha * (float)sa / 255.0f;
                float ac = 1.0f - a;
                dst[i2] = (int)(a * (float)dor + ac * (float)dir);
                dst[i2 + 1] = (int)(a * (float)dog + ac * (float)dig);
                dst[i2 + 2] = (int)(a * (float)dob + ac * (float)dib);
                dst[i2 + 3] = (int)((float)sa * alpha + (float)dia * ac);
                i2 += 4;
            }
        }
    }
}

