/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.Colormap;
import com.jhlabs.image.ImageMath;

public class ArrayColormap
implements Colormap,
Cloneable {
    protected int[] map;

    public ArrayColormap() {
        this.map = new int[256];
    }

    public ArrayColormap(int[] map) {
        this.map = map;
    }

    public Object clone() {
        try {
            ArrayColormap g = (ArrayColormap)super.clone();
            g.map = (int[])this.map.clone();
            return g;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setMap(int[] map) {
        this.map = map;
    }

    public int[] getMap() {
        return this.map;
    }

    @Override
    public int getColor(float v) {
        int n = (int)(v * 255.0f);
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return this.map[n];
    }

    public void setColorInterpolated(int index, int firstIndex, int lastIndex, int color) {
        int firstColor = this.map[firstIndex];
        int lastColor = this.map[lastIndex];
        int i2 = firstIndex;
        while (i2 <= index) {
            this.map[i2] = ImageMath.mixColors((float)(i2 - firstIndex) / (float)(index - firstIndex), firstColor, color);
            ++i2;
        }
        i2 = index;
        while (i2 < lastIndex) {
            this.map[i2] = ImageMath.mixColors((float)(i2 - index) / (float)(lastIndex - index), color, lastColor);
            ++i2;
        }
    }

    public void setColorRange(int firstIndex, int lastIndex, int color1, int color2) {
        int i2 = firstIndex;
        while (i2 <= lastIndex) {
            this.map[i2] = ImageMath.mixColors((float)(i2 - firstIndex) / (float)(lastIndex - firstIndex), color1, color2);
            ++i2;
        }
    }

    public void setColorRange(int firstIndex, int lastIndex, int color) {
        int i2 = firstIndex;
        while (i2 <= lastIndex) {
            this.map[i2] = color;
            ++i2;
        }
    }

    public void setColor(int index, int color) {
        this.map[index] = color;
    }
}

