/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.controller;

import com.roma.romaapi.service.ApiService;
import com.roma.romaapi.service.CaptchaService;
import com.roma.romaapi.utils.CustomResponse;
import com.roma.romaapi.utils.UUIDUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
public class ApiController {
    private Integer timeout = 600;
    @Autowired
    CaptchaService captchaService;
    @Autowired
    ApiService apiService;
    @Autowired
    private UUIDUtil uuidUtil;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @RequestMapping(value={"/login/verifyCode"})
    public Map<String, Object> loginVerifyCode() throws IOException {
        return this.captchaService.captchaCreator();
    }

    @RequestMapping(value={"/api/login"})
    public Map login(HttpServletRequest request2) {
        Map<String, String[]> maps = request2.getParameterMap();
        Map<String, Object> loginResult = this.apiService.login(maps);
        return CustomResponse.formatResponse(loginResult);
    }

    @RequestMapping(value={"/api/userInfo"})
    public Map userInfo(@RequestHeader(value="Authorization") String authorization) {
        Map<String, Object> loginResult = this.apiService.userInfo(authorization);
        return CustomResponse.formatResponse(loginResult);
    }

    @RequestMapping(value={"/api/logout"})
    public Map logout(@RequestHeader(value="Authorization") String authorization) {
        Map<String, Object> loginResult = this.apiService.logout(authorization);
        return CustomResponse.formatResponse(loginResult);
    }
}

