/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class PageDao {
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public Map dbQueryForMap(String pageCode) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("page_code", pageCode);
            Map<String, Object> resMap2 = this.namedParameterJdbcTemplate.queryForMap("SELECT `page_json` FROM `page_details` where `page_code` = :page_code", paramMap);
            return resMap2;
        }
        catch (EmptyResultDataAccessException e) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("sysErrorCode", "500");
            resultMap.put("sysErrorMessage", "operation failed");
            return resultMap;
        }
    }

    public List<Map<String, Object>> getMenuForList() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("type_menu", "menu");
        paramMap.put("type_dir", "dir");
        String sql = " SELECT  `rp`.`id`,`rp`.`parent_id`,`rp`.`icon`,`rp`.`type`,`rp`.`value` AS `path`,`pd`.`front_path` AS `url`,`rp`.`display_name` AS `label` FROM `roma_permissions` AS `rp` LEFT JOIN `page_details` AS `pd` ON `pd`.`id`=`rp`.`page_id` WHERE `rp`.`is_enable`=1 AND (`rp`.`type`=:type_menu OR `rp`.`type`=:type_dir )  ORDER BY `rp`.`sort` ASC ";
        List<Map<String, Object>> resMap2 = this.namedParameterJdbcTemplate.queryForList(sql, paramMap);
        return resMap2;
    }
}

