/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.service;

import com.roma.romaapi.dao.ApiDao;
import com.roma.romaapi.utils.CommonUtil;
import com.roma.romaapi.utils.JWTUtil;
import com.roma.romaapi.utils.SecurityUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class ApiService {
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private ApiDao apiDao;
    @Autowired
    SecurityUtils securityUtils;
    @Autowired
    JWTUtil jwtUtil;
    @Autowired
    CommonUtil commonUtil;

    public Map<String, Object> login(Map<String, String[]> maps) {
        String userName = maps.get("api_name")[0];
        String password = maps.get("api_password")[0];
        String captcha = maps.get("api_captcha")[0];
        String captchaToken = maps.get("captchaToken")[0];
        String captchaTokenValue = this.redisTemplate.opsForValue().get(captchaToken);
        HashMap<String, Object> loginResult = new HashMap<String, Object>();
        Map<String, Object> UserInfo = this.apiDao.adminInfoQueryForMap(userName);
        if (UserInfo.containsKey("sysErrorCode")) {
            loginResult.put("sysErrorCode", "500");
            loginResult.put("sysErrorMessage", "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
            return loginResult;
        }
        Object adminPassword = UserInfo.get("admin_password");
        String stringAdminPassword = adminPassword.toString();
        if (!this.securityUtils.matchesPassword(password, stringAdminPassword)) {
            loginResult.put("sysErrorCode", "500");
            loginResult.put("sysErrorMessage", "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
            return loginResult;
        }
        if (!Boolean.TRUE.equals(this.redisTemplate.hasKey(captchaToken)) || !Objects.equals(captchaTokenValue, captcha)) {
            loginResult.put("sysErrorCode", "500");
            loginResult.put("sysErrorMessage", "\u9a8c\u8bc1\u7801\u9519\u8bef");
            return loginResult;
        }
        HashMap<String, Object> jwtInfo = new HashMap<String, Object>();
        Object userId = UserInfo.get("id");
        String stringUserId = userId.toString();
        jwtInfo.put("id", stringUserId);
        jwtInfo.put("loginTime", "" + System.currentTimeMillis() / 1000L);
        jwtInfo.put("name", userName);
        String jwtToken = this.jwtUtil.getToken(jwtInfo);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("loginToken", jwtToken);
        return map;
    }

    public Map<String, Object> userInfo(String headerToken) {
        Map<String, Object> userInfo;
        String userId = this.commonUtil.getUserIdByHeaderAuthorization(headerToken);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (userId.length() > 0 && (userInfo = this.apiDao.userInfoByIdQueryForMap(userId)).containsKey("admin_name")) {
            map.put("userName", userInfo.get("admin_name"));
        }
        return map;
    }

    public Map<String, Object> logout(String headerToken) {
        Boolean logout = this.commonUtil.logoutDeleteRedisToken(headerToken);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysErrorCode", "50000");
        return map;
    }
}

