/*
 * Decompiled with CFR 0.152.
 */
package com.roma.romaapi.service;

import com.roma.romaapi.dao.PageDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PageService {
    @Autowired
    PageDao pageDao;

    public Map getPageJsonByCode(String pageCode) {
        Map ret = this.pageDao.dbQueryForMap(pageCode);
        return ret;
    }

    public List menu() {
        List<Map<String, Object>> menuData = this.pageDao.getMenuForList();
        List<Map<String, Object>> renderMenu = this.renderMenu(menuData);
        System.out.println("========================" + String.valueOf(renderMenu) + "=======================================");
        List<Map<String, Object>> treeMenu = this.treeMenu(renderMenu);
        return treeMenu;
    }

    private List<Map<String, Object>> renderMenu(List<Map<String, Object>> menuData) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
        for (int i2 = 0; i2 < menuData.size(); ++i2) {
            Map<String, Object> map = menuData.get(i2);
            String menuType = (String)map.get("type");
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.put("id", map.get("id"));
            tempMap.put("parent_id", map.get("parent_id"));
            tempMap.put("label", (String)map.get("label"));
            tempMap.put("icon", (String)map.get("icon"));
            boolean visible = true;
            if (map.containsKey("visible")) {
                Object objectVisible = map.get("visible");
                String stringVisible = objectVisible.toString();
                visible = stringVisible.equals("0") || stringVisible.equals("1");
            }
            tempMap.put("visible", visible);
            switch (menuType) {
                case "menu": {
                    String path = (String)map.get("path");
                    if (path == null || path.equals("")) break;
                    tempMap.put("url", (String)map.get("url"));
                    tempMap.put("schemaApi", path);
                    break;
                }
                case "dir": {
                    break;
                }
                case "link": {
                    tempMap.put("link", (String)map.get("path"));
                }
            }
            retList.add(tempMap);
        }
        return retList;
    }

    private List<Map<String, Object>> treeMenu(List<Map<String, Object>> renderMenu) {
        ArrayList<Map<String, Object>> pList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> tmp : renderMenu) {
            Object parentId = tmp.get("parent_id");
            String stringParentId = parentId.toString();
            Object dataId = tmp.get("id");
            String stringDataId = dataId.toString();
            if (!stringParentId.equals("0")) continue;
            List<?> children = this.menuChild(stringDataId, renderMenu);
            if (children == null || children.size() == 0) {
                tmp.put("leaf", true);
            } else {
                tmp.put("children", children);
            }
            pList.add(tmp);
        }
        return pList;
    }

    private List<?> menuChild(String id, List<Map<String, Object>> data) {
        ArrayList<Map<String, Object>> lists = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : data) {
            Object parentId = map.get("parent_id");
            String stringParentId = parentId.toString();
            Object dataId = map.get("id");
            String stringDataId = dataId.toString();
            if (!stringParentId.equals(id)) continue;
            List<?> children = this.menuChild(stringDataId, data);
            if (children == null || children.size() == 0) {
                map.put("leaf", true);
            } else {
                map.put("children", children);
            }
            lists.add(map);
        }
        return lists;
    }
}

