/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ConnectionBuilder;
import io.lettuce.core.ConnectionEvents;
import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.event.EventBus;
import io.lettuce.core.event.connection.ConnectionActivatedEvent;
import io.lettuce.core.event.connection.ConnectionDeactivatedEvent;
import io.lettuce.core.protocol.CommandHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.local.LocalAddress;
import java.net.SocketAddress;

class ConnectionEventTrigger
extends ChannelInboundHandlerAdapter {
    private final ConnectionEvents connectionEvents;
    private final RedisChannelHandler<?, ?> connection;
    private final EventBus eventBus;

    ConnectionEventTrigger(ConnectionEvents connectionEvents, RedisChannelHandler<?, ?> connection, EventBus eventBus) {
        this.connectionEvents = connectionEvents;
        this.connection = connection;
        this.eventBus = eventBus;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        this.connectionEvents.fireEventRedisConnected(this.connection, channel.remoteAddress());
        CommandHandler commandHandler = ConnectionEventTrigger.getCommandHandler(ctx);
        String epid = commandHandler.getEndpoint().getId();
        this.eventBus.publish(new ConnectionActivatedEvent(ConnectionEventTrigger.getRedisUri(channel), epid, commandHandler.getChannelId(), ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.connectionEvents.fireEventRedisDisconnected(this.connection);
        CommandHandler commandHandler = ConnectionEventTrigger.getCommandHandler(ctx);
        String epid = commandHandler.getEndpoint().getId();
        this.eventBus.publish(new ConnectionDeactivatedEvent(ConnectionEventTrigger.getRedisUri(ctx.channel()), epid, commandHandler.getChannelId(), ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
        super.channelInactive(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.connectionEvents.fireEventRedisExceptionCaught(this.connection, cause);
        super.exceptionCaught(ctx, cause);
    }

    static SocketAddress remote(ChannelHandlerContext ctx) {
        if (ctx.channel() != null && ctx.channel().remoteAddress() != null) {
            return ctx.channel().remoteAddress();
        }
        return new LocalAddress("unknown");
    }

    static SocketAddress local(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        if (channel != null && channel.localAddress() != null) {
            return channel.localAddress();
        }
        return LocalAddress.ANY;
    }

    private static String getRedisUri(Channel channel) {
        String redisUri = null;
        if (channel.hasAttr(ConnectionBuilder.REDIS_URI)) {
            redisUri = channel.attr(ConnectionBuilder.REDIS_URI).get();
        }
        return redisUri;
    }

    private static CommandHandler getCommandHandler(ChannelHandlerContext ctx) {
        return ctx.pipeline().get(CommandHandler.class);
    }
}

