/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.support;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.support.ConnectionWrapping;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.commons.pool2.impl.SoftReferenceObjectPool;

public abstract class ConnectionPoolSupport {
    private ConnectionPoolSupport() {
    }

    public static <T extends StatefulConnection<?, ?>> GenericObjectPool<T> createGenericObjectPool(Supplier<T> connectionSupplier, GenericObjectPoolConfig<T> config) {
        return ConnectionPoolSupport.createGenericObjectPool(connectionSupplier, config, true);
    }

    public static <T extends StatefulConnection<?, ?>> GenericObjectPool<T> createGenericObjectPool(Supplier<T> connectionSupplier, GenericObjectPoolConfig<T> config, final boolean wrapConnections) {
        LettuceAssert.notNull(connectionSupplier, "Connection supplier must not be null");
        LettuceAssert.notNull(config, "GenericObjectPoolConfig must not be null");
        final AtomicReference poolRef = new AtomicReference();
        GenericObjectPool pool = new GenericObjectPool<T>(new RedisPooledObjectFactory<T>(connectionSupplier), config){

            @Override
            public T borrowObject() throws Exception {
                return wrapConnections ? (StatefulConnection)ConnectionWrapping.wrapConnection(super.borrowObject(), (ConnectionWrapping.Origin)poolRef.get()) : (StatefulConnection)super.borrowObject();
            }

            @Override
            public void returnObject(T obj) {
                if (wrapConnections && obj instanceof ConnectionWrapping.HasTargetConnection) {
                    super.returnObject(((ConnectionWrapping.HasTargetConnection)obj).getTargetConnection());
                    return;
                }
                super.returnObject(obj);
            }
        };
        poolRef.set(new ObjectPoolWrapper(pool));
        return pool;
    }

    public static <T extends StatefulConnection<?, ?>> SoftReferenceObjectPool<T> createSoftReferenceObjectPool(Supplier<T> connectionSupplier) {
        return ConnectionPoolSupport.createSoftReferenceObjectPool(connectionSupplier, true);
    }

    public static <T extends StatefulConnection<?, ?>> SoftReferenceObjectPool<T> createSoftReferenceObjectPool(Supplier<T> connectionSupplier, final boolean wrapConnections) {
        LettuceAssert.notNull(connectionSupplier, "Connection supplier must not be null");
        final AtomicReference poolRef = new AtomicReference();
        SoftReferenceObjectPool pool = new SoftReferenceObjectPool<T>(new RedisPooledObjectFactory<T>(connectionSupplier)){

            @Override
            public synchronized T borrowObject() throws Exception {
                return wrapConnections ? (StatefulConnection)ConnectionWrapping.wrapConnection(super.borrowObject(), (ConnectionWrapping.Origin)poolRef.get()) : (StatefulConnection)super.borrowObject();
            }

            @Override
            public synchronized void returnObject(T obj) throws Exception {
                if (wrapConnections && obj instanceof ConnectionWrapping.HasTargetConnection) {
                    super.returnObject(((ConnectionWrapping.HasTargetConnection)obj).getTargetConnection());
                    return;
                }
                super.returnObject(obj);
            }
        };
        poolRef.set(new ObjectPoolWrapper(pool));
        return pool;
    }

    private static class ObjectPoolWrapper<T>
    implements ConnectionWrapping.Origin<T> {
        private static final CompletableFuture<Void> COMPLETED = CompletableFuture.completedFuture(null);
        private final ObjectPool<T> pool;

        ObjectPoolWrapper(ObjectPool<T> pool) {
            this.pool = pool;
        }

        @Override
        public void returnObject(T o) throws Exception {
            this.pool.returnObject(o);
        }

        @Override
        public CompletableFuture<Void> returnObjectAsync(T o) throws Exception {
            this.pool.returnObject(o);
            return COMPLETED;
        }
    }

    private static class RedisPooledObjectFactory<T extends StatefulConnection<?, ?>>
    extends BasePooledObjectFactory<T> {
        private final Supplier<T> connectionSupplier;

        RedisPooledObjectFactory(Supplier<T> connectionSupplier) {
            this.connectionSupplier = connectionSupplier;
        }

        @Override
        public T create() throws Exception {
            return (T)((StatefulConnection)this.connectionSupplier.get());
        }

        @Override
        public void destroyObject(PooledObject<T> p) throws Exception {
            ((StatefulConnection)p.getObject()).close();
        }

        @Override
        public PooledObject<T> wrap(T obj) {
            return new DefaultPooledObject<T>(obj);
        }

        @Override
        public boolean validateObject(PooledObject<T> p) {
            return ((StatefulConnection)p.getObject()).isOpen();
        }
    }
}

