/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.math.BigInteger;
import org.apache.tomcat.util.res.StringManager;

public class Asn1Parser {
    private static final StringManager sm = StringManager.getManager(Asn1Parser.class);
    private final byte[] source;
    private int pos = 0;

    public Asn1Parser(byte[] source) {
        this.source = source;
    }

    public boolean eof() {
        return this.pos == this.source.length;
    }

    public int peekTag() {
        return this.source[this.pos] & 0xFF;
    }

    public void parseTag(int tag) {
        int value = this.next();
        if (value != tag) {
            throw new IllegalArgumentException(sm.getString("asn1Parser.tagMismatch", tag, value));
        }
    }

    public void parseFullLength() {
        int len = this.parseLength();
        if (len + this.pos != this.source.length) {
            throw new IllegalArgumentException(sm.getString("asn1Parser.lengthInvalid", len, this.source.length - this.pos));
        }
    }

    public int parseLength() {
        int len = this.next();
        if (len > 127) {
            int bytes = len - 128;
            len = 0;
            for (int i2 = 0; i2 < bytes; ++i2) {
                len <<= 8;
                len += this.next();
            }
        }
        return len;
    }

    public BigInteger parseInt() {
        this.parseTag(2);
        int len = this.parseLength();
        byte[] val2 = new byte[len];
        System.arraycopy(this.source, this.pos, val2, 0, len);
        this.pos += len;
        return new BigInteger(val2);
    }

    public void parseBytes(byte[] dest) {
        System.arraycopy(this.source, this.pos, dest, 0, dest.length);
        this.pos += dest.length;
    }

    private int next() {
        return this.source[this.pos++] & 0xFF;
    }
}

