/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.data.Index;
import org.assertj.core.error.ConditionAndGroupGenericParameterTypeShouldBeTheSame;
import org.assertj.core.error.ElementsShouldBe;
import org.assertj.core.error.ElementsShouldBeAtLeast;
import org.assertj.core.error.ElementsShouldBeAtMost;
import org.assertj.core.error.ElementsShouldBeExactly;
import org.assertj.core.error.ElementsShouldHave;
import org.assertj.core.error.ElementsShouldHaveAtLeast;
import org.assertj.core.error.ElementsShouldHaveAtMost;
import org.assertj.core.error.ElementsShouldHaveExactly;
import org.assertj.core.error.ElementsShouldNotBe;
import org.assertj.core.error.ElementsShouldNotHave;
import org.assertj.core.error.ShouldBeAnArray;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldBeSorted;
import org.assertj.core.error.ShouldBeSubsetOf;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainAnyOf;
import org.assertj.core.error.ShouldContainAtIndex;
import org.assertj.core.error.ShouldContainExactly;
import org.assertj.core.error.ShouldContainExactlyInAnyOrder;
import org.assertj.core.error.ShouldContainNull;
import org.assertj.core.error.ShouldContainOnly;
import org.assertj.core.error.ShouldContainOnlyNulls;
import org.assertj.core.error.ShouldContainSequence;
import org.assertj.core.error.ShouldContainSubsequence;
import org.assertj.core.error.ShouldContainsOnlyOnce;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotContainAtIndex;
import org.assertj.core.error.ShouldNotContainNull;
import org.assertj.core.error.ShouldNotContainSequence;
import org.assertj.core.error.ShouldNotContainSubsequence;
import org.assertj.core.error.ShouldNotHaveDuplicates;
import org.assertj.core.error.ShouldOnlyHaveElementsOfTypes;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.IterableDiff;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.ArrayWrapperList;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class Arrays {
    private static final Arrays INSTANCE = new Arrays();
    private final ComparisonStrategy comparisonStrategy;

    public static Arrays instance() {
        return INSTANCE;
    }

    public Arrays() {
        this(StandardComparisonStrategy.instance());
    }

    public Arrays(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (!(this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy)) {
            return null;
        }
        return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
    }

    @VisibleForTesting
    public ComparisonStrategy getComparisonStrategy() {
        return this.comparisonStrategy;
    }

    public static void assertIsArray(AssertionInfo info2, Object array) {
        if (!org.assertj.core.util.Arrays.isArray(array)) {
            throw Failures.instance().failure(info2, ShouldBeAnArray.shouldBeAnArray(array));
        }
    }

    void assertNullOrEmpty(AssertionInfo info2, Failures failures, Object array) {
        if (array != null && !Arrays.isArrayEmpty(array)) {
            throw failures.failure(info2, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(array));
        }
    }

    void assertEmpty(AssertionInfo info2, Failures failures, Object array) {
        Arrays.assertNotNull(info2, array);
        if (!Arrays.isArrayEmpty(array)) {
            throw failures.failure(info2, ShouldBeEmpty.shouldBeEmpty(array));
        }
    }

    void assertHasSize(AssertionInfo info2, Object array, int expectedSize) {
        Arrays.assertNotNull(info2, array);
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(array);
        CommonValidations.checkSizes(array, sizeOfActual, expectedSize, info2);
    }

    void assertHasSizeGreaterThan(AssertionInfo info2, Object array, int boundary) {
        Arrays.assertNotNull(info2, array);
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(array);
        CommonValidations.checkSizeGreaterThan(array, boundary, sizeOfActual, info2);
    }

    void assertHasSizeGreaterThanOrEqualTo(AssertionInfo info2, Object array, int boundary) {
        Arrays.assertNotNull(info2, array);
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(array);
        CommonValidations.checkSizeGreaterThanOrEqualTo(array, boundary, sizeOfActual, info2);
    }

    void assertHasSizeLessThan(AssertionInfo info2, Object array, int boundary) {
        Arrays.assertNotNull(info2, array);
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(array);
        CommonValidations.checkSizeLessThan(array, boundary, sizeOfActual, info2);
    }

    void assertHasSizeLessThanOrEqualTo(AssertionInfo info2, Object array, int expectedSize) {
        Arrays.assertNotNull(info2, array);
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(array);
        CommonValidations.checkSizeLessThanOrEqualTo(array, expectedSize, sizeOfActual, info2);
    }

    void assertHasSizeBetween(AssertionInfo info2, Object array, int lowerBoundary, int higherBoundary) {
        Arrays.assertNotNull(info2, array);
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(array);
        CommonValidations.checkSizeBetween(array, lowerBoundary, higherBoundary, sizeOfActual, info2);
    }

    void assertHasSameSizeAs(AssertionInfo info2, Object array, Iterable<?> other) {
        Arrays.assertNotNull(info2, array);
        CommonValidations.hasSameSizeAsCheck(info2, array, other, org.assertj.core.util.Arrays.sizeOf(array));
    }

    public void assertHasSameSizeAs(AssertionInfo info2, Object array, Object other) {
        Arrays.assertNotNull(info2, array);
        Arrays.assertIsArray(info2, array);
        Arrays.assertIsArray(info2, other);
        CommonValidations.hasSameSizeAsCheck(info2, array, other, org.assertj.core.util.Arrays.sizeOf(array));
    }

    @VisibleForTesting
    public void assertContains(AssertionInfo info2, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info2, actual, values)) {
            return;
        }
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        int valueCount = org.assertj.core.util.Arrays.sizeOf(values);
        for (int i2 = 0; i2 < valueCount; ++i2) {
            Object value = Array.get(values, i2);
            if (this.arrayContains(actual, value)) continue;
            notFound.add(value);
        }
        if (!notFound.isEmpty()) {
            throw failures.failure(info2, ShouldContain.shouldContain(actual, values, notFound, this.comparisonStrategy));
        }
    }

    void assertcontainsAll(AssertionInfo info2, Failures failures, Object array, Iterable<?> iterable) {
        if (iterable == null) {
            throw CommonErrors.iterableToLookForIsNull();
        }
        Arrays.assertNotNull(info2, array);
        Object[] values = Lists.newArrayList(iterable).toArray();
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        for (Object value : values) {
            if (this.arrayContains(array, value)) continue;
            notFound.add(value);
        }
        if (!notFound.isEmpty()) {
            throw failures.failure(info2, ShouldContain.shouldContain(array, values, notFound, this.comparisonStrategy));
        }
    }

    void assertContains(AssertionInfo info2, Failures failures, Object array, Object value, Index index) {
        Arrays.assertNotNull(info2, array);
        this.assertNotEmpty(info2, failures, array);
        CommonValidations.checkIndexValueIsValid(index, org.assertj.core.util.Arrays.sizeOf(array) - 1);
        Object actualElement = Array.get(array, index.value);
        if (!this.areEqual(actualElement, value)) {
            throw failures.failure(info2, ShouldContainAtIndex.shouldContainAtIndex(array, value, index, Array.get(array, index.value), this.comparisonStrategy));
        }
    }

    void assertNotEmpty(AssertionInfo info2, Failures failures, Object array) {
        Arrays.assertNotNull(info2, array);
        if (Arrays.isArrayEmpty(array)) {
            throw failures.failure(info2, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    void assertDoesNotContain(AssertionInfo info2, Failures failures, Object array, Object value, Index index) {
        Arrays.assertNotNull(info2, array);
        CommonValidations.checkIndexValueIsValid(index, Integer.MAX_VALUE);
        if (index.value >= org.assertj.core.util.Arrays.sizeOf(array)) {
            return;
        }
        if (this.areEqual(Array.get(array, index.value), value)) {
            throw failures.failure(info2, ShouldNotContainAtIndex.shouldNotContainAtIndex(array, value, index, this.comparisonStrategy));
        }
    }

    void assertContainsOnly(AssertionInfo info2, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info2, actual, values)) {
            return;
        }
        List notExpected = Arrays.asList(actual);
        List notFound = Arrays.asList(values);
        for (Object value : Arrays.asList(values)) {
            if (!this.iterableContains(notExpected, value)) continue;
            this.iterableRemoves(notExpected, value);
            this.iterableRemoves(notFound, value);
        }
        if (!notExpected.isEmpty() || !notFound.isEmpty()) {
            throw failures.failure(info2, ShouldContainOnly.shouldContainOnly(actual, values, notFound, notExpected, this.comparisonStrategy));
        }
    }

    void assertContainsOnlyNulls(AssertionInfo info2, Failures failures, Object[] actual) {
        Arrays.assertNotNull(info2, actual);
        if (actual.length == 0) {
            throw failures.failure(info2, ShouldContainOnlyNulls.shouldContainOnlyNulls(actual));
        }
        ArrayList<Object> nonNullElements = new ArrayList<Object>();
        for (Object element : actual) {
            if (element == null) continue;
            nonNullElements.add(element);
        }
        if (nonNullElements.size() > 0) {
            throw failures.failure(info2, ShouldContainOnlyNulls.shouldContainOnlyNulls(actual, nonNullElements));
        }
    }

    void assertContainsExactly(AssertionInfo info2, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info2, actual, values)) {
            return;
        }
        Arrays.assertIsArray(info2, actual);
        Arrays.assertIsArray(info2, values);
        List actualAsList = Arrays.asList(actual);
        IterableDiff diff = IterableDiff.diff(actualAsList, Arrays.asList(values), this.comparisonStrategy);
        if (!diff.differencesFound()) {
            int arrayLength = org.assertj.core.util.Arrays.sizeOf(actual);
            for (int i2 = 0; i2 < arrayLength; ++i2) {
                Object expectedElement;
                Object actualElement = Array.get(actual, i2);
                if (this.areEqual(actualElement, expectedElement = Array.get(values, i2))) continue;
                throw failures.failure(info2, ShouldContainExactly.elementsDifferAtIndex(actualElement, expectedElement, i2, this.comparisonStrategy));
            }
            return;
        }
        throw failures.failure(info2, ShouldContainExactly.shouldContainExactly(actual, Arrays.asList(values), diff.missing, diff.unexpected, this.comparisonStrategy));
    }

    void assertContainsExactlyInAnyOrder(AssertionInfo info2, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info2, actual, values)) {
            return;
        }
        List notExpected = Arrays.asList(actual);
        List notFound = Arrays.asList(values);
        for (Object value : Arrays.asList(values)) {
            if (!this.iterableContains(notExpected, value)) continue;
            this.iterablesRemoveFirst(notExpected, value);
            this.iterablesRemoveFirst(notFound, value);
        }
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            return;
        }
        throw failures.failure(info2, ShouldContainExactlyInAnyOrder.shouldContainExactlyInAnyOrder(actual, values, notFound, notExpected, this.comparisonStrategy));
    }

    void assertContainsOnlyOnce(AssertionInfo info2, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info2, actual, values)) {
            return;
        }
        Iterable<?> actualDuplicates = this.comparisonStrategy.duplicatesFrom(Arrays.asList(actual));
        LinkedHashSet notFound = new LinkedHashSet();
        LinkedHashSet notOnlyOnce = new LinkedHashSet();
        for (Object expectedElement : Arrays.asList(values)) {
            if (!this.arrayContains(actual, expectedElement)) {
                notFound.add(expectedElement);
                continue;
            }
            if (!this.iterableContains(actualDuplicates, expectedElement)) continue;
            notOnlyOnce.add(expectedElement);
        }
        if (!notFound.isEmpty() || !notOnlyOnce.isEmpty()) {
            throw failures.failure(info2, ShouldContainsOnlyOnce.shouldContainsOnlyOnce(actual, values, notFound, notOnlyOnce, this.comparisonStrategy));
        }
    }

    private boolean iterableContains(Iterable<?> actual, Object value) {
        return this.comparisonStrategy.iterableContains(actual, value);
    }

    private void iterablesRemoveFirst(Collection<?> actual, Object value) {
        this.comparisonStrategy.iterablesRemoveFirst(actual, value);
    }

    private void iterableRemoves(Collection<?> actual, Object value) {
        this.comparisonStrategy.iterableRemoves(actual, value);
    }

    void assertContainsSequence(AssertionInfo info2, Failures failures, Object actual, Object sequence) {
        if (Arrays.commonChecks(info2, actual, sequence)) {
            return;
        }
        int lastIndexWhereSequenceCanBeFound = org.assertj.core.util.Arrays.sizeOf(actual) - org.assertj.core.util.Arrays.sizeOf(sequence);
        for (int actualIndex = 0; actualIndex <= lastIndexWhereSequenceCanBeFound; ++actualIndex) {
            if (!this.containsSequenceAtGivenIndex(actualIndex, actual, sequence)) continue;
            return;
        }
        throw failures.failure(info2, ShouldContainSequence.shouldContainSequence(actual, sequence, this.comparisonStrategy));
    }

    void assertDoesNotContainSequence(AssertionInfo info2, Failures failures, Object actual, Object sequence) {
        if (Arrays.commonChecks(info2, actual, sequence)) {
            return;
        }
        int lastIndexWhereSequenceCanBeFound = org.assertj.core.util.Arrays.sizeOf(actual) - org.assertj.core.util.Arrays.sizeOf(sequence);
        for (int actualIndex = 0; actualIndex <= lastIndexWhereSequenceCanBeFound; ++actualIndex) {
            if (!this.containsSequenceAtGivenIndex(actualIndex, actual, sequence)) continue;
            throw failures.failure(info2, ShouldNotContainSequence.shouldNotContainSequence(actual, sequence, actualIndex, this.comparisonStrategy));
        }
    }

    private boolean containsSequenceAtGivenIndex(int actualStartIndex, Object actualArray, Object sequence) {
        int sequenceSize = org.assertj.core.util.Arrays.sizeOf(sequence);
        for (int i2 = 0; i2 < sequenceSize; ++i2) {
            if (this.areEqual(Array.get(sequence, i2), Array.get(actualArray, i2 + actualStartIndex))) continue;
            return false;
        }
        return true;
    }

    void assertContainsSubsequence(AssertionInfo info2, Failures failures, Object actual, Object subsequence) {
        int sizeOfSubsequence;
        if (Arrays.commonChecks(info2, actual, subsequence)) {
            return;
        }
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(actual);
        if (sizeOfActual < (sizeOfSubsequence = org.assertj.core.util.Arrays.sizeOf(subsequence))) {
            throw failures.failure(info2, ShouldContainSubsequence.actualDoesNotHaveEnoughElementsToContainSubsequence(actual, subsequence));
        }
        int subsequenceIndex = 0;
        for (int actualIndex = 0; actualIndex < sizeOfActual && subsequenceIndex < sizeOfSubsequence; ++actualIndex) {
            if (!this.areEqual(Array.get(actual, actualIndex), Array.get(subsequence, subsequenceIndex))) continue;
            ++subsequenceIndex;
        }
        if (subsequenceIndex < sizeOfSubsequence) {
            throw failures.failure(info2, ShouldContainSubsequence.shouldContainSubsequence(actual, subsequence, subsequenceIndex, this.comparisonStrategy));
        }
    }

    void assertHasOnlyElementsOfTypes(AssertionInfo info2, Failures failures, Object actual, Class<?>[] expectedTypes) {
        Arrays.checkIsNotNull(expectedTypes);
        Arrays.assertNotNull(info2, actual);
        ArrayList nonMatchingElements = Lists.newArrayList();
        for (Object value : Arrays.asList(actual)) {
            boolean matching = false;
            for (Class<?> expectedType : expectedTypes) {
                if (!expectedType.isInstance(value)) continue;
                matching = true;
            }
            if (matching) continue;
            nonMatchingElements.add(value);
        }
        if (!nonMatchingElements.isEmpty()) {
            throw failures.failure(info2, ShouldOnlyHaveElementsOfTypes.shouldOnlyHaveElementsOfTypes(actual, expectedTypes, nonMatchingElements));
        }
    }

    void assertDoesNotContainSubsequence(AssertionInfo info2, Failures failures, Object actual, Object subsequence) {
        if (Arrays.commonChecks(info2, actual, subsequence)) {
            return;
        }
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(actual);
        int sizeOfSubsequence = org.assertj.core.util.Arrays.sizeOf(subsequence);
        int lastIndexWhereEndOfSubsequenceCanBeFound = sizeOfActual - sizeOfSubsequence;
        int subsequenceIndex = 0;
        int subsequenceStartIndex = 0;
        for (int actualIndex = 0; actualIndex <= lastIndexWhereEndOfSubsequenceCanBeFound && subsequenceIndex < sizeOfSubsequence; ++actualIndex) {
            if (!this.areEqual(Array.get(actual, actualIndex), Array.get(subsequence, subsequenceIndex))) continue;
            if (subsequenceIndex == 0) {
                subsequenceStartIndex = actualIndex;
            }
            ++subsequenceIndex;
            ++lastIndexWhereEndOfSubsequenceCanBeFound;
            if (subsequenceIndex != sizeOfSubsequence) continue;
            throw failures.failure(info2, ShouldNotContainSubsequence.shouldNotContainSubsequence(actual, subsequence, this.comparisonStrategy, subsequenceStartIndex));
        }
    }

    private boolean areEqual(Object actual, Object other) {
        return this.comparisonStrategy.areEqual(actual, other);
    }

    void assertDoesNotContain(AssertionInfo info2, Failures failures, Object array, Object values) {
        Arrays.checkIsNotNullAndNotEmpty(values);
        Arrays.assertNotNull(info2, array);
        LinkedHashSet<Object> found = new LinkedHashSet<Object>();
        int valuesSize = org.assertj.core.util.Arrays.sizeOf(values);
        for (int i2 = 0; i2 < valuesSize; ++i2) {
            Object value = Array.get(values, i2);
            if (!this.arrayContains(array, value)) continue;
            found.add(value);
        }
        if (!found.isEmpty()) {
            throw failures.failure(info2, ShouldNotContain.shouldNotContain(array, values, found, this.comparisonStrategy));
        }
    }

    private boolean arrayContains(Object array, Object value) {
        return this.comparisonStrategy.arrayContains(array, value);
    }

    void assertDoesNotHaveDuplicates(AssertionInfo info2, Failures failures, Object array) {
        Arrays.assertNotNull(info2, array);
        ArrayWrapperList wrapped = ArrayWrapperList.wrap(array);
        Iterable<?> duplicates = this.comparisonStrategy.duplicatesFrom(wrapped);
        if (!IterableUtil.isNullOrEmpty(duplicates)) {
            throw failures.failure(info2, ShouldNotHaveDuplicates.shouldNotHaveDuplicates(array, duplicates, this.comparisonStrategy));
        }
    }

    void assertStartsWith(AssertionInfo info2, Failures failures, Object actual, Object sequence) {
        if (Arrays.commonChecks(info2, actual, sequence)) {
            return;
        }
        int sequenceSize = org.assertj.core.util.Arrays.sizeOf(sequence);
        int arraySize = org.assertj.core.util.Arrays.sizeOf(actual);
        if (arraySize < sequenceSize) {
            throw this.arrayDoesNotStartWithSequence(info2, failures, actual, sequence);
        }
        for (int i2 = 0; i2 < sequenceSize; ++i2) {
            if (this.areEqual(Array.get(sequence, i2), Array.get(actual, i2))) continue;
            throw this.arrayDoesNotStartWithSequence(info2, failures, actual, sequence);
        }
    }

    private static boolean commonChecks(AssertionInfo info2, Object actual, Object sequence) {
        Arrays.checkNulls(info2, actual, sequence);
        if (Arrays.isArrayEmpty(actual) && Arrays.isArrayEmpty(sequence)) {
            return true;
        }
        Arrays.failIfEmptySinceActualIsNotEmpty(sequence);
        return false;
    }

    private static void checkNulls(AssertionInfo info2, Object actual, Object sequence) {
        Arrays.checkIsNotNull(sequence);
        Arrays.assertNotNull(info2, actual);
    }

    private AssertionError arrayDoesNotStartWithSequence(AssertionInfo info2, Failures failures, Object array, Object sequence) {
        return failures.failure(info2, ShouldStartWith.shouldStartWith(array, sequence, this.comparisonStrategy));
    }

    void assertEndsWith(AssertionInfo info2, Failures failures, Object actual, Object first, Object[] rest) {
        Object[] sequence = org.assertj.core.util.Arrays.prepend(first, rest);
        this.assertEndsWith(info2, failures, actual, sequence);
    }

    void assertEndsWith(AssertionInfo info2, Failures failures, Object actual, Object sequence) {
        Arrays.checkNulls(info2, actual, sequence);
        int sequenceSize = org.assertj.core.util.Arrays.sizeOf(sequence);
        int arraySize = org.assertj.core.util.Arrays.sizeOf(actual);
        if (arraySize < sequenceSize) {
            throw this.arrayDoesNotEndWithSequence(info2, failures, actual, sequence);
        }
        for (int i2 = 0; i2 < sequenceSize; ++i2) {
            int sequenceIndex = sequenceSize - (i2 + 1);
            int arrayIndex = arraySize - (i2 + 1);
            if (this.areEqual(Array.get(sequence, sequenceIndex), Array.get(actual, arrayIndex))) continue;
            throw this.arrayDoesNotEndWithSequence(info2, failures, actual, sequence);
        }
    }

    public void assertIsSubsetOf(AssertionInfo info2, Failures failures, Object actual, Iterable<?> values) {
        Arrays.assertNotNull(info2, actual);
        CommonValidations.checkIterableIsNotNull(values);
        ArrayList extra = Lists.newArrayList();
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(actual);
        for (int i2 = 0; i2 < sizeOfActual; ++i2) {
            Object actualElement = Array.get(actual, i2);
            if (this.iterableContains(values, actualElement)) continue;
            extra.add(actualElement);
        }
        if (extra.size() > 0) {
            throw failures.failure(info2, ShouldBeSubsetOf.shouldBeSubsetOf(actual, values, extra, this.comparisonStrategy));
        }
    }

    void assertContainsNull(AssertionInfo info2, Failures failures, Object array) {
        Arrays.assertNotNull(info2, array);
        if (!this.arrayContains(array, null)) {
            throw failures.failure(info2, ShouldContainNull.shouldContainNull(array));
        }
    }

    void assertDoesNotContainNull(AssertionInfo info2, Failures failures, Object array) {
        Arrays.assertNotNull(info2, array);
        if (this.arrayContains(array, null)) {
            throw failures.failure(info2, ShouldNotContainNull.shouldNotContainNull(array));
        }
    }

    public <E> void assertAre(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        List<E> notMatchingCondition = this.getElementsNotMatchingCondition(info2, failures, conditions, array, condition);
        if (!notMatchingCondition.isEmpty()) {
            throw failures.failure(info2, ElementsShouldBe.elementsShouldBe(array, notMatchingCondition, condition));
        }
    }

    public <E> void assertAreNot(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (!matchingElements.isEmpty()) {
            throw failures.failure(info2, ElementsShouldNotBe.elementsShouldNotBe(array, matchingElements, condition));
        }
    }

    public <E> void assertHave(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        List<E> notMatchingCondition = this.getElementsNotMatchingCondition(info2, failures, conditions, array, condition);
        if (!notMatchingCondition.isEmpty()) {
            throw failures.failure(info2, ElementsShouldHave.elementsShouldHave(array, notMatchingCondition, condition));
        }
    }

    public <E> void assertHaveNot(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (!matchingElements.isEmpty()) {
            throw failures.failure(info2, ElementsShouldNotHave.elementsShouldNotHave(array, matchingElements, condition));
        }
    }

    public <E> void assertAreAtLeast(AssertionInfo info2, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (matchingElements.size() < times) {
            throw failures.failure(info2, ElementsShouldBeAtLeast.elementsShouldBeAtLeast(array, times, condition));
        }
    }

    public <E> void assertAreAtMost(AssertionInfo info2, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (matchingElements.size() > times) {
            throw failures.failure(info2, ElementsShouldBeAtMost.elementsShouldBeAtMost(array, times, condition));
        }
    }

    public <E> void assertAreExactly(AssertionInfo info2, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (matchingElements.size() != times) {
            throw failures.failure(info2, ElementsShouldBeExactly.elementsShouldBeExactly(array, times, condition));
        }
    }

    public <E> void assertHaveAtLeast(AssertionInfo info2, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (matchingElements.size() < times) {
            throw failures.failure(info2, ElementsShouldHaveAtLeast.elementsShouldHaveAtLeast(array, times, condition));
        }
    }

    public <E> void assertHaveAtMost(AssertionInfo info2, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (matchingElements.size() > times) {
            throw failures.failure(info2, ElementsShouldHaveAtMost.elementsShouldHaveAtMost(array, times, condition));
        }
    }

    public <E> void assertHaveExactly(AssertionInfo info2, Failures failures, Conditions conditions, Object array, int times, Condition<E> condition) {
        List<E> matchingElements = this.getElementsMatchingCondition(info2, failures, conditions, array, condition);
        if (matchingElements.size() != times) {
            throw failures.failure(info2, ElementsShouldHaveExactly.elementsShouldHaveExactly(array, times, condition));
        }
    }

    public void assertContainsAnyOf(AssertionInfo info2, Failures failures, Object actual, Object values) {
        if (Arrays.commonChecks(info2, actual, values)) {
            return;
        }
        Arrays.assertIsArray(info2, actual);
        Arrays.assertIsArray(info2, values);
        List valuesToSearchFor = Arrays.asList(values);
        for (Object element : Arrays.asList(actual)) {
            if (!this.iterableContains(valuesToSearchFor, element)) continue;
            return;
        }
        throw failures.failure(info2, ShouldContainAnyOf.shouldContainAnyOf(actual, values, this.comparisonStrategy));
    }

    private <E> List<E> getElementsMatchingCondition(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        return this.filterElements(info2, failures, conditions, array, condition, false);
    }

    private <E> List<E> getElementsNotMatchingCondition(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition) {
        return this.filterElements(info2, failures, conditions, array, condition, true);
    }

    private <E> List<E> filterElements(AssertionInfo info2, Failures failures, Conditions conditions, Object array, Condition<E> condition, boolean negateCondition) throws AssertionError {
        Arrays.assertNotNull(info2, array);
        conditions.assertIsNotNull(condition);
        try {
            LinkedList<Object> filteredElements = new LinkedList<Object>();
            int arraySize = org.assertj.core.util.Arrays.sizeOf(array);
            for (int i2 = 0; i2 < arraySize; ++i2) {
                Object element = Array.get(array, i2);
                if (negateCondition == condition.matches(element)) continue;
                filteredElements.add(element);
            }
            return filteredElements;
        }
        catch (ClassCastException e) {
            throw failures.failure(info2, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(array, condition));
        }
    }

    void assertIsSorted(AssertionInfo info2, Failures failures, Object array) {
        Arrays.assertNotNull(info2, array);
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            Comparator<?> comparator = ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
            Arrays.assertIsSortedAccordingToComparator(info2, failures, array, comparator);
            return;
        }
        if (org.assertj.core.util.Arrays.sizeOf(array) == 0) {
            return;
        }
        Arrays.assertThatArrayComponentTypeIsSortable(info2, failures, array);
        try {
            Comparable<Object>[] comparableArray = Arrays.arrayOfComparableItems(array);
            if (comparableArray.length <= 1) {
                return;
            }
            for (int i2 = 0; i2 < comparableArray.length - 1; ++i2) {
                if (comparableArray[i2].compareTo(comparableArray[i2 + 1]) <= 0) continue;
                throw failures.failure(info2, ShouldBeSorted.shouldBeSorted(i2, array));
            }
        }
        catch (ClassCastException e) {
            throw failures.failure(info2, ShouldBeSorted.shouldHaveMutuallyComparableElements(array));
        }
    }

    static <T> void assertIsSortedAccordingToComparator(AssertionInfo info2, Failures failures, Object array, Comparator<T> comparator) {
        Arrays.assertNotNull(info2, array);
        java.util.Objects.requireNonNull(comparator, "The given comparator should not be null");
        try {
            List<T> arrayAsList = Arrays.asList(array);
            if (arrayAsList.size() == 0) {
                return;
            }
            if (arrayAsList.size() == 1) {
                comparator.compare(arrayAsList.get(0), arrayAsList.get(0));
                return;
            }
            for (int i2 = 0; i2 < arrayAsList.size() - 1; ++i2) {
                if (comparator.compare(arrayAsList.get(i2), arrayAsList.get(i2 + 1)) <= 0) continue;
                throw failures.failure(info2, ShouldBeSorted.shouldBeSortedAccordingToGivenComparator(i2, array, comparator));
            }
        }
        catch (ClassCastException e) {
            throw failures.failure(info2, ShouldBeSorted.shouldHaveComparableElementsAccordingToGivenComparator(array, comparator));
        }
    }

    private static <T> List<T> asList(Object array) {
        if (array == null) {
            return null;
        }
        Preconditions.checkArgument(org.assertj.core.util.Arrays.isArray(array), "The object should be an array", new Object[0]);
        int length = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i2 = 0; i2 < length; ++i2) {
            list.add(Array.get(array, i2));
        }
        return list;
    }

    private static Comparable<Object>[] arrayOfComparableItems(Object array) {
        ArrayWrapperList arrayWrapperList = ArrayWrapperList.wrap(array);
        Comparable[] arrayOfComparableItems = new Comparable[arrayWrapperList.size()];
        for (int i2 = 0; i2 < arrayWrapperList.size(); ++i2) {
            arrayOfComparableItems[i2] = (Comparable)arrayWrapperList.get(i2);
        }
        return arrayOfComparableItems;
    }

    private static void assertThatArrayComponentTypeIsSortable(AssertionInfo info2, Failures failures, Object array) {
        ArrayWrapperList arrayAsList = ArrayWrapperList.wrap(array);
        Class<?> arrayComponentType = arrayAsList.getComponentType();
        if (arrayComponentType.isPrimitive()) {
            return;
        }
        if (!Comparable.class.isAssignableFrom(arrayComponentType)) {
            throw failures.failure(info2, ShouldBeSorted.shouldHaveMutuallyComparableElements(array));
        }
    }

    private static void checkIsNotNullAndNotEmpty(Object values) {
        Arrays.checkIsNotNull(values);
        if (Arrays.isArrayEmpty(values)) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    private static void checkIsNotNull(Object values) {
        if (values == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    static boolean isArrayEmpty(Object array) {
        return org.assertj.core.util.Arrays.sizeOf(array) == 0;
    }

    private AssertionError arrayDoesNotEndWithSequence(AssertionInfo info2, Failures failures, Object array, Object sequence) {
        return failures.failure(info2, ShouldEndWith.shouldEndWith(array, sequence, this.comparisonStrategy));
    }

    static void assertNotNull(AssertionInfo info2, Object array) {
        Objects.instance().assertNotNull(info2, array);
    }

    private static void failIfEmptySinceActualIsNotEmpty(Object values) {
        if (Arrays.isArrayEmpty(values)) {
            throw new AssertionError((Object)"actual is not empty while group of values to look for is.");
        }
    }
}

